/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.kafka.cruisecontrol;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.common.UnknownPropertyPreserving;
import io.strimzi.api.kafka.model.kafka.cruisecontrol.KafkaAutoRebalanceMode;
import io.strimzi.crdgenerator.annotations.Description;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"mode", "brokers"})
public class KafkaAutoRebalanceStatusBrokers
implements UnknownPropertyPreserving {
    private KafkaAutoRebalanceMode mode;
    private List<Integer> brokers;
    private Map<String, Object> additionalProperties;

    @Description(value="Mode for which there is an auto-rebalancing operation in progress or queued, when brokers are added or removed. The possible modes are `add-brokers` and `remove-brokers`.")
    public KafkaAutoRebalanceMode getMode() {
        return this.mode;
    }

    public void setMode(KafkaAutoRebalanceMode mode) {
        this.mode = mode;
    }

    @Description(value="List of broker IDs involved in an auto-rebalancing operation related to the current mode. \nThe list contains one of the following: \n\n* Broker IDs for a current auto-rebalance. \n* Broker IDs for a queued auto-rebalance (if a previous auto-rebalance is still in progress). \n")
    public List<Integer> getBrokers() {
        return this.brokers;
    }

    public void setBrokers(List<Integer> brokers) {
        this.brokers = brokers;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties != null ? this.additionalProperties : Map.of();
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>(2);
        }
        this.additionalProperties.put(name, value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaAutoRebalanceStatusBrokers)) {
            return false;
        }
        KafkaAutoRebalanceStatusBrokers other = (KafkaAutoRebalanceStatusBrokers)o;
        if (!other.canEqual(this)) {
            return false;
        }
        KafkaAutoRebalanceMode this$mode = this.getMode();
        KafkaAutoRebalanceMode other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode)) {
            return false;
        }
        List<Integer> this$brokers = this.getBrokers();
        List<Integer> other$brokers = other.getBrokers();
        if (this$brokers == null ? other$brokers != null : !((Object)this$brokers).equals(other$brokers)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaAutoRebalanceStatusBrokers;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        KafkaAutoRebalanceMode $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
        List<Integer> $brokers = this.getBrokers();
        result = result * 59 + ($brokers == null ? 43 : ((Object)$brokers).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }

    public String toString() {
        return "KafkaAutoRebalanceStatusBrokers(mode=" + String.valueOf((Object)this.getMode()) + ", brokers=" + String.valueOf(this.getBrokers()) + ", additionalProperties=" + String.valueOf(this.getAdditionalProperties()) + ")";
    }
}

