/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.kafka.cruisecontrol;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.common.template.ContainerTemplate;
import io.strimzi.api.kafka.model.common.template.ContainerTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.ContainerTemplateFluent;
import io.strimzi.api.kafka.model.common.template.DeploymentTemplate;
import io.strimzi.api.kafka.model.common.template.DeploymentTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.DeploymentTemplateFluent;
import io.strimzi.api.kafka.model.common.template.InternalServiceTemplate;
import io.strimzi.api.kafka.model.common.template.InternalServiceTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.InternalServiceTemplateFluent;
import io.strimzi.api.kafka.model.common.template.PodDisruptionBudgetTemplate;
import io.strimzi.api.kafka.model.common.template.PodDisruptionBudgetTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.PodDisruptionBudgetTemplateFluent;
import io.strimzi.api.kafka.model.common.template.PodTemplate;
import io.strimzi.api.kafka.model.common.template.PodTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.PodTemplateFluent;
import io.strimzi.api.kafka.model.common.template.ResourceTemplate;
import io.strimzi.api.kafka.model.common.template.ResourceTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.ResourceTemplateFluent;
import io.strimzi.api.kafka.model.kafka.cruisecontrol.CruiseControlTemplate;
import java.util.Objects;
import java.util.Optional;

public class CruiseControlTemplateFluent<A extends CruiseControlTemplateFluent<A>>
extends BaseFluent<A> {
    private DeploymentTemplateBuilder deployment;
    private PodTemplateBuilder pod;
    private InternalServiceTemplateBuilder apiService;
    private PodDisruptionBudgetTemplateBuilder podDisruptionBudget;
    private ContainerTemplateBuilder cruiseControlContainer;
    private ContainerTemplateBuilder tlsSidecarContainer;
    private ResourceTemplateBuilder serviceAccount;

    public CruiseControlTemplateFluent() {
    }

    public CruiseControlTemplateFluent(CruiseControlTemplate instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(CruiseControlTemplate instance) {
        CruiseControlTemplate cruiseControlTemplate = instance = instance != null ? instance : new CruiseControlTemplate();
        if (instance != null) {
            this.withDeployment(instance.getDeployment());
            this.withPod(instance.getPod());
            this.withApiService(instance.getApiService());
            this.withPodDisruptionBudget(instance.getPodDisruptionBudget());
            this.withCruiseControlContainer(instance.getCruiseControlContainer());
            this.withTlsSidecarContainer(instance.getTlsSidecarContainer());
            this.withServiceAccount(instance.getServiceAccount());
        }
    }

    public DeploymentTemplate buildDeployment() {
        return this.deployment != null ? this.deployment.build() : null;
    }

    public A withDeployment(DeploymentTemplate deployment) {
        this._visitables.remove((Object)"deployment");
        if (deployment != null) {
            this.deployment = new DeploymentTemplateBuilder(deployment);
            this._visitables.get((Object)"deployment").add(this.deployment);
        } else {
            this.deployment = null;
            this._visitables.get((Object)"deployment").remove((Object)this.deployment);
        }
        return (A)((Object)this);
    }

    public boolean hasDeployment() {
        return this.deployment != null;
    }

    public DeploymentNested<A> withNewDeployment() {
        return new DeploymentNested(null);
    }

    public DeploymentNested<A> withNewDeploymentLike(DeploymentTemplate item) {
        return new DeploymentNested(item);
    }

    public DeploymentNested<A> editDeployment() {
        return this.withNewDeploymentLike(Optional.ofNullable(this.buildDeployment()).orElse(null));
    }

    public DeploymentNested<A> editOrNewDeployment() {
        return this.withNewDeploymentLike(Optional.ofNullable(this.buildDeployment()).orElse(new DeploymentTemplateBuilder().build()));
    }

    public DeploymentNested<A> editOrNewDeploymentLike(DeploymentTemplate item) {
        return this.withNewDeploymentLike(Optional.ofNullable(this.buildDeployment()).orElse(item));
    }

    public PodTemplate buildPod() {
        return this.pod != null ? this.pod.build() : null;
    }

    public A withPod(PodTemplate pod) {
        this._visitables.remove((Object)"pod");
        if (pod != null) {
            this.pod = new PodTemplateBuilder(pod);
            this._visitables.get((Object)"pod").add(this.pod);
        } else {
            this.pod = null;
            this._visitables.get((Object)"pod").remove((Object)this.pod);
        }
        return (A)((Object)this);
    }

    public boolean hasPod() {
        return this.pod != null;
    }

    public PodNested<A> withNewPod() {
        return new PodNested(null);
    }

    public PodNested<A> withNewPodLike(PodTemplate item) {
        return new PodNested(item);
    }

    public PodNested<A> editPod() {
        return this.withNewPodLike(Optional.ofNullable(this.buildPod()).orElse(null));
    }

    public PodNested<A> editOrNewPod() {
        return this.withNewPodLike(Optional.ofNullable(this.buildPod()).orElse(new PodTemplateBuilder().build()));
    }

    public PodNested<A> editOrNewPodLike(PodTemplate item) {
        return this.withNewPodLike(Optional.ofNullable(this.buildPod()).orElse(item));
    }

    public InternalServiceTemplate buildApiService() {
        return this.apiService != null ? this.apiService.build() : null;
    }

    public A withApiService(InternalServiceTemplate apiService) {
        this._visitables.remove((Object)"apiService");
        if (apiService != null) {
            this.apiService = new InternalServiceTemplateBuilder(apiService);
            this._visitables.get((Object)"apiService").add(this.apiService);
        } else {
            this.apiService = null;
            this._visitables.get((Object)"apiService").remove((Object)this.apiService);
        }
        return (A)((Object)this);
    }

    public boolean hasApiService() {
        return this.apiService != null;
    }

    public ApiServiceNested<A> withNewApiService() {
        return new ApiServiceNested(null);
    }

    public ApiServiceNested<A> withNewApiServiceLike(InternalServiceTemplate item) {
        return new ApiServiceNested(item);
    }

    public ApiServiceNested<A> editApiService() {
        return this.withNewApiServiceLike(Optional.ofNullable(this.buildApiService()).orElse(null));
    }

    public ApiServiceNested<A> editOrNewApiService() {
        return this.withNewApiServiceLike(Optional.ofNullable(this.buildApiService()).orElse(new InternalServiceTemplateBuilder().build()));
    }

    public ApiServiceNested<A> editOrNewApiServiceLike(InternalServiceTemplate item) {
        return this.withNewApiServiceLike(Optional.ofNullable(this.buildApiService()).orElse(item));
    }

    public PodDisruptionBudgetTemplate buildPodDisruptionBudget() {
        return this.podDisruptionBudget != null ? this.podDisruptionBudget.build() : null;
    }

    public A withPodDisruptionBudget(PodDisruptionBudgetTemplate podDisruptionBudget) {
        this._visitables.remove((Object)"podDisruptionBudget");
        if (podDisruptionBudget != null) {
            this.podDisruptionBudget = new PodDisruptionBudgetTemplateBuilder(podDisruptionBudget);
            this._visitables.get((Object)"podDisruptionBudget").add(this.podDisruptionBudget);
        } else {
            this.podDisruptionBudget = null;
            this._visitables.get((Object)"podDisruptionBudget").remove((Object)this.podDisruptionBudget);
        }
        return (A)((Object)this);
    }

    public boolean hasPodDisruptionBudget() {
        return this.podDisruptionBudget != null;
    }

    public PodDisruptionBudgetNested<A> withNewPodDisruptionBudget() {
        return new PodDisruptionBudgetNested(null);
    }

    public PodDisruptionBudgetNested<A> withNewPodDisruptionBudgetLike(PodDisruptionBudgetTemplate item) {
        return new PodDisruptionBudgetNested(item);
    }

    public PodDisruptionBudgetNested<A> editPodDisruptionBudget() {
        return this.withNewPodDisruptionBudgetLike(Optional.ofNullable(this.buildPodDisruptionBudget()).orElse(null));
    }

    public PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudget() {
        return this.withNewPodDisruptionBudgetLike(Optional.ofNullable(this.buildPodDisruptionBudget()).orElse(new PodDisruptionBudgetTemplateBuilder().build()));
    }

    public PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudgetLike(PodDisruptionBudgetTemplate item) {
        return this.withNewPodDisruptionBudgetLike(Optional.ofNullable(this.buildPodDisruptionBudget()).orElse(item));
    }

    public ContainerTemplate buildCruiseControlContainer() {
        return this.cruiseControlContainer != null ? this.cruiseControlContainer.build() : null;
    }

    public A withCruiseControlContainer(ContainerTemplate cruiseControlContainer) {
        this._visitables.remove((Object)"cruiseControlContainer");
        if (cruiseControlContainer != null) {
            this.cruiseControlContainer = new ContainerTemplateBuilder(cruiseControlContainer);
            this._visitables.get((Object)"cruiseControlContainer").add(this.cruiseControlContainer);
        } else {
            this.cruiseControlContainer = null;
            this._visitables.get((Object)"cruiseControlContainer").remove((Object)this.cruiseControlContainer);
        }
        return (A)((Object)this);
    }

    public boolean hasCruiseControlContainer() {
        return this.cruiseControlContainer != null;
    }

    public CruiseControlContainerNested<A> withNewCruiseControlContainer() {
        return new CruiseControlContainerNested(null);
    }

    public CruiseControlContainerNested<A> withNewCruiseControlContainerLike(ContainerTemplate item) {
        return new CruiseControlContainerNested(item);
    }

    public CruiseControlContainerNested<A> editCruiseControlContainer() {
        return this.withNewCruiseControlContainerLike(Optional.ofNullable(this.buildCruiseControlContainer()).orElse(null));
    }

    public CruiseControlContainerNested<A> editOrNewCruiseControlContainer() {
        return this.withNewCruiseControlContainerLike(Optional.ofNullable(this.buildCruiseControlContainer()).orElse(new ContainerTemplateBuilder().build()));
    }

    public CruiseControlContainerNested<A> editOrNewCruiseControlContainerLike(ContainerTemplate item) {
        return this.withNewCruiseControlContainerLike(Optional.ofNullable(this.buildCruiseControlContainer()).orElse(item));
    }

    public ContainerTemplate buildTlsSidecarContainer() {
        return this.tlsSidecarContainer != null ? this.tlsSidecarContainer.build() : null;
    }

    public A withTlsSidecarContainer(ContainerTemplate tlsSidecarContainer) {
        this._visitables.remove((Object)"tlsSidecarContainer");
        if (tlsSidecarContainer != null) {
            this.tlsSidecarContainer = new ContainerTemplateBuilder(tlsSidecarContainer);
            this._visitables.get((Object)"tlsSidecarContainer").add(this.tlsSidecarContainer);
        } else {
            this.tlsSidecarContainer = null;
            this._visitables.get((Object)"tlsSidecarContainer").remove((Object)this.tlsSidecarContainer);
        }
        return (A)((Object)this);
    }

    public boolean hasTlsSidecarContainer() {
        return this.tlsSidecarContainer != null;
    }

    public TlsSidecarContainerNested<A> withNewTlsSidecarContainer() {
        return new TlsSidecarContainerNested(null);
    }

    public TlsSidecarContainerNested<A> withNewTlsSidecarContainerLike(ContainerTemplate item) {
        return new TlsSidecarContainerNested(item);
    }

    public TlsSidecarContainerNested<A> editTlsSidecarContainer() {
        return this.withNewTlsSidecarContainerLike(Optional.ofNullable(this.buildTlsSidecarContainer()).orElse(null));
    }

    public TlsSidecarContainerNested<A> editOrNewTlsSidecarContainer() {
        return this.withNewTlsSidecarContainerLike(Optional.ofNullable(this.buildTlsSidecarContainer()).orElse(new ContainerTemplateBuilder().build()));
    }

    public TlsSidecarContainerNested<A> editOrNewTlsSidecarContainerLike(ContainerTemplate item) {
        return this.withNewTlsSidecarContainerLike(Optional.ofNullable(this.buildTlsSidecarContainer()).orElse(item));
    }

    public ResourceTemplate buildServiceAccount() {
        return this.serviceAccount != null ? this.serviceAccount.build() : null;
    }

    public A withServiceAccount(ResourceTemplate serviceAccount) {
        this._visitables.remove((Object)"serviceAccount");
        if (serviceAccount != null) {
            this.serviceAccount = new ResourceTemplateBuilder(serviceAccount);
            this._visitables.get((Object)"serviceAccount").add(this.serviceAccount);
        } else {
            this.serviceAccount = null;
            this._visitables.get((Object)"serviceAccount").remove((Object)this.serviceAccount);
        }
        return (A)((Object)this);
    }

    public boolean hasServiceAccount() {
        return this.serviceAccount != null;
    }

    public ServiceAccountNested<A> withNewServiceAccount() {
        return new ServiceAccountNested(null);
    }

    public ServiceAccountNested<A> withNewServiceAccountLike(ResourceTemplate item) {
        return new ServiceAccountNested(item);
    }

    public ServiceAccountNested<A> editServiceAccount() {
        return this.withNewServiceAccountLike(Optional.ofNullable(this.buildServiceAccount()).orElse(null));
    }

    public ServiceAccountNested<A> editOrNewServiceAccount() {
        return this.withNewServiceAccountLike(Optional.ofNullable(this.buildServiceAccount()).orElse(new ResourceTemplateBuilder().build()));
    }

    public ServiceAccountNested<A> editOrNewServiceAccountLike(ResourceTemplate item) {
        return this.withNewServiceAccountLike(Optional.ofNullable(this.buildServiceAccount()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CruiseControlTemplateFluent that = (CruiseControlTemplateFluent)((Object)o);
        if (!Objects.equals((Object)this.deployment, (Object)that.deployment)) {
            return false;
        }
        if (!Objects.equals((Object)this.pod, (Object)that.pod)) {
            return false;
        }
        if (!Objects.equals((Object)this.apiService, (Object)that.apiService)) {
            return false;
        }
        if (!Objects.equals((Object)this.podDisruptionBudget, (Object)that.podDisruptionBudget)) {
            return false;
        }
        if (!Objects.equals((Object)this.cruiseControlContainer, (Object)that.cruiseControlContainer)) {
            return false;
        }
        if (!Objects.equals((Object)this.tlsSidecarContainer, (Object)that.tlsSidecarContainer)) {
            return false;
        }
        return Objects.equals((Object)this.serviceAccount, (Object)that.serviceAccount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.deployment, this.pod, this.apiService, this.podDisruptionBudget, this.cruiseControlContainer, this.tlsSidecarContainer, this.serviceAccount, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.deployment != null) {
            sb.append("deployment:");
            sb.append(String.valueOf((Object)this.deployment) + ",");
        }
        if (this.pod != null) {
            sb.append("pod:");
            sb.append(String.valueOf((Object)this.pod) + ",");
        }
        if (this.apiService != null) {
            sb.append("apiService:");
            sb.append(String.valueOf((Object)this.apiService) + ",");
        }
        if (this.podDisruptionBudget != null) {
            sb.append("podDisruptionBudget:");
            sb.append(String.valueOf((Object)this.podDisruptionBudget) + ",");
        }
        if (this.cruiseControlContainer != null) {
            sb.append("cruiseControlContainer:");
            sb.append(String.valueOf((Object)this.cruiseControlContainer) + ",");
        }
        if (this.tlsSidecarContainer != null) {
            sb.append("tlsSidecarContainer:");
            sb.append(String.valueOf((Object)this.tlsSidecarContainer) + ",");
        }
        if (this.serviceAccount != null) {
            sb.append("serviceAccount:");
            sb.append((Object)this.serviceAccount);
        }
        sb.append("}");
        return sb.toString();
    }

    public class DeploymentNested<N>
    extends DeploymentTemplateFluent<DeploymentNested<N>>
    implements Nested<N> {
        DeploymentTemplateBuilder builder;

        DeploymentNested(DeploymentTemplate item) {
            this.builder = new DeploymentTemplateBuilder(this, item);
        }

        public N and() {
            return (N)CruiseControlTemplateFluent.this.withDeployment(this.builder.build());
        }

        public N endDeployment() {
            return this.and();
        }
    }

    public class PodNested<N>
    extends PodTemplateFluent<PodNested<N>>
    implements Nested<N> {
        PodTemplateBuilder builder;

        PodNested(PodTemplate item) {
            this.builder = new PodTemplateBuilder(this, item);
        }

        public N and() {
            return (N)CruiseControlTemplateFluent.this.withPod(this.builder.build());
        }

        public N endPod() {
            return this.and();
        }
    }

    public class ApiServiceNested<N>
    extends InternalServiceTemplateFluent<ApiServiceNested<N>>
    implements Nested<N> {
        InternalServiceTemplateBuilder builder;

        ApiServiceNested(InternalServiceTemplate item) {
            this.builder = new InternalServiceTemplateBuilder(this, item);
        }

        public N and() {
            return (N)CruiseControlTemplateFluent.this.withApiService(this.builder.build());
        }

        public N endApiService() {
            return this.and();
        }
    }

    public class PodDisruptionBudgetNested<N>
    extends PodDisruptionBudgetTemplateFluent<PodDisruptionBudgetNested<N>>
    implements Nested<N> {
        PodDisruptionBudgetTemplateBuilder builder;

        PodDisruptionBudgetNested(PodDisruptionBudgetTemplate item) {
            this.builder = new PodDisruptionBudgetTemplateBuilder(this, item);
        }

        public N and() {
            return (N)CruiseControlTemplateFluent.this.withPodDisruptionBudget(this.builder.build());
        }

        public N endPodDisruptionBudget() {
            return this.and();
        }
    }

    public class CruiseControlContainerNested<N>
    extends ContainerTemplateFluent<CruiseControlContainerNested<N>>
    implements Nested<N> {
        ContainerTemplateBuilder builder;

        CruiseControlContainerNested(ContainerTemplate item) {
            this.builder = new ContainerTemplateBuilder(this, item);
        }

        public N and() {
            return (N)CruiseControlTemplateFluent.this.withCruiseControlContainer(this.builder.build());
        }

        public N endCruiseControlContainer() {
            return this.and();
        }
    }

    public class TlsSidecarContainerNested<N>
    extends ContainerTemplateFluent<TlsSidecarContainerNested<N>>
    implements Nested<N> {
        ContainerTemplateBuilder builder;

        TlsSidecarContainerNested(ContainerTemplate item) {
            this.builder = new ContainerTemplateBuilder(this, item);
        }

        public N and() {
            return (N)CruiseControlTemplateFluent.this.withTlsSidecarContainer(this.builder.build());
        }

        public N endTlsSidecarContainer() {
            return this.and();
        }
    }

    public class ServiceAccountNested<N>
    extends ResourceTemplateFluent<ServiceAccountNested<N>>
    implements Nested<N> {
        ResourceTemplateBuilder builder;

        ServiceAccountNested(ResourceTemplate item) {
            this.builder = new ResourceTemplateBuilder(this, item);
        }

        public N and() {
            return (N)CruiseControlTemplateFluent.this.withServiceAccount(this.builder.build());
        }

        public N endServiceAccount() {
            return this.and();
        }
    }
}

