/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.kafka.cruisecontrol;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.strimzi.api.annotations.DeprecatedProperty;
import io.strimzi.api.kafka.model.common.HasConfigurableLogging;
import io.strimzi.api.kafka.model.common.HasConfigurableMetrics;
import io.strimzi.api.kafka.model.common.HasLivenessProbe;
import io.strimzi.api.kafka.model.common.HasReadinessProbe;
import io.strimzi.api.kafka.model.common.JvmOptions;
import io.strimzi.api.kafka.model.common.Logging;
import io.strimzi.api.kafka.model.common.Probe;
import io.strimzi.api.kafka.model.common.UnknownPropertyPreserving;
import io.strimzi.api.kafka.model.common.metrics.MetricsConfig;
import io.strimzi.api.kafka.model.kafka.cruisecontrol.BrokerCapacity;
import io.strimzi.api.kafka.model.kafka.cruisecontrol.CruiseControlApiUsers;
import io.strimzi.api.kafka.model.kafka.cruisecontrol.CruiseControlTemplate;
import io.strimzi.api.kafka.model.kafka.cruisecontrol.KafkaAutoRebalanceConfiguration;
import io.strimzi.api.kafka.model.kafka.entityoperator.TlsSidecar;
import io.strimzi.crdgenerator.annotations.CelValidation;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.DescriptionFile;
import io.strimzi.crdgenerator.annotations.KubeLink;
import io.strimzi.crdgenerator.annotations.MinimumItems;
import io.strimzi.crdgenerator.annotations.PresentInVersions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@DescriptionFile
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"image", "tlsSidecar", "resources", "livenessProbe", "readinessProbe", "jvmOptions", "logging", "template", "brokerCapacity", "config", "metricsConfig", "apiUsers", "autoRebalance"})
public class CruiseControlSpec
implements HasConfigurableMetrics,
HasConfigurableLogging,
HasLivenessProbe,
HasReadinessProbe,
UnknownPropertyPreserving {
    public static final String FORBIDDEN_PREFIXES = "bootstrap.servers, client.id, zookeeper., network., security., failed.brokers.zk.path,webserver.http., webserver.api.urlprefix, webserver.session.path, webserver.accesslog., two.step., request.reason.required,metric.reporter.sampler.bootstrap.servers, capacity.config.file, self.healing., ssl., kafka.broker.failure.detection.enable, topic.config.provider.class";
    public static final String FORBIDDEN_PREFIX_EXCEPTIONS = "ssl.cipher.suites, ssl.protocol, ssl.enabled.protocols, webserver.http.cors.enabled, webserver.http.cors.origin, webserver.http.cors.exposeheaders, webserver.security.enable, webserver.ssl.enable";
    private String image;
    private TlsSidecar tlsSidecar;
    private ResourceRequirements resources;
    private Probe livenessProbe;
    private Probe readinessProbe;
    private JvmOptions jvmOptions;
    private Logging logging;
    private CruiseControlTemplate template;
    private BrokerCapacity brokerCapacity;
    private Map<String, Object> config = new HashMap<String, Object>(0);
    private MetricsConfig metricsConfig;
    private CruiseControlApiUsers apiUsers;
    private List<KafkaAutoRebalanceConfiguration> autoRebalance;
    private Map<String, Object> additionalProperties = new HashMap<String, Object>(0);

    @Description(value="The container image used for Cruise Control pods. If no image name is explicitly specified, the image name corresponds to the name specified in the Cluster Operator configuration. If an image name is not defined in the Cluster Operator configuration, a default value is used.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    @DeprecatedProperty
    @Deprecated
    @Description(value="TLS sidecar configuration")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @PresentInVersions(value="v1beta2")
    public TlsSidecar getTlsSidecar() {
        return this.tlsSidecar;
    }

    @Deprecated
    public void setTlsSidecar(TlsSidecar tlsSidecar) {
        this.tlsSidecar = tlsSidecar;
    }

    @Description(value="The Cruise Control `brokerCapacity` configuration.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public BrokerCapacity getBrokerCapacity() {
        return this.brokerCapacity;
    }

    public void setBrokerCapacity(BrokerCapacity brokerCapacity) {
        this.brokerCapacity = brokerCapacity;
    }

    @Description(value="The Cruise Control configuration. For a full list of configuration options refer to https://github.com/linkedin/cruise-control/wiki/Configurations. Note that properties with the following prefixes cannot be set: bootstrap.servers, client.id, zookeeper., network., security., failed.brokers.zk.path,webserver.http., webserver.api.urlprefix, webserver.session.path, webserver.accesslog., two.step., request.reason.required,metric.reporter.sampler.bootstrap.servers, capacity.config.file, self.healing., ssl., kafka.broker.failure.detection.enable, topic.config.provider.class (with the exception of: ssl.cipher.suites, ssl.protocol, ssl.enabled.protocols, webserver.http.cors.enabled, webserver.http.cors.origin, webserver.http.cors.exposeheaders, webserver.security.enable, webserver.ssl.enable).")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, Object> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, Object> config) {
        this.config = config;
    }

    @Description(value="Configuration of the Cruise Control REST API users.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public CruiseControlApiUsers getApiUsers() {
        return this.apiUsers;
    }

    public void setApiUsers(CruiseControlApiUsers apiUsers) {
        this.apiUsers = apiUsers;
    }

    @Override
    @Description(value="Metrics configuration. Only `jmxPrometheusExporter` can be configured, as this component does not support `strimziMetricsReporter`.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @CelValidation(rules={@CelValidation.CelValidationRule(rule="self.type != 'jmxPrometheusExporter' || has(self.valueFrom)", message="valueFrom property is required"), @CelValidation.CelValidationRule(rule="self.type != 'strimziMetricsReporter'", message="value type not supported")})
    public MetricsConfig getMetricsConfig() {
        return this.metricsConfig;
    }

    @Override
    public void setMetricsConfig(MetricsConfig metricsConfig) {
        this.metricsConfig = metricsConfig;
    }

    @Override
    @Description(value="Logging configuration (Log4j 2) for Cruise Control.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Logging getLogging() {
        return this.logging;
    }

    @Override
    public void setLogging(Logging logging) {
        this.logging = logging;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Description(value="JVM Options for the Cruise Control container")
    public JvmOptions getJvmOptions() {
        return this.jvmOptions;
    }

    public void setJvmOptions(JvmOptions jvmOptions) {
        this.jvmOptions = jvmOptions;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @KubeLink(group="core", version="v1", kind="resourcerequirements")
    @Description(value="CPU and memory resources to reserve for the Cruise Control container")
    public ResourceRequirements getResources() {
        return this.resources;
    }

    public void setResources(ResourceRequirements resources) {
        this.resources = resources;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Description(value="Pod liveness checking for the Cruise Control container")
    public Probe getLivenessProbe() {
        return this.livenessProbe;
    }

    @Override
    public void setLivenessProbe(Probe livenessProbe) {
        this.livenessProbe = livenessProbe;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    @Description(value="Pod readiness checking for the Cruise Control container.")
    public Probe getReadinessProbe() {
        return this.readinessProbe;
    }

    @Override
    public void setReadinessProbe(Probe readinessProbe) {
        this.readinessProbe = readinessProbe;
    }

    @Description(value="Template to specify how Cruise Control resources, `Deployments` and `Pods`, are generated.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public CruiseControlTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(CruiseControlTemplate template) {
        this.template = template;
    }

    @Description(value="Auto-rebalancing on scaling related configuration listing the modes, when brokers are added or removed, with the corresponding rebalance template configurations.If this field is set, at least one mode has to be defined.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @MinimumItems(value=1)
    public List<KafkaAutoRebalanceConfiguration> getAutoRebalance() {
        return this.autoRebalance;
    }

    public void setAutoRebalance(List<KafkaAutoRebalanceConfiguration> autoRebalance) {
        this.autoRebalance = autoRebalance;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties != null ? this.additionalProperties : Map.of();
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>(2);
        }
        this.additionalProperties.put(name, value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CruiseControlSpec)) {
            return false;
        }
        CruiseControlSpec other = (CruiseControlSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        TlsSidecar this$tlsSidecar = this.getTlsSidecar();
        TlsSidecar other$tlsSidecar = other.getTlsSidecar();
        if (this$tlsSidecar == null ? other$tlsSidecar != null : !((Object)this$tlsSidecar).equals(other$tlsSidecar)) {
            return false;
        }
        ResourceRequirements this$resources = this.getResources();
        ResourceRequirements other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !this$resources.equals(other$resources)) {
            return false;
        }
        Probe this$livenessProbe = this.getLivenessProbe();
        Probe other$livenessProbe = other.getLivenessProbe();
        if (this$livenessProbe == null ? other$livenessProbe != null : !((Object)this$livenessProbe).equals(other$livenessProbe)) {
            return false;
        }
        Probe this$readinessProbe = this.getReadinessProbe();
        Probe other$readinessProbe = other.getReadinessProbe();
        if (this$readinessProbe == null ? other$readinessProbe != null : !((Object)this$readinessProbe).equals(other$readinessProbe)) {
            return false;
        }
        JvmOptions this$jvmOptions = this.getJvmOptions();
        JvmOptions other$jvmOptions = other.getJvmOptions();
        if (this$jvmOptions == null ? other$jvmOptions != null : !((Object)this$jvmOptions).equals(other$jvmOptions)) {
            return false;
        }
        Logging this$logging = this.getLogging();
        Logging other$logging = other.getLogging();
        if (this$logging == null ? other$logging != null : !((Object)this$logging).equals(other$logging)) {
            return false;
        }
        CruiseControlTemplate this$template = this.getTemplate();
        CruiseControlTemplate other$template = other.getTemplate();
        if (this$template == null ? other$template != null : !((Object)this$template).equals(other$template)) {
            return false;
        }
        BrokerCapacity this$brokerCapacity = this.getBrokerCapacity();
        BrokerCapacity other$brokerCapacity = other.getBrokerCapacity();
        if (this$brokerCapacity == null ? other$brokerCapacity != null : !((Object)this$brokerCapacity).equals(other$brokerCapacity)) {
            return false;
        }
        Map<String, Object> this$config = this.getConfig();
        Map<String, Object> other$config = other.getConfig();
        if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
            return false;
        }
        MetricsConfig this$metricsConfig = this.getMetricsConfig();
        MetricsConfig other$metricsConfig = other.getMetricsConfig();
        if (this$metricsConfig == null ? other$metricsConfig != null : !((Object)this$metricsConfig).equals(other$metricsConfig)) {
            return false;
        }
        CruiseControlApiUsers this$apiUsers = this.getApiUsers();
        CruiseControlApiUsers other$apiUsers = other.getApiUsers();
        if (this$apiUsers == null ? other$apiUsers != null : !((Object)this$apiUsers).equals(other$apiUsers)) {
            return false;
        }
        List<KafkaAutoRebalanceConfiguration> this$autoRebalance = this.getAutoRebalance();
        List<KafkaAutoRebalanceConfiguration> other$autoRebalance = other.getAutoRebalance();
        if (this$autoRebalance == null ? other$autoRebalance != null : !((Object)this$autoRebalance).equals(other$autoRebalance)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CruiseControlSpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        TlsSidecar $tlsSidecar = this.getTlsSidecar();
        result = result * 59 + ($tlsSidecar == null ? 43 : ((Object)$tlsSidecar).hashCode());
        ResourceRequirements $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : $resources.hashCode());
        Probe $livenessProbe = this.getLivenessProbe();
        result = result * 59 + ($livenessProbe == null ? 43 : ((Object)$livenessProbe).hashCode());
        Probe $readinessProbe = this.getReadinessProbe();
        result = result * 59 + ($readinessProbe == null ? 43 : ((Object)$readinessProbe).hashCode());
        JvmOptions $jvmOptions = this.getJvmOptions();
        result = result * 59 + ($jvmOptions == null ? 43 : ((Object)$jvmOptions).hashCode());
        Logging $logging = this.getLogging();
        result = result * 59 + ($logging == null ? 43 : ((Object)$logging).hashCode());
        CruiseControlTemplate $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : ((Object)$template).hashCode());
        BrokerCapacity $brokerCapacity = this.getBrokerCapacity();
        result = result * 59 + ($brokerCapacity == null ? 43 : ((Object)$brokerCapacity).hashCode());
        Map<String, Object> $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        MetricsConfig $metricsConfig = this.getMetricsConfig();
        result = result * 59 + ($metricsConfig == null ? 43 : ((Object)$metricsConfig).hashCode());
        CruiseControlApiUsers $apiUsers = this.getApiUsers();
        result = result * 59 + ($apiUsers == null ? 43 : ((Object)$apiUsers).hashCode());
        List<KafkaAutoRebalanceConfiguration> $autoRebalance = this.getAutoRebalance();
        result = result * 59 + ($autoRebalance == null ? 43 : ((Object)$autoRebalance).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }

    public String toString() {
        return "CruiseControlSpec(image=" + this.getImage() + ", tlsSidecar=" + String.valueOf(this.getTlsSidecar()) + ", resources=" + String.valueOf(this.getResources()) + ", livenessProbe=" + String.valueOf(this.getLivenessProbe()) + ", readinessProbe=" + String.valueOf(this.getReadinessProbe()) + ", jvmOptions=" + String.valueOf(this.getJvmOptions()) + ", logging=" + String.valueOf(this.getLogging()) + ", template=" + String.valueOf(this.getTemplate()) + ", brokerCapacity=" + String.valueOf(this.getBrokerCapacity()) + ", config=" + String.valueOf(this.getConfig()) + ", metricsConfig=" + String.valueOf(this.getMetricsConfig()) + ", apiUsers=" + String.valueOf(this.getApiUsers()) + ", autoRebalance=" + String.valueOf(this.getAutoRebalance()) + ", additionalProperties=" + String.valueOf(this.getAdditionalProperties()) + ")";
    }
}

