/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.kafka;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.strimzi.api.kafka.model.kafka.EphemeralStorage;
import io.strimzi.api.kafka.model.kafka.KRaftMetadataStorage;
import io.strimzi.api.kafka.model.kafka.PersistentClaimStorage;
import io.strimzi.api.kafka.model.kafka.Storage;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.Minimum;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=EphemeralStorage.class, name="ephemeral"), @JsonSubTypes.Type(value=PersistentClaimStorage.class, name="persistent-claim")})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class SingleVolumeStorage
extends Storage {
    private Integer id;
    private KRaftMetadataStorage kraftMetadata;

    @Override
    @Description(value="Storage type, must be either 'ephemeral' or 'persistent-claim'.")
    public abstract String getType();

    @Description(value="Storage identification number. Mandatory for storage volumes defined with a `jbod` storage type configuration.")
    @Minimum(value=0)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Description(value="Specifies whether this volume should be used for storing KRaft metadata. This property is optional. When set, the only currently supported value is `shared`. At most one volume can have this property set.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public KRaftMetadataStorage getKraftMetadata() {
        return this.kraftMetadata;
    }

    public void setKraftMetadata(KRaftMetadataStorage kraftMetadata) {
        this.kraftMetadata = kraftMetadata;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SingleVolumeStorage)) {
            return false;
        }
        SingleVolumeStorage other = (SingleVolumeStorage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        KRaftMetadataStorage this$kraftMetadata = this.getKraftMetadata();
        KRaftMetadataStorage other$kraftMetadata = other.getKraftMetadata();
        return !(this$kraftMetadata == null ? other$kraftMetadata != null : !((Object)((Object)this$kraftMetadata)).equals((Object)other$kraftMetadata));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SingleVolumeStorage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        KRaftMetadataStorage $kraftMetadata = this.getKraftMetadata();
        result = result * 59 + ($kraftMetadata == null ? 43 : ((Object)((Object)$kraftMetadata)).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "SingleVolumeStorage(super=" + super.toString() + ", id=" + this.getId() + ", kraftMetadata=" + String.valueOf((Object)this.getKraftMetadata()) + ")";
    }
}

