/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.kafka;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.annotations.DeprecatedProperty;
import io.strimzi.api.kafka.model.kafka.KafkaMetadataState;
import io.strimzi.api.kafka.model.kafka.Status;
import io.strimzi.api.kafka.model.kafka.UsedNodePoolStatus;
import io.strimzi.api.kafka.model.kafka.cruisecontrol.KafkaAutoRebalanceStatus;
import io.strimzi.api.kafka.model.kafka.listener.ListenerStatus;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.PresentInVersions;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"conditions", "observedGeneration", "listeners", "kafkaNodePools", "registeredNodeIds", "clusterId", "operatorLastSuccessfulVersion", "kafkaVersion", "kafkaMetadataVersion", "kafkaMetadataState", "autoRebalance"})
public class KafkaStatus
extends Status {
    private List<ListenerStatus> listeners;
    private List<UsedNodePoolStatus> kafkaNodePools;
    private List<Integer> registeredNodeIds;
    private String clusterId;
    private String operatorLastSuccessfulVersion;
    private String kafkaVersion;
    private String kafkaMetadataVersion;
    private KafkaMetadataState kafkaMetadataState;
    private KafkaAutoRebalanceStatus autoRebalance;

    @Description(value="Addresses of the internal and external listeners")
    public List<ListenerStatus> getListeners() {
        return this.listeners;
    }

    public void setListeners(List<ListenerStatus> listeners) {
        this.listeners = listeners;
    }

    @Description(value="List of the KafkaNodePools used by this Kafka cluster")
    public List<UsedNodePoolStatus> getKafkaNodePools() {
        return this.kafkaNodePools;
    }

    public void setKafkaNodePools(List<UsedNodePoolStatus> kafkaNodePools) {
        this.kafkaNodePools = kafkaNodePools;
    }

    @Deprecated
    @DeprecatedProperty(description="The `registeredNodeIds` property is deprecated and it is not used anymore. It will be removed in the future.")
    @PresentInVersions(value="v1beta2")
    @Description(value="Registered node IDs used by this Kafka cluster. This field is used for internal purposes only and will be removed in the future.")
    public List<Integer> getRegisteredNodeIds() {
        return this.registeredNodeIds;
    }

    public void setRegisteredNodeIds(List<Integer> registeredNodeIds) {
        this.registeredNodeIds = registeredNodeIds;
    }

    @Description(value="Kafka cluster Id")
    public String getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    @Description(value="The version of the Strimzi Cluster Operator which performed the last successful reconciliation.")
    public String getOperatorLastSuccessfulVersion() {
        return this.operatorLastSuccessfulVersion;
    }

    public void setOperatorLastSuccessfulVersion(String operatorLastSuccessfulVersion) {
        this.operatorLastSuccessfulVersion = operatorLastSuccessfulVersion;
    }

    @Description(value="The version of Kafka currently deployed in the cluster.")
    public String getKafkaVersion() {
        return this.kafkaVersion;
    }

    public void setKafkaVersion(String kafkaVersion) {
        this.kafkaVersion = kafkaVersion;
    }

    @Description(value="The KRaft metadata.version currently used by the Kafka cluster.")
    public String getKafkaMetadataVersion() {
        return this.kafkaMetadataVersion;
    }

    public void setKafkaMetadataVersion(String kafkaMetadataVersion) {
        this.kafkaMetadataVersion = kafkaMetadataVersion;
    }

    @Description(value="Defines where cluster metadata are stored. This property is deprecated and not used anymore.")
    @Deprecated
    @DeprecatedProperty(description="The `kafkaMetadataState` property is deprecated and will be removed in the future.")
    @PresentInVersions(value="v1beta2")
    public KafkaMetadataState getKafkaMetadataState() {
        return this.kafkaMetadataState;
    }

    public void setKafkaMetadataState(KafkaMetadataState metadataState) {
        this.kafkaMetadataState = metadataState;
    }

    @Description(value="The status of an auto-rebalancing triggered by a cluster scaling request.")
    public KafkaAutoRebalanceStatus getAutoRebalance() {
        return this.autoRebalance;
    }

    public void setAutoRebalance(KafkaAutoRebalanceStatus autoRebalance) {
        this.autoRebalance = autoRebalance;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaStatus)) {
            return false;
        }
        KafkaStatus other = (KafkaStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<ListenerStatus> this$listeners = this.getListeners();
        List<ListenerStatus> other$listeners = other.getListeners();
        if (this$listeners == null ? other$listeners != null : !((Object)this$listeners).equals(other$listeners)) {
            return false;
        }
        List<UsedNodePoolStatus> this$kafkaNodePools = this.getKafkaNodePools();
        List<UsedNodePoolStatus> other$kafkaNodePools = other.getKafkaNodePools();
        if (this$kafkaNodePools == null ? other$kafkaNodePools != null : !((Object)this$kafkaNodePools).equals(other$kafkaNodePools)) {
            return false;
        }
        List<Integer> this$registeredNodeIds = this.getRegisteredNodeIds();
        List<Integer> other$registeredNodeIds = other.getRegisteredNodeIds();
        if (this$registeredNodeIds == null ? other$registeredNodeIds != null : !((Object)this$registeredNodeIds).equals(other$registeredNodeIds)) {
            return false;
        }
        String this$clusterId = this.getClusterId();
        String other$clusterId = other.getClusterId();
        if (this$clusterId == null ? other$clusterId != null : !this$clusterId.equals(other$clusterId)) {
            return false;
        }
        String this$operatorLastSuccessfulVersion = this.getOperatorLastSuccessfulVersion();
        String other$operatorLastSuccessfulVersion = other.getOperatorLastSuccessfulVersion();
        if (this$operatorLastSuccessfulVersion == null ? other$operatorLastSuccessfulVersion != null : !this$operatorLastSuccessfulVersion.equals(other$operatorLastSuccessfulVersion)) {
            return false;
        }
        String this$kafkaVersion = this.getKafkaVersion();
        String other$kafkaVersion = other.getKafkaVersion();
        if (this$kafkaVersion == null ? other$kafkaVersion != null : !this$kafkaVersion.equals(other$kafkaVersion)) {
            return false;
        }
        String this$kafkaMetadataVersion = this.getKafkaMetadataVersion();
        String other$kafkaMetadataVersion = other.getKafkaMetadataVersion();
        if (this$kafkaMetadataVersion == null ? other$kafkaMetadataVersion != null : !this$kafkaMetadataVersion.equals(other$kafkaMetadataVersion)) {
            return false;
        }
        KafkaMetadataState this$kafkaMetadataState = this.getKafkaMetadataState();
        KafkaMetadataState other$kafkaMetadataState = other.getKafkaMetadataState();
        if (this$kafkaMetadataState == null ? other$kafkaMetadataState != null : !((Object)((Object)this$kafkaMetadataState)).equals((Object)other$kafkaMetadataState)) {
            return false;
        }
        KafkaAutoRebalanceStatus this$autoRebalance = this.getAutoRebalance();
        KafkaAutoRebalanceStatus other$autoRebalance = other.getAutoRebalance();
        return !(this$autoRebalance == null ? other$autoRebalance != null : !((Object)this$autoRebalance).equals(other$autoRebalance));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaStatus;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<ListenerStatus> $listeners = this.getListeners();
        result = result * 59 + ($listeners == null ? 43 : ((Object)$listeners).hashCode());
        List<UsedNodePoolStatus> $kafkaNodePools = this.getKafkaNodePools();
        result = result * 59 + ($kafkaNodePools == null ? 43 : ((Object)$kafkaNodePools).hashCode());
        List<Integer> $registeredNodeIds = this.getRegisteredNodeIds();
        result = result * 59 + ($registeredNodeIds == null ? 43 : ((Object)$registeredNodeIds).hashCode());
        String $clusterId = this.getClusterId();
        result = result * 59 + ($clusterId == null ? 43 : $clusterId.hashCode());
        String $operatorLastSuccessfulVersion = this.getOperatorLastSuccessfulVersion();
        result = result * 59 + ($operatorLastSuccessfulVersion == null ? 43 : $operatorLastSuccessfulVersion.hashCode());
        String $kafkaVersion = this.getKafkaVersion();
        result = result * 59 + ($kafkaVersion == null ? 43 : $kafkaVersion.hashCode());
        String $kafkaMetadataVersion = this.getKafkaMetadataVersion();
        result = result * 59 + ($kafkaMetadataVersion == null ? 43 : $kafkaMetadataVersion.hashCode());
        KafkaMetadataState $kafkaMetadataState = this.getKafkaMetadataState();
        result = result * 59 + ($kafkaMetadataState == null ? 43 : ((Object)((Object)$kafkaMetadataState)).hashCode());
        KafkaAutoRebalanceStatus $autoRebalance = this.getAutoRebalance();
        result = result * 59 + ($autoRebalance == null ? 43 : ((Object)$autoRebalance).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "KafkaStatus(super=" + super.toString() + ", listeners=" + String.valueOf(this.getListeners()) + ", kafkaNodePools=" + String.valueOf(this.getKafkaNodePools()) + ", registeredNodeIds=" + String.valueOf(this.getRegisteredNodeIds()) + ", clusterId=" + this.getClusterId() + ", operatorLastSuccessfulVersion=" + this.getOperatorLastSuccessfulVersion() + ", kafkaVersion=" + this.getKafkaVersion() + ", kafkaMetadataVersion=" + this.getKafkaMetadataVersion() + ", kafkaMetadataState=" + String.valueOf((Object)this.getKafkaMetadataState()) + ", autoRebalance=" + String.valueOf(this.getAutoRebalance()) + ")";
    }
}

