/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.kafka;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.annotations.DeprecatedProperty;
import io.strimzi.api.kafka.model.common.UnknownPropertyPreserving;
import io.strimzi.api.kafka.model.common.template.ContainerTemplate;
import io.strimzi.api.kafka.model.common.template.HasJmxSecretTemplate;
import io.strimzi.api.kafka.model.common.template.InternalServiceTemplate;
import io.strimzi.api.kafka.model.common.template.PodDisruptionBudgetTemplate;
import io.strimzi.api.kafka.model.common.template.PodTemplate;
import io.strimzi.api.kafka.model.common.template.ResourceTemplate;
import io.strimzi.api.kafka.model.common.template.StatefulSetTemplate;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.PresentInVersions;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"statefulset", "pod", "bootstrapService", "brokersService", "externalBootstrapService", "perPodService", "externalBootstrapRoute", "perPodRoute", "externalBootstrapIngress", "perPodIngress", "persistentVolumeClaim", "podDisruptionBudget", "kafkaContainer", "initContainer", "clusterCaCert", "serviceAccount", "jmxSecret", "clusterRoleBinding", "podSet"})
public class KafkaClusterTemplate
implements HasJmxSecretTemplate,
UnknownPropertyPreserving {
    private StatefulSetTemplate statefulset;
    private ResourceTemplate podSet;
    private PodTemplate pod;
    private InternalServiceTemplate bootstrapService;
    private InternalServiceTemplate brokersService;
    private ResourceTemplate externalBootstrapService;
    private ResourceTemplate perPodService;
    private ResourceTemplate externalBootstrapRoute;
    private ResourceTemplate perPodRoute;
    private ResourceTemplate externalBootstrapIngress;
    private ResourceTemplate perPodIngress;
    private ResourceTemplate persistentVolumeClaim;
    private ResourceTemplate clusterCaCert;
    private PodDisruptionBudgetTemplate podDisruptionBudget;
    private ContainerTemplate kafkaContainer;
    private ContainerTemplate initContainer;
    private ResourceTemplate clusterRoleBinding;
    private ResourceTemplate serviceAccount;
    private ResourceTemplate jmxSecret;
    private Map<String, Object> additionalProperties;

    @Description(value="Template for Kafka `StatefulSet`.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Deprecated
    @DeprecatedProperty(description="Support for StatefulSets was removed in Strimzi 0.35.0. This property is ignored.")
    @PresentInVersions(value="v1beta2")
    public StatefulSetTemplate getStatefulset() {
        return this.statefulset;
    }

    public void setStatefulset(StatefulSetTemplate statefulset) {
        this.statefulset = statefulset;
    }

    @Description(value="Template for Kafka `StrimziPodSet` resource.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ResourceTemplate getPodSet() {
        return this.podSet;
    }

    public void setPodSet(ResourceTemplate podSetTemplate) {
        this.podSet = podSetTemplate;
    }

    @Description(value="Template for Kafka `Pods`.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public PodTemplate getPod() {
        return this.pod;
    }

    public void setPod(PodTemplate pod) {
        this.pod = pod;
    }

    @Description(value="Template for Kafka bootstrap `Service`.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public InternalServiceTemplate getBootstrapService() {
        return this.bootstrapService;
    }

    public void setBootstrapService(InternalServiceTemplate bootstrapService) {
        this.bootstrapService = bootstrapService;
    }

    @Description(value="Template for Kafka broker `Service`.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public InternalServiceTemplate getBrokersService() {
        return this.brokersService;
    }

    public void setBrokersService(InternalServiceTemplate brokersService) {
        this.brokersService = brokersService;
    }

    @Description(value="Template for Kafka external bootstrap `Service`.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ResourceTemplate getExternalBootstrapService() {
        return this.externalBootstrapService;
    }

    public void setExternalBootstrapService(ResourceTemplate externalBootstrapService) {
        this.externalBootstrapService = externalBootstrapService;
    }

    @Description(value="Template for Kafka per-pod `Services` used for access from outside of Kubernetes.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ResourceTemplate getPerPodService() {
        return this.perPodService;
    }

    public void setPerPodService(ResourceTemplate perPodService) {
        this.perPodService = perPodService;
    }

    @Description(value="Template for Kafka external bootstrap `Ingress`.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ResourceTemplate getExternalBootstrapIngress() {
        return this.externalBootstrapIngress;
    }

    public void setExternalBootstrapIngress(ResourceTemplate externalBootstrapIngress) {
        this.externalBootstrapIngress = externalBootstrapIngress;
    }

    @Description(value="Template for Kafka per-pod `Ingress` used for access from outside of Kubernetes.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ResourceTemplate getPerPodIngress() {
        return this.perPodIngress;
    }

    public void setPerPodIngress(ResourceTemplate perPodIngress) {
        this.perPodIngress = perPodIngress;
    }

    @Description(value="Template for all Kafka `PersistentVolumeClaims`.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ResourceTemplate getPersistentVolumeClaim() {
        return this.persistentVolumeClaim;
    }

    public void setPersistentVolumeClaim(ResourceTemplate persistentVolumeClaim) {
        this.persistentVolumeClaim = persistentVolumeClaim;
    }

    @Description(value="Template for Kafka `PodDisruptionBudget`.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public PodDisruptionBudgetTemplate getPodDisruptionBudget() {
        return this.podDisruptionBudget;
    }

    public void setPodDisruptionBudget(PodDisruptionBudgetTemplate podDisruptionBudget) {
        this.podDisruptionBudget = podDisruptionBudget;
    }

    @Description(value="Template for Kafka external bootstrap `Route`.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ResourceTemplate getExternalBootstrapRoute() {
        return this.externalBootstrapRoute;
    }

    public void setExternalBootstrapRoute(ResourceTemplate externalBootstrapRoute) {
        this.externalBootstrapRoute = externalBootstrapRoute;
    }

    @Description(value="Template for Kafka per-pod `Routes` used for access from outside of OpenShift.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ResourceTemplate getPerPodRoute() {
        return this.perPodRoute;
    }

    public void setPerPodRoute(ResourceTemplate perPodRoute) {
        this.perPodRoute = perPodRoute;
    }

    @Description(value="Template for the Kafka broker container")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ContainerTemplate getKafkaContainer() {
        return this.kafkaContainer;
    }

    public void setKafkaContainer(ContainerTemplate kafkaContainer) {
        this.kafkaContainer = kafkaContainer;
    }

    @Description(value="Template for the Kafka init container")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ContainerTemplate getInitContainer() {
        return this.initContainer;
    }

    public void setInitContainer(ContainerTemplate initContainer) {
        this.initContainer = initContainer;
    }

    @Description(value="Template for Secret with Kafka Cluster certificate public key")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ResourceTemplate getClusterCaCert() {
        return this.clusterCaCert;
    }

    public void setClusterCaCert(ResourceTemplate clusterCaCert) {
        this.clusterCaCert = clusterCaCert;
    }

    @Description(value="Template for the Kafka ClusterRoleBinding.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ResourceTemplate getClusterRoleBinding() {
        return this.clusterRoleBinding;
    }

    public void setClusterRoleBinding(ResourceTemplate clusterRoleBinding) {
        this.clusterRoleBinding = clusterRoleBinding;
    }

    @Description(value="Template for the Kafka service account.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ResourceTemplate getServiceAccount() {
        return this.serviceAccount;
    }

    public void setServiceAccount(ResourceTemplate serviceAccount) {
        this.serviceAccount = serviceAccount;
    }

    @Override
    @Description(value="Template for Secret of the Kafka Cluster JMX authentication")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ResourceTemplate getJmxSecret() {
        return this.jmxSecret;
    }

    @Override
    public void setJmxSecret(ResourceTemplate jmxSecret) {
        this.jmxSecret = jmxSecret;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties != null ? this.additionalProperties : Map.of();
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>(2);
        }
        this.additionalProperties.put(name, value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaClusterTemplate)) {
            return false;
        }
        KafkaClusterTemplate other = (KafkaClusterTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        StatefulSetTemplate this$statefulset = this.getStatefulset();
        StatefulSetTemplate other$statefulset = other.getStatefulset();
        if (this$statefulset == null ? other$statefulset != null : !((Object)this$statefulset).equals(other$statefulset)) {
            return false;
        }
        ResourceTemplate this$podSet = this.getPodSet();
        ResourceTemplate other$podSet = other.getPodSet();
        if (this$podSet == null ? other$podSet != null : !((Object)this$podSet).equals(other$podSet)) {
            return false;
        }
        PodTemplate this$pod = this.getPod();
        PodTemplate other$pod = other.getPod();
        if (this$pod == null ? other$pod != null : !((Object)this$pod).equals(other$pod)) {
            return false;
        }
        InternalServiceTemplate this$bootstrapService = this.getBootstrapService();
        InternalServiceTemplate other$bootstrapService = other.getBootstrapService();
        if (this$bootstrapService == null ? other$bootstrapService != null : !((Object)this$bootstrapService).equals(other$bootstrapService)) {
            return false;
        }
        InternalServiceTemplate this$brokersService = this.getBrokersService();
        InternalServiceTemplate other$brokersService = other.getBrokersService();
        if (this$brokersService == null ? other$brokersService != null : !((Object)this$brokersService).equals(other$brokersService)) {
            return false;
        }
        ResourceTemplate this$externalBootstrapService = this.getExternalBootstrapService();
        ResourceTemplate other$externalBootstrapService = other.getExternalBootstrapService();
        if (this$externalBootstrapService == null ? other$externalBootstrapService != null : !((Object)this$externalBootstrapService).equals(other$externalBootstrapService)) {
            return false;
        }
        ResourceTemplate this$perPodService = this.getPerPodService();
        ResourceTemplate other$perPodService = other.getPerPodService();
        if (this$perPodService == null ? other$perPodService != null : !((Object)this$perPodService).equals(other$perPodService)) {
            return false;
        }
        ResourceTemplate this$externalBootstrapRoute = this.getExternalBootstrapRoute();
        ResourceTemplate other$externalBootstrapRoute = other.getExternalBootstrapRoute();
        if (this$externalBootstrapRoute == null ? other$externalBootstrapRoute != null : !((Object)this$externalBootstrapRoute).equals(other$externalBootstrapRoute)) {
            return false;
        }
        ResourceTemplate this$perPodRoute = this.getPerPodRoute();
        ResourceTemplate other$perPodRoute = other.getPerPodRoute();
        if (this$perPodRoute == null ? other$perPodRoute != null : !((Object)this$perPodRoute).equals(other$perPodRoute)) {
            return false;
        }
        ResourceTemplate this$externalBootstrapIngress = this.getExternalBootstrapIngress();
        ResourceTemplate other$externalBootstrapIngress = other.getExternalBootstrapIngress();
        if (this$externalBootstrapIngress == null ? other$externalBootstrapIngress != null : !((Object)this$externalBootstrapIngress).equals(other$externalBootstrapIngress)) {
            return false;
        }
        ResourceTemplate this$perPodIngress = this.getPerPodIngress();
        ResourceTemplate other$perPodIngress = other.getPerPodIngress();
        if (this$perPodIngress == null ? other$perPodIngress != null : !((Object)this$perPodIngress).equals(other$perPodIngress)) {
            return false;
        }
        ResourceTemplate this$persistentVolumeClaim = this.getPersistentVolumeClaim();
        ResourceTemplate other$persistentVolumeClaim = other.getPersistentVolumeClaim();
        if (this$persistentVolumeClaim == null ? other$persistentVolumeClaim != null : !((Object)this$persistentVolumeClaim).equals(other$persistentVolumeClaim)) {
            return false;
        }
        ResourceTemplate this$clusterCaCert = this.getClusterCaCert();
        ResourceTemplate other$clusterCaCert = other.getClusterCaCert();
        if (this$clusterCaCert == null ? other$clusterCaCert != null : !((Object)this$clusterCaCert).equals(other$clusterCaCert)) {
            return false;
        }
        PodDisruptionBudgetTemplate this$podDisruptionBudget = this.getPodDisruptionBudget();
        PodDisruptionBudgetTemplate other$podDisruptionBudget = other.getPodDisruptionBudget();
        if (this$podDisruptionBudget == null ? other$podDisruptionBudget != null : !((Object)this$podDisruptionBudget).equals(other$podDisruptionBudget)) {
            return false;
        }
        ContainerTemplate this$kafkaContainer = this.getKafkaContainer();
        ContainerTemplate other$kafkaContainer = other.getKafkaContainer();
        if (this$kafkaContainer == null ? other$kafkaContainer != null : !((Object)this$kafkaContainer).equals(other$kafkaContainer)) {
            return false;
        }
        ContainerTemplate this$initContainer = this.getInitContainer();
        ContainerTemplate other$initContainer = other.getInitContainer();
        if (this$initContainer == null ? other$initContainer != null : !((Object)this$initContainer).equals(other$initContainer)) {
            return false;
        }
        ResourceTemplate this$clusterRoleBinding = this.getClusterRoleBinding();
        ResourceTemplate other$clusterRoleBinding = other.getClusterRoleBinding();
        if (this$clusterRoleBinding == null ? other$clusterRoleBinding != null : !((Object)this$clusterRoleBinding).equals(other$clusterRoleBinding)) {
            return false;
        }
        ResourceTemplate this$serviceAccount = this.getServiceAccount();
        ResourceTemplate other$serviceAccount = other.getServiceAccount();
        if (this$serviceAccount == null ? other$serviceAccount != null : !((Object)this$serviceAccount).equals(other$serviceAccount)) {
            return false;
        }
        ResourceTemplate this$jmxSecret = this.getJmxSecret();
        ResourceTemplate other$jmxSecret = other.getJmxSecret();
        if (this$jmxSecret == null ? other$jmxSecret != null : !((Object)this$jmxSecret).equals(other$jmxSecret)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaClusterTemplate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StatefulSetTemplate $statefulset = this.getStatefulset();
        result = result * 59 + ($statefulset == null ? 43 : ((Object)$statefulset).hashCode());
        ResourceTemplate $podSet = this.getPodSet();
        result = result * 59 + ($podSet == null ? 43 : ((Object)$podSet).hashCode());
        PodTemplate $pod = this.getPod();
        result = result * 59 + ($pod == null ? 43 : ((Object)$pod).hashCode());
        InternalServiceTemplate $bootstrapService = this.getBootstrapService();
        result = result * 59 + ($bootstrapService == null ? 43 : ((Object)$bootstrapService).hashCode());
        InternalServiceTemplate $brokersService = this.getBrokersService();
        result = result * 59 + ($brokersService == null ? 43 : ((Object)$brokersService).hashCode());
        ResourceTemplate $externalBootstrapService = this.getExternalBootstrapService();
        result = result * 59 + ($externalBootstrapService == null ? 43 : ((Object)$externalBootstrapService).hashCode());
        ResourceTemplate $perPodService = this.getPerPodService();
        result = result * 59 + ($perPodService == null ? 43 : ((Object)$perPodService).hashCode());
        ResourceTemplate $externalBootstrapRoute = this.getExternalBootstrapRoute();
        result = result * 59 + ($externalBootstrapRoute == null ? 43 : ((Object)$externalBootstrapRoute).hashCode());
        ResourceTemplate $perPodRoute = this.getPerPodRoute();
        result = result * 59 + ($perPodRoute == null ? 43 : ((Object)$perPodRoute).hashCode());
        ResourceTemplate $externalBootstrapIngress = this.getExternalBootstrapIngress();
        result = result * 59 + ($externalBootstrapIngress == null ? 43 : ((Object)$externalBootstrapIngress).hashCode());
        ResourceTemplate $perPodIngress = this.getPerPodIngress();
        result = result * 59 + ($perPodIngress == null ? 43 : ((Object)$perPodIngress).hashCode());
        ResourceTemplate $persistentVolumeClaim = this.getPersistentVolumeClaim();
        result = result * 59 + ($persistentVolumeClaim == null ? 43 : ((Object)$persistentVolumeClaim).hashCode());
        ResourceTemplate $clusterCaCert = this.getClusterCaCert();
        result = result * 59 + ($clusterCaCert == null ? 43 : ((Object)$clusterCaCert).hashCode());
        PodDisruptionBudgetTemplate $podDisruptionBudget = this.getPodDisruptionBudget();
        result = result * 59 + ($podDisruptionBudget == null ? 43 : ((Object)$podDisruptionBudget).hashCode());
        ContainerTemplate $kafkaContainer = this.getKafkaContainer();
        result = result * 59 + ($kafkaContainer == null ? 43 : ((Object)$kafkaContainer).hashCode());
        ContainerTemplate $initContainer = this.getInitContainer();
        result = result * 59 + ($initContainer == null ? 43 : ((Object)$initContainer).hashCode());
        ResourceTemplate $clusterRoleBinding = this.getClusterRoleBinding();
        result = result * 59 + ($clusterRoleBinding == null ? 43 : ((Object)$clusterRoleBinding).hashCode());
        ResourceTemplate $serviceAccount = this.getServiceAccount();
        result = result * 59 + ($serviceAccount == null ? 43 : ((Object)$serviceAccount).hashCode());
        ResourceTemplate $jmxSecret = this.getJmxSecret();
        result = result * 59 + ($jmxSecret == null ? 43 : ((Object)$jmxSecret).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }

    public String toString() {
        return "KafkaClusterTemplate(statefulset=" + String.valueOf(this.getStatefulset()) + ", podSet=" + String.valueOf(this.getPodSet()) + ", pod=" + String.valueOf(this.getPod()) + ", bootstrapService=" + String.valueOf(this.getBootstrapService()) + ", brokersService=" + String.valueOf(this.getBrokersService()) + ", externalBootstrapService=" + String.valueOf(this.getExternalBootstrapService()) + ", perPodService=" + String.valueOf(this.getPerPodService()) + ", externalBootstrapRoute=" + String.valueOf(this.getExternalBootstrapRoute()) + ", perPodRoute=" + String.valueOf(this.getPerPodRoute()) + ", externalBootstrapIngress=" + String.valueOf(this.getExternalBootstrapIngress()) + ", perPodIngress=" + String.valueOf(this.getPerPodIngress()) + ", persistentVolumeClaim=" + String.valueOf(this.getPersistentVolumeClaim()) + ", clusterCaCert=" + String.valueOf(this.getClusterCaCert()) + ", podDisruptionBudget=" + String.valueOf(this.getPodDisruptionBudget()) + ", kafkaContainer=" + String.valueOf(this.getKafkaContainer()) + ", initContainer=" + String.valueOf(this.getInitContainer()) + ", clusterRoleBinding=" + String.valueOf(this.getClusterRoleBinding()) + ", serviceAccount=" + String.valueOf(this.getServiceAccount()) + ", jmxSecret=" + String.valueOf(this.getJmxSecret()) + ", additionalProperties=" + String.valueOf(this.getAdditionalProperties()) + ")";
    }
}

