/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.kafka;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.strimzi.api.kafka.model.common.UnknownPropertyPreserving;
import io.strimzi.api.kafka.model.kafka.KafkaAuthorizationCustom;
import io.strimzi.api.kafka.model.kafka.KafkaAuthorizationKeycloak;
import io.strimzi.api.kafka.model.kafka.KafkaAuthorizationOpa;
import io.strimzi.api.kafka.model.kafka.KafkaAuthorizationSimple;
import io.strimzi.crdgenerator.annotations.Description;
import java.util.HashMap;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(name="simple", value=KafkaAuthorizationSimple.class), @JsonSubTypes.Type(name="opa", value=KafkaAuthorizationOpa.class), @JsonSubTypes.Type(name="keycloak", value=KafkaAuthorizationKeycloak.class), @JsonSubTypes.Type(name="custom", value=KafkaAuthorizationCustom.class)})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class KafkaAuthorization
implements UnknownPropertyPreserving {
    private Map<String, Object> additionalProperties;

    @Description(value="Authorization type. Currently, the supported types are `simple`, `keycloak`, `opa` and `custom`. `simple` authorization type uses Kafka's built-in authorizer for authorization. `keycloak` authorization type uses Keycloak Authorization Services for authorization. `opa` authorization type uses Open Policy Agent based authorization. `custom` authorization type uses user-provided implementation for authorization. `opa` (as of Strimzi 0.46.0) and `keycloak` (as of Strimzi 0.49.0) types are deprecated and will be removed in the `v1` API version. Please use `custom` type instead.")
    public abstract String getType();

    public abstract boolean supportsAdminApi();

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties != null ? this.additionalProperties : Map.of();
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>(2);
        }
        this.additionalProperties.put(name, value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaAuthorization)) {
            return false;
        }
        KafkaAuthorization other = (KafkaAuthorization)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaAuthorization;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }

    public String toString() {
        return "KafkaAuthorization(additionalProperties=" + String.valueOf(this.getAdditionalProperties()) + ")";
    }
}

