/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.kafka;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Namespaced;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Version;
import io.strimzi.api.kafka.model.common.CustomResourceConditions;
import io.strimzi.api.kafka.model.common.UnknownPropertyPreserving;
import io.strimzi.api.kafka.model.kafka.KafkaSpec;
import io.strimzi.api.kafka.model.kafka.KafkaStatus;
import io.strimzi.crdgenerator.annotations.Crd;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.RequiredInVersions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

@JsonDeserialize
@Crd(spec=@Crd.Spec(names=@Crd.Spec.Names(kind="Kafka", plural="kafkas", shortNames={"k"}, categories={"strimzi"}), group="kafka.strimzi.io", scope="Namespaced", versions={@Crd.Spec.Version(name="v1", served=true, storage=false), @Crd.Spec.Version(name="v1beta2", served=true, storage=true, deprecated=true, deprecationWarning="Version v1beta2 of the Kafka API is deprecated. Please use the v1 version instead.")}, subresources=@Crd.Spec.Subresources(status={@Crd.Spec.Subresources.Status}), additionalPrinterColumns={@Crd.Spec.AdditionalPrinterColumn(name="Ready", description="The state of the custom resource", jsonPath=".status.conditions[?(@.type==\"Ready\")].status", type="string"), @Crd.Spec.AdditionalPrinterColumn(name="Metadata State", description="The state of the cluster metadata", jsonPath=".status.kafkaMetadataState", type="string"), @Crd.Spec.AdditionalPrinterColumn(name="Warnings", description="Warnings related to the custom resource", jsonPath=".status.conditions[?(@.type==\"Warning\")].status", type="string")}))
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"apiVersion", "kind", "metadata", "spec", "status"})
@Version(value="v1beta2")
@Group(value="kafka.strimzi.io")
public class Kafka
extends CustomResource<KafkaSpec, KafkaStatus>
implements Namespaced,
UnknownPropertyPreserving {
    private static final long serialVersionUID = 1L;
    public static final String SCOPE = "Namespaced";
    public static final List<String> VERSIONS = List.of("v1", "v1beta2");
    public static final String RESOURCE_KIND = "Kafka";
    public static final String RESOURCE_LIST_KIND = "KafkaList";
    public static final String RESOURCE_GROUP = "kafka.strimzi.io";
    public static final String RESOURCE_PLURAL = "kafkas";
    public static final String RESOURCE_SINGULAR = "kafka";
    private Map<String, Object> additionalProperties;
    private String apiVersion;
    private String kind;

    public Kafka() {
    }

    public Kafka(KafkaSpec spec, KafkaStatus status) {
        this.spec = spec;
        this.status = status;
    }

    @Description(value="The specification of the Kafka cluster.")
    @RequiredInVersions(value="v1+")
    public KafkaSpec getSpec() {
        return (KafkaSpec)super.getSpec();
    }

    @Description(value="The status of the Kafka cluster.")
    public KafkaStatus getStatus() {
        return (KafkaStatus)super.getStatus();
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties != null ? this.additionalProperties : Map.of();
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>(2);
        }
        this.additionalProperties.put(name, value);
    }

    public static Predicate<Kafka> isReady() {
        return CustomResourceConditions.isReady();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Kafka)) {
            return false;
        }
        Kafka other = (Kafka)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        if (this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties)) {
            return false;
        }
        String this$apiVersion = this.apiVersion;
        String other$apiVersion = other.apiVersion;
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
            return false;
        }
        String this$kind = this.kind;
        String other$kind = other.kind;
        return !(this$kind == null ? other$kind != null : !this$kind.equals(other$kind));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Kafka;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        String $apiVersion = this.apiVersion;
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        String $kind = this.kind;
        result = result * 59 + ($kind == null ? 43 : $kind.hashCode());
        return result;
    }

    public String toString() {
        return "Kafka(super=" + super.toString() + ", additionalProperties=" + String.valueOf(this.getAdditionalProperties()) + ", apiVersion=" + this.apiVersion + ", kind=" + this.kind + ")";
    }
}

