/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.connect.build;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.annotations.DeprecatedProperty;
import io.strimzi.api.kafka.model.connect.build.Output;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.PresentInVersions;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"image", "pushSecret", "additionalKanikoOptions", "additionalBuildOptions", "additionalPushOptions", "type"})
public class DockerOutput
extends Output {
    public static final String ALLOWED_KANIKO_OPTIONS = "--customPlatform, --custom-platform, --insecure, --insecure-pull, --insecure-registry, --log-format, --log-timestamp, --registry-mirror, --reproducible, --single-snapshot, --skip-tls-verify, --skip-tls-verify-pull, --skip-tls-verify-registry, --verbosity, --snapshotMode, --use-new-run, --registry-certificate, --registry-client-cert, --ignore-path";
    public static final String ALLOWED_BUILDAH_BUILD_OPTIONS = "--authfile, --cert-dir, --creds, --decryption-key, --retry, --retry-delay, --tls-verify";
    public static final String ALLOWED_BUILDAH_PUSH_OPTIONS = "--authfile, --cert-dir, --creds, --quiet, --retry, --retry-delay, --tls-verify";
    private String pushSecret;
    private List<String> additionalKanikoOptions;
    private List<String> additionalBuildOptions;
    private List<String> additionalPushOptions;

    @Override
    @Description(value="Must be `docker`")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getType() {
        return "docker";
    }

    @Override
    @Description(value="The full name which should be used for tagging and pushing the newly built image. For example `quay.io/my-organization/my-custom-connect:latest`. Required")
    @JsonProperty(required=true)
    public String getImage() {
        return super.getImage();
    }

    @Override
    public void setImage(String image) {
        super.setImage(image);
    }

    @Description(value="Container Registry Secret with the credentials for pushing the newly built image.")
    public String getPushSecret() {
        return this.pushSecret;
    }

    public void setPushSecret(String pushSecret) {
        this.pushSecret = pushSecret;
    }

    @Deprecated
    @DeprecatedProperty(movedToPath=".spec.build.output.additionalBuildOptions", description="The `additionalKanikoOptions` configuration is deprecated and will be removed in the `v1` CRD API.")
    @PresentInVersions(value="v1beta2")
    @Description(value="Configures additional options which will be passed to the Kaniko executor when building the new Connect image. Allowed options are: --customPlatform, --custom-platform, --insecure, --insecure-pull, --insecure-registry, --log-format, --log-timestamp, --registry-mirror, --reproducible, --single-snapshot, --skip-tls-verify, --skip-tls-verify-pull, --skip-tls-verify-registry, --verbosity, --snapshotMode, --use-new-run, --registry-certificate, --registry-client-cert, --ignore-path. These options will be used only on Kubernetes where the Kaniko executor is used. They will be ignored on OpenShift. The options are described in the link:https://github.com/GoogleContainerTools/kaniko[Kaniko GitHub repository^]. Changing this field does not trigger new build of the Kafka Connect image.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getAdditionalKanikoOptions() {
        return this.additionalKanikoOptions;
    }

    public void setAdditionalKanikoOptions(List<String> additionalKanikoOptions) {
        this.additionalKanikoOptions = additionalKanikoOptions;
    }

    @Description(value="Configures additional options to pass to the `build` command of either Kaniko or Buildah (depending on the feature gate setting) when building a new Kafka Connect image. Allowed Kaniko options: --customPlatform, --custom-platform, --insecure, --insecure-pull, --insecure-registry, --log-format, --log-timestamp, --registry-mirror, --reproducible, --single-snapshot, --skip-tls-verify, --skip-tls-verify-pull, --skip-tls-verify-registry, --verbosity, --snapshotMode, --use-new-run, --registry-certificate, --registry-client-cert, --ignore-path. Allowed Buildah `build` options: --authfile, --cert-dir, --creds, --decryption-key, --retry, --retry-delay, --tls-verify. Those options are used only on Kubernetes, where Kaniko and Buildah are available. They are ignored on OpenShift. For more information, see the link:https://github.com/GoogleContainerTools/kaniko[Kaniko GitHub repository^] or the link:https://github.com/containers/buildah/blob/main/docs/buildah-build.1.md[Buildah build document^]. Changing this field does not trigger a rebuild of the Kafka Connect image.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getAdditionalBuildOptions() {
        return this.additionalBuildOptions;
    }

    public void setAdditionalBuildOptions(List<String> additionalBuildOptions) {
        this.additionalBuildOptions = additionalBuildOptions;
    }

    @Description(value="Configures additional options to pass to the Buildah `push` command when pushing a new Connect image. Allowed options: --authfile, --cert-dir, --creds, --quiet, --retry, --retry-delay, --tls-verify. Those options are used only on Kubernetes, where Buildah is available. They are ignored on OpenShift. For more information, see the link:https://github.com/containers/buildah/blob/main/docs/buildah-push.1.md[Buildah push document^]. Changing this field does not trigger a rebuild of the Kafka Connect image.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getAdditionalPushOptions() {
        return this.additionalPushOptions;
    }

    public void setAdditionalPushOptions(List<String> additionalPushOptions) {
        this.additionalPushOptions = additionalPushOptions;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DockerOutput)) {
            return false;
        }
        DockerOutput other = (DockerOutput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$pushSecret = this.getPushSecret();
        String other$pushSecret = other.getPushSecret();
        if (this$pushSecret == null ? other$pushSecret != null : !this$pushSecret.equals(other$pushSecret)) {
            return false;
        }
        List<String> this$additionalKanikoOptions = this.getAdditionalKanikoOptions();
        List<String> other$additionalKanikoOptions = other.getAdditionalKanikoOptions();
        if (this$additionalKanikoOptions == null ? other$additionalKanikoOptions != null : !((Object)this$additionalKanikoOptions).equals(other$additionalKanikoOptions)) {
            return false;
        }
        List<String> this$additionalBuildOptions = this.getAdditionalBuildOptions();
        List<String> other$additionalBuildOptions = other.getAdditionalBuildOptions();
        if (this$additionalBuildOptions == null ? other$additionalBuildOptions != null : !((Object)this$additionalBuildOptions).equals(other$additionalBuildOptions)) {
            return false;
        }
        List<String> this$additionalPushOptions = this.getAdditionalPushOptions();
        List<String> other$additionalPushOptions = other.getAdditionalPushOptions();
        return !(this$additionalPushOptions == null ? other$additionalPushOptions != null : !((Object)this$additionalPushOptions).equals(other$additionalPushOptions));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DockerOutput;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $pushSecret = this.getPushSecret();
        result = result * 59 + ($pushSecret == null ? 43 : $pushSecret.hashCode());
        List<String> $additionalKanikoOptions = this.getAdditionalKanikoOptions();
        result = result * 59 + ($additionalKanikoOptions == null ? 43 : ((Object)$additionalKanikoOptions).hashCode());
        List<String> $additionalBuildOptions = this.getAdditionalBuildOptions();
        result = result * 59 + ($additionalBuildOptions == null ? 43 : ((Object)$additionalBuildOptions).hashCode());
        List<String> $additionalPushOptions = this.getAdditionalPushOptions();
        result = result * 59 + ($additionalPushOptions == null ? 43 : ((Object)$additionalPushOptions).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "DockerOutput(super=" + super.toString() + ", pushSecret=" + this.getPushSecret() + ", additionalKanikoOptions=" + String.valueOf(this.getAdditionalKanikoOptions()) + ", additionalBuildOptions=" + String.valueOf(this.getAdditionalBuildOptions()) + ", additionalPushOptions=" + String.valueOf(this.getAdditionalPushOptions()) + ")";
    }
}

