/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.connect;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.common.ClientTls;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthentication;
import io.strimzi.api.kafka.model.connect.AbstractKafkaConnectSpec;
import io.strimzi.api.kafka.model.connect.MountedPlugin;
import io.strimzi.api.kafka.model.connect.build.Build;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.DescriptionFile;
import io.strimzi.crdgenerator.annotations.RequiredInVersions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@DescriptionFile
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"version", "replicas", "image", "bootstrapServers", "groupId", "configStorageTopic", "statusStorageTopic", "offsetStorageTopic", "tls", "authentication", "config", "resources", "livenessProbe", "readinessProbe", "jvmOptions", "jmxOptions", "logging", "clientRackInitImage", "rack", "metricsConfig", "tracing", "template", "externalConfiguration", "build", "plugins"})
public class KafkaConnectSpec
extends AbstractKafkaConnectSpec {
    public static final String FORBIDDEN_PREFIXES = "ssl., sasl., security., listeners, plugin.path, rest., bootstrap.servers, consumer.interceptor.classes, producer.interceptor.classes, prometheus.metrics.reporter.";
    public static final String FORBIDDEN_PREFIX_EXCEPTIONS = "ssl.endpoint.identification.algorithm, ssl.cipher.suites, ssl.protocol, ssl.enabled.protocols";
    private Map<String, Object> config = new HashMap<String, Object>(0);
    private String bootstrapServers;
    private String groupId;
    private String configStorageTopic;
    private String statusStorageTopic;
    private String offsetStorageTopic;
    private ClientTls tls;
    private KafkaClientAuthentication authentication;
    private Build build;
    private List<MountedPlugin> plugins;

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Description(value="The Kafka Connect configuration. Properties with the following prefixes cannot be set: ssl., sasl., security., listeners, plugin.path, rest., bootstrap.servers, consumer.interceptor.classes, producer.interceptor.classes, prometheus.metrics.reporter. (with the exception of: ssl.endpoint.identification.algorithm, ssl.cipher.suites, ssl.protocol, ssl.enabled.protocols).")
    public Map<String, Object> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, Object> config) {
        this.config = config;
    }

    @Description(value="Bootstrap servers to connect to. This should be given as a comma separated list of _<hostname>_:_<port>_ pairs.")
    @JsonProperty(required=true)
    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public void setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    @Description(value="A unique ID that identifies the Connect cluster group.")
    @RequiredInVersions(value="v1+")
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Description(value="The name of the Kafka topic where connector configurations are stored.")
    @RequiredInVersions(value="v1+")
    public String getConfigStorageTopic() {
        return this.configStorageTopic;
    }

    public void setConfigStorageTopic(String configStorageTopic) {
        this.configStorageTopic = configStorageTopic;
    }

    @Description(value="The name of the Kafka topic where connector and task status are stored")
    @RequiredInVersions(value="v1+")
    public String getStatusStorageTopic() {
        return this.statusStorageTopic;
    }

    public void setStatusStorageTopic(String statusStorageTopic) {
        this.statusStorageTopic = statusStorageTopic;
    }

    @Description(value="The name of the Kafka topic where source connector offsets are stored.")
    @RequiredInVersions(value="v1+")
    public String getOffsetStorageTopic() {
        return this.offsetStorageTopic;
    }

    public void setOffsetStorageTopic(String offsetStorageTopic) {
        this.offsetStorageTopic = offsetStorageTopic;
    }

    @Description(value="TLS configuration")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ClientTls getTls() {
        return this.tls;
    }

    public void setTls(ClientTls tls) {
        this.tls = tls;
    }

    @Description(value="Authentication configuration for Kafka Connect")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public KafkaClientAuthentication getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(KafkaClientAuthentication authentication) {
        this.authentication = authentication;
    }

    @Description(value="Configures how the Connect container image should be built. Optional.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Build getBuild() {
        return this.build;
    }

    public void setBuild(Build build) {
        this.build = build;
    }

    @Description(value="List of connector plugins to mount into the `KafkaConnect` pod.")
    public List<MountedPlugin> getPlugins() {
        return this.plugins;
    }

    public void setPlugins(List<MountedPlugin> plugins) {
        this.plugins = plugins;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaConnectSpec)) {
            return false;
        }
        KafkaConnectSpec other = (KafkaConnectSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, Object> this$config = this.config;
        Map<String, Object> other$config = other.config;
        if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
            return false;
        }
        String this$bootstrapServers = this.bootstrapServers;
        String other$bootstrapServers = other.bootstrapServers;
        if (this$bootstrapServers == null ? other$bootstrapServers != null : !this$bootstrapServers.equals(other$bootstrapServers)) {
            return false;
        }
        String this$groupId = this.groupId;
        String other$groupId = other.groupId;
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$configStorageTopic = this.configStorageTopic;
        String other$configStorageTopic = other.configStorageTopic;
        if (this$configStorageTopic == null ? other$configStorageTopic != null : !this$configStorageTopic.equals(other$configStorageTopic)) {
            return false;
        }
        String this$statusStorageTopic = this.statusStorageTopic;
        String other$statusStorageTopic = other.statusStorageTopic;
        if (this$statusStorageTopic == null ? other$statusStorageTopic != null : !this$statusStorageTopic.equals(other$statusStorageTopic)) {
            return false;
        }
        String this$offsetStorageTopic = this.offsetStorageTopic;
        String other$offsetStorageTopic = other.offsetStorageTopic;
        if (this$offsetStorageTopic == null ? other$offsetStorageTopic != null : !this$offsetStorageTopic.equals(other$offsetStorageTopic)) {
            return false;
        }
        ClientTls this$tls = this.tls;
        ClientTls other$tls = other.tls;
        if (this$tls == null ? other$tls != null : !((Object)this$tls).equals(other$tls)) {
            return false;
        }
        KafkaClientAuthentication this$authentication = this.authentication;
        KafkaClientAuthentication other$authentication = other.authentication;
        if (this$authentication == null ? other$authentication != null : !((Object)this$authentication).equals(other$authentication)) {
            return false;
        }
        Build this$build = this.build;
        Build other$build = other.build;
        if (this$build == null ? other$build != null : !((Object)this$build).equals(other$build)) {
            return false;
        }
        List<MountedPlugin> this$plugins = this.plugins;
        List<MountedPlugin> other$plugins = other.plugins;
        return !(this$plugins == null ? other$plugins != null : !((Object)this$plugins).equals(other$plugins));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaConnectSpec;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<String, Object> $config = this.config;
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        String $bootstrapServers = this.bootstrapServers;
        result = result * 59 + ($bootstrapServers == null ? 43 : $bootstrapServers.hashCode());
        String $groupId = this.groupId;
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $configStorageTopic = this.configStorageTopic;
        result = result * 59 + ($configStorageTopic == null ? 43 : $configStorageTopic.hashCode());
        String $statusStorageTopic = this.statusStorageTopic;
        result = result * 59 + ($statusStorageTopic == null ? 43 : $statusStorageTopic.hashCode());
        String $offsetStorageTopic = this.offsetStorageTopic;
        result = result * 59 + ($offsetStorageTopic == null ? 43 : $offsetStorageTopic.hashCode());
        ClientTls $tls = this.tls;
        result = result * 59 + ($tls == null ? 43 : ((Object)$tls).hashCode());
        KafkaClientAuthentication $authentication = this.authentication;
        result = result * 59 + ($authentication == null ? 43 : ((Object)$authentication).hashCode());
        Build $build = this.build;
        result = result * 59 + ($build == null ? 43 : ((Object)$build).hashCode());
        List<MountedPlugin> $plugins = this.plugins;
        result = result * 59 + ($plugins == null ? 43 : ((Object)$plugins).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "KafkaConnectSpec(super=" + super.toString() + ", config=" + String.valueOf(this.getConfig()) + ", bootstrapServers=" + this.getBootstrapServers() + ", groupId=" + this.getGroupId() + ", configStorageTopic=" + this.getConfigStorageTopic() + ", statusStorageTopic=" + this.getStatusStorageTopic() + ", offsetStorageTopic=" + this.getOffsetStorageTopic() + ", tls=" + String.valueOf(this.getTls()) + ", authentication=" + String.valueOf(this.getAuthentication()) + ", build=" + String.valueOf(this.getBuild()) + ", plugins=" + String.valueOf(this.getPlugins()) + ")";
    }
}

