/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.connect;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.connect.MountedArtifact;
import io.strimzi.crdgenerator.annotations.Description;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "reference", "pullPolicy"})
public class ImageArtifact
extends MountedArtifact {
    private String reference;
    private String pullPolicy;

    @Override
    @Description(value="Must be `image`")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getType() {
        return "image";
    }

    @Description(value="Reference to the container image (OCI artifact) containing the Kafka Connect plugin. The image is mounted as a volume and provides the plugin binary. Required.")
    @JsonProperty(required=true)
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    @Description(value="Policy that determines when the container image (OCI artifact) is pulled.\n\nPossible values are:\n\n* `Always`: Always pull the image. If the pull fails, container creation fails.\n* `Never`: Never pull the image. Use only a locally available image. Container creation fails if the image isn\u2019t present.\n* `IfNotPresent`: Pull the image only if it\u2019s not already available locally. Container creation fails if the image isn\u2019t present and the pull fails.\n\nDefaults to `Always` if `:latest` tag is specified, or `IfNotPresent` otherwise.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPullPolicy() {
        return this.pullPolicy;
    }

    public void setPullPolicy(String pullPolicy) {
        this.pullPolicy = pullPolicy;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImageArtifact)) {
            return false;
        }
        ImageArtifact other = (ImageArtifact)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$reference = this.getReference();
        String other$reference = other.getReference();
        if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
            return false;
        }
        String this$pullPolicy = this.getPullPolicy();
        String other$pullPolicy = other.getPullPolicy();
        return !(this$pullPolicy == null ? other$pullPolicy != null : !this$pullPolicy.equals(other$pullPolicy));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ImageArtifact;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $reference = this.getReference();
        result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
        String $pullPolicy = this.getPullPolicy();
        result = result * 59 + ($pullPolicy == null ? 43 : $pullPolicy.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ImageArtifact(super=" + super.toString() + ", reference=" + this.getReference() + ", pullPolicy=" + this.getPullPolicy() + ")";
    }
}

