/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.common.template;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.CSIVolumeSource;
import io.fabric8.kubernetes.api.model.ConfigMapVolumeSource;
import io.fabric8.kubernetes.api.model.ImageVolumeSource;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSource;
import io.fabric8.kubernetes.api.model.SecretVolumeSource;
import io.strimzi.api.kafka.model.common.template.AdditionalVolume;
import io.strimzi.api.kafka.model.common.template.EmptyDirVolume;
import io.strimzi.api.kafka.model.common.template.EmptyDirVolumeBuilder;
import io.strimzi.api.kafka.model.common.template.EmptyDirVolumeFluent;
import java.util.Objects;
import java.util.Optional;

public class AdditionalVolumeFluent<A extends AdditionalVolumeFluent<A>>
extends BaseFluent<A> {
    private String name;
    private SecretVolumeSource secret;
    private ConfigMapVolumeSource configMap;
    private EmptyDirVolumeBuilder emptyDir;
    private PersistentVolumeClaimVolumeSource persistentVolumeClaim;
    private CSIVolumeSource csi;
    private ImageVolumeSource image;

    public AdditionalVolumeFluent() {
    }

    public AdditionalVolumeFluent(AdditionalVolume instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AdditionalVolume instance) {
        AdditionalVolume additionalVolume = instance = instance != null ? instance : new AdditionalVolume();
        if (instance != null) {
            this.withName(instance.getName());
            this.withSecret(instance.getSecret());
            this.withConfigMap(instance.getConfigMap());
            this.withEmptyDir(instance.getEmptyDir());
            this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
            this.withCsi(instance.getCsi());
            this.withImage(instance.getImage());
        }
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public SecretVolumeSource getSecret() {
        return this.secret;
    }

    public A withSecret(SecretVolumeSource secret) {
        this.secret = secret;
        return (A)((Object)this);
    }

    public boolean hasSecret() {
        return this.secret != null;
    }

    public ConfigMapVolumeSource getConfigMap() {
        return this.configMap;
    }

    public A withConfigMap(ConfigMapVolumeSource configMap) {
        this.configMap = configMap;
        return (A)((Object)this);
    }

    public boolean hasConfigMap() {
        return this.configMap != null;
    }

    public EmptyDirVolume buildEmptyDir() {
        return this.emptyDir != null ? this.emptyDir.build() : null;
    }

    public A withEmptyDir(EmptyDirVolume emptyDir) {
        this._visitables.remove((Object)"emptyDir");
        if (emptyDir != null) {
            this.emptyDir = new EmptyDirVolumeBuilder(emptyDir);
            this._visitables.get((Object)"emptyDir").add(this.emptyDir);
        } else {
            this.emptyDir = null;
            this._visitables.get((Object)"emptyDir").remove((Object)this.emptyDir);
        }
        return (A)((Object)this);
    }

    public boolean hasEmptyDir() {
        return this.emptyDir != null;
    }

    public EmptyDirNested<A> withNewEmptyDir() {
        return new EmptyDirNested(null);
    }

    public EmptyDirNested<A> withNewEmptyDirLike(EmptyDirVolume item) {
        return new EmptyDirNested(item);
    }

    public EmptyDirNested<A> editEmptyDir() {
        return this.withNewEmptyDirLike(Optional.ofNullable(this.buildEmptyDir()).orElse(null));
    }

    public EmptyDirNested<A> editOrNewEmptyDir() {
        return this.withNewEmptyDirLike(Optional.ofNullable(this.buildEmptyDir()).orElse(new EmptyDirVolumeBuilder().build()));
    }

    public EmptyDirNested<A> editOrNewEmptyDirLike(EmptyDirVolume item) {
        return this.withNewEmptyDirLike(Optional.ofNullable(this.buildEmptyDir()).orElse(item));
    }

    public PersistentVolumeClaimVolumeSource getPersistentVolumeClaim() {
        return this.persistentVolumeClaim;
    }

    public A withPersistentVolumeClaim(PersistentVolumeClaimVolumeSource persistentVolumeClaim) {
        this.persistentVolumeClaim = persistentVolumeClaim;
        return (A)((Object)this);
    }

    public boolean hasPersistentVolumeClaim() {
        return this.persistentVolumeClaim != null;
    }

    public A withNewPersistentVolumeClaim(String claimName, Boolean readOnly) {
        return this.withPersistentVolumeClaim(new PersistentVolumeClaimVolumeSource(claimName, readOnly));
    }

    public CSIVolumeSource getCsi() {
        return this.csi;
    }

    public A withCsi(CSIVolumeSource csi) {
        this.csi = csi;
        return (A)((Object)this);
    }

    public boolean hasCsi() {
        return this.csi != null;
    }

    public ImageVolumeSource getImage() {
        return this.image;
    }

    public A withImage(ImageVolumeSource image) {
        this.image = image;
        return (A)((Object)this);
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public A withNewImage(String pullPolicy, String reference) {
        return this.withImage(new ImageVolumeSource(pullPolicy, reference));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AdditionalVolumeFluent that = (AdditionalVolumeFluent)((Object)o);
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.secret, that.secret)) {
            return false;
        }
        if (!Objects.equals(this.configMap, that.configMap)) {
            return false;
        }
        if (!Objects.equals((Object)this.emptyDir, (Object)that.emptyDir)) {
            return false;
        }
        if (!Objects.equals(this.persistentVolumeClaim, that.persistentVolumeClaim)) {
            return false;
        }
        if (!Objects.equals(this.csi, that.csi)) {
            return false;
        }
        return Objects.equals(this.image, that.image);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.secret, this.configMap, this.emptyDir, this.persistentVolumeClaim, this.csi, this.image, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.secret != null) {
            sb.append("secret:");
            sb.append(String.valueOf(this.secret) + ",");
        }
        if (this.configMap != null) {
            sb.append("configMap:");
            sb.append(String.valueOf(this.configMap) + ",");
        }
        if (this.emptyDir != null) {
            sb.append("emptyDir:");
            sb.append(String.valueOf((Object)this.emptyDir) + ",");
        }
        if (this.persistentVolumeClaim != null) {
            sb.append("persistentVolumeClaim:");
            sb.append(String.valueOf(this.persistentVolumeClaim) + ",");
        }
        if (this.csi != null) {
            sb.append("csi:");
            sb.append(String.valueOf(this.csi) + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image);
        }
        sb.append("}");
        return sb.toString();
    }

    public class EmptyDirNested<N>
    extends EmptyDirVolumeFluent<EmptyDirNested<N>>
    implements Nested<N> {
        EmptyDirVolumeBuilder builder;

        EmptyDirNested(EmptyDirVolume item) {
            this.builder = new EmptyDirVolumeBuilder(this, item);
        }

        public N and() {
            return (N)AdditionalVolumeFluent.this.withEmptyDir(this.builder.build());
        }

        public N endEmptyDir() {
            return this.and();
        }
    }
}

