/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.common.authentication;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.common.CertSecretSource;
import io.strimzi.api.kafka.model.common.CertSecretSourceBuilder;
import io.strimzi.api.kafka.model.common.CertSecretSourceFluent;
import io.strimzi.api.kafka.model.common.GenericSecretSource;
import io.strimzi.api.kafka.model.common.GenericSecretSourceBuilder;
import io.strimzi.api.kafka.model.common.GenericSecretSourceFluent;
import io.strimzi.api.kafka.model.common.PasswordSecretSource;
import io.strimzi.api.kafka.model.common.PasswordSecretSourceBuilder;
import io.strimzi.api.kafka.model.common.PasswordSecretSourceFluent;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationOAuth;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class KafkaClientAuthenticationOAuthFluent<A extends KafkaClientAuthenticationOAuthFluent<A>>
extends BaseFluent<A> {
    private String clientId;
    private String grantType;
    private String username;
    private String scope;
    private String audience;
    private String tokenEndpointUri;
    private Integer connectTimeoutSeconds;
    private Integer readTimeoutSeconds;
    private Integer httpRetries;
    private Integer httpRetryPauseMs;
    private GenericSecretSourceBuilder clientSecret;
    private PasswordSecretSourceBuilder passwordSecret;
    private GenericSecretSourceBuilder accessToken;
    private String accessTokenLocation;
    private GenericSecretSourceBuilder refreshToken;
    private ArrayList<CertSecretSourceBuilder> tlsTrustedCertificates;
    private boolean disableTlsHostnameVerification;
    private int maxTokenExpirySeconds;
    private boolean accessTokenIsJwt;
    private boolean enableMetrics;
    private boolean includeAcceptHeader;
    private GenericSecretSourceBuilder clientAssertion;
    private String clientAssertionLocation;
    private String clientAssertionType;
    private Map<String, String> saslExtensions;

    public KafkaClientAuthenticationOAuthFluent() {
    }

    public KafkaClientAuthenticationOAuthFluent(KafkaClientAuthenticationOAuth instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(KafkaClientAuthenticationOAuth instance) {
        KafkaClientAuthenticationOAuth kafkaClientAuthenticationOAuth = instance = instance != null ? instance : new KafkaClientAuthenticationOAuth();
        if (instance != null) {
            this.withClientId(instance.getClientId());
            this.withGrantType(instance.getGrantType());
            this.withUsername(instance.getUsername());
            this.withScope(instance.getScope());
            this.withAudience(instance.getAudience());
            this.withTokenEndpointUri(instance.getTokenEndpointUri());
            this.withConnectTimeoutSeconds(instance.getConnectTimeoutSeconds());
            this.withReadTimeoutSeconds(instance.getReadTimeoutSeconds());
            this.withHttpRetries(instance.getHttpRetries());
            this.withHttpRetryPauseMs(instance.getHttpRetryPauseMs());
            this.withClientSecret(instance.getClientSecret());
            this.withPasswordSecret(instance.getPasswordSecret());
            this.withAccessToken(instance.getAccessToken());
            this.withAccessTokenLocation(instance.getAccessTokenLocation());
            this.withRefreshToken(instance.getRefreshToken());
            this.withTlsTrustedCertificates(instance.getTlsTrustedCertificates());
            this.withDisableTlsHostnameVerification(instance.isDisableTlsHostnameVerification());
            this.withMaxTokenExpirySeconds(instance.getMaxTokenExpirySeconds());
            this.withAccessTokenIsJwt(instance.isAccessTokenIsJwt());
            this.withEnableMetrics(instance.isEnableMetrics());
            this.withIncludeAcceptHeader(instance.isIncludeAcceptHeader());
            this.withClientAssertion(instance.getClientAssertion());
            this.withClientAssertionLocation(instance.getClientAssertionLocation());
            this.withClientAssertionType(instance.getClientAssertionType());
            this.withSaslExtensions(instance.getSaslExtensions());
        }
    }

    public String getClientId() {
        return this.clientId;
    }

    public A withClientId(String clientId) {
        this.clientId = clientId;
        return (A)((Object)this);
    }

    public boolean hasClientId() {
        return this.clientId != null;
    }

    public String getGrantType() {
        return this.grantType;
    }

    public A withGrantType(String grantType) {
        this.grantType = grantType;
        return (A)((Object)this);
    }

    public boolean hasGrantType() {
        return this.grantType != null;
    }

    public String getUsername() {
        return this.username;
    }

    public A withUsername(String username) {
        this.username = username;
        return (A)((Object)this);
    }

    public boolean hasUsername() {
        return this.username != null;
    }

    public String getScope() {
        return this.scope;
    }

    public A withScope(String scope) {
        this.scope = scope;
        return (A)((Object)this);
    }

    public boolean hasScope() {
        return this.scope != null;
    }

    public String getAudience() {
        return this.audience;
    }

    public A withAudience(String audience) {
        this.audience = audience;
        return (A)((Object)this);
    }

    public boolean hasAudience() {
        return this.audience != null;
    }

    public String getTokenEndpointUri() {
        return this.tokenEndpointUri;
    }

    public A withTokenEndpointUri(String tokenEndpointUri) {
        this.tokenEndpointUri = tokenEndpointUri;
        return (A)((Object)this);
    }

    public boolean hasTokenEndpointUri() {
        return this.tokenEndpointUri != null;
    }

    public Integer getConnectTimeoutSeconds() {
        return this.connectTimeoutSeconds;
    }

    public A withConnectTimeoutSeconds(Integer connectTimeoutSeconds) {
        this.connectTimeoutSeconds = connectTimeoutSeconds;
        return (A)((Object)this);
    }

    public boolean hasConnectTimeoutSeconds() {
        return this.connectTimeoutSeconds != null;
    }

    public Integer getReadTimeoutSeconds() {
        return this.readTimeoutSeconds;
    }

    public A withReadTimeoutSeconds(Integer readTimeoutSeconds) {
        this.readTimeoutSeconds = readTimeoutSeconds;
        return (A)((Object)this);
    }

    public boolean hasReadTimeoutSeconds() {
        return this.readTimeoutSeconds != null;
    }

    public Integer getHttpRetries() {
        return this.httpRetries;
    }

    public A withHttpRetries(Integer httpRetries) {
        this.httpRetries = httpRetries;
        return (A)((Object)this);
    }

    public boolean hasHttpRetries() {
        return this.httpRetries != null;
    }

    public Integer getHttpRetryPauseMs() {
        return this.httpRetryPauseMs;
    }

    public A withHttpRetryPauseMs(Integer httpRetryPauseMs) {
        this.httpRetryPauseMs = httpRetryPauseMs;
        return (A)((Object)this);
    }

    public boolean hasHttpRetryPauseMs() {
        return this.httpRetryPauseMs != null;
    }

    public GenericSecretSource buildClientSecret() {
        return this.clientSecret != null ? this.clientSecret.build() : null;
    }

    public A withClientSecret(GenericSecretSource clientSecret) {
        this._visitables.remove((Object)"clientSecret");
        if (clientSecret != null) {
            this.clientSecret = new GenericSecretSourceBuilder(clientSecret);
            this._visitables.get((Object)"clientSecret").add(this.clientSecret);
        } else {
            this.clientSecret = null;
            this._visitables.get((Object)"clientSecret").remove((Object)this.clientSecret);
        }
        return (A)((Object)this);
    }

    public boolean hasClientSecret() {
        return this.clientSecret != null;
    }

    public ClientSecretNested<A> withNewClientSecret() {
        return new ClientSecretNested(null);
    }

    public ClientSecretNested<A> withNewClientSecretLike(GenericSecretSource item) {
        return new ClientSecretNested(item);
    }

    public ClientSecretNested<A> editClientSecret() {
        return this.withNewClientSecretLike(Optional.ofNullable(this.buildClientSecret()).orElse(null));
    }

    public ClientSecretNested<A> editOrNewClientSecret() {
        return this.withNewClientSecretLike(Optional.ofNullable(this.buildClientSecret()).orElse(new GenericSecretSourceBuilder().build()));
    }

    public ClientSecretNested<A> editOrNewClientSecretLike(GenericSecretSource item) {
        return this.withNewClientSecretLike(Optional.ofNullable(this.buildClientSecret()).orElse(item));
    }

    public PasswordSecretSource buildPasswordSecret() {
        return this.passwordSecret != null ? this.passwordSecret.build() : null;
    }

    public A withPasswordSecret(PasswordSecretSource passwordSecret) {
        this._visitables.remove((Object)"passwordSecret");
        if (passwordSecret != null) {
            this.passwordSecret = new PasswordSecretSourceBuilder(passwordSecret);
            this._visitables.get((Object)"passwordSecret").add(this.passwordSecret);
        } else {
            this.passwordSecret = null;
            this._visitables.get((Object)"passwordSecret").remove((Object)this.passwordSecret);
        }
        return (A)((Object)this);
    }

    public boolean hasPasswordSecret() {
        return this.passwordSecret != null;
    }

    public PasswordSecretNested<A> withNewPasswordSecret() {
        return new PasswordSecretNested(null);
    }

    public PasswordSecretNested<A> withNewPasswordSecretLike(PasswordSecretSource item) {
        return new PasswordSecretNested(item);
    }

    public PasswordSecretNested<A> editPasswordSecret() {
        return this.withNewPasswordSecretLike(Optional.ofNullable(this.buildPasswordSecret()).orElse(null));
    }

    public PasswordSecretNested<A> editOrNewPasswordSecret() {
        return this.withNewPasswordSecretLike(Optional.ofNullable(this.buildPasswordSecret()).orElse(new PasswordSecretSourceBuilder().build()));
    }

    public PasswordSecretNested<A> editOrNewPasswordSecretLike(PasswordSecretSource item) {
        return this.withNewPasswordSecretLike(Optional.ofNullable(this.buildPasswordSecret()).orElse(item));
    }

    public GenericSecretSource buildAccessToken() {
        return this.accessToken != null ? this.accessToken.build() : null;
    }

    public A withAccessToken(GenericSecretSource accessToken) {
        this._visitables.remove((Object)"accessToken");
        if (accessToken != null) {
            this.accessToken = new GenericSecretSourceBuilder(accessToken);
            this._visitables.get((Object)"accessToken").add(this.accessToken);
        } else {
            this.accessToken = null;
            this._visitables.get((Object)"accessToken").remove((Object)this.accessToken);
        }
        return (A)((Object)this);
    }

    public boolean hasAccessToken() {
        return this.accessToken != null;
    }

    public AccessTokenNested<A> withNewAccessToken() {
        return new AccessTokenNested(null);
    }

    public AccessTokenNested<A> withNewAccessTokenLike(GenericSecretSource item) {
        return new AccessTokenNested(item);
    }

    public AccessTokenNested<A> editAccessToken() {
        return this.withNewAccessTokenLike(Optional.ofNullable(this.buildAccessToken()).orElse(null));
    }

    public AccessTokenNested<A> editOrNewAccessToken() {
        return this.withNewAccessTokenLike(Optional.ofNullable(this.buildAccessToken()).orElse(new GenericSecretSourceBuilder().build()));
    }

    public AccessTokenNested<A> editOrNewAccessTokenLike(GenericSecretSource item) {
        return this.withNewAccessTokenLike(Optional.ofNullable(this.buildAccessToken()).orElse(item));
    }

    public String getAccessTokenLocation() {
        return this.accessTokenLocation;
    }

    public A withAccessTokenLocation(String accessTokenLocation) {
        this.accessTokenLocation = accessTokenLocation;
        return (A)((Object)this);
    }

    public boolean hasAccessTokenLocation() {
        return this.accessTokenLocation != null;
    }

    public GenericSecretSource buildRefreshToken() {
        return this.refreshToken != null ? this.refreshToken.build() : null;
    }

    public A withRefreshToken(GenericSecretSource refreshToken) {
        this._visitables.remove((Object)"refreshToken");
        if (refreshToken != null) {
            this.refreshToken = new GenericSecretSourceBuilder(refreshToken);
            this._visitables.get((Object)"refreshToken").add(this.refreshToken);
        } else {
            this.refreshToken = null;
            this._visitables.get((Object)"refreshToken").remove((Object)this.refreshToken);
        }
        return (A)((Object)this);
    }

    public boolean hasRefreshToken() {
        return this.refreshToken != null;
    }

    public RefreshTokenNested<A> withNewRefreshToken() {
        return new RefreshTokenNested(null);
    }

    public RefreshTokenNested<A> withNewRefreshTokenLike(GenericSecretSource item) {
        return new RefreshTokenNested(item);
    }

    public RefreshTokenNested<A> editRefreshToken() {
        return this.withNewRefreshTokenLike(Optional.ofNullable(this.buildRefreshToken()).orElse(null));
    }

    public RefreshTokenNested<A> editOrNewRefreshToken() {
        return this.withNewRefreshTokenLike(Optional.ofNullable(this.buildRefreshToken()).orElse(new GenericSecretSourceBuilder().build()));
    }

    public RefreshTokenNested<A> editOrNewRefreshTokenLike(GenericSecretSource item) {
        return this.withNewRefreshTokenLike(Optional.ofNullable(this.buildRefreshToken()).orElse(item));
    }

    public A addToTlsTrustedCertificates(int index, CertSecretSource item) {
        if (this.tlsTrustedCertificates == null) {
            this.tlsTrustedCertificates = new ArrayList();
        }
        CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
        if (index < 0 || index >= this.tlsTrustedCertificates.size()) {
            this._visitables.get((Object)"tlsTrustedCertificates").add(builder);
            this.tlsTrustedCertificates.add(builder);
        } else {
            this._visitables.get((Object)"tlsTrustedCertificates").add(index, builder);
            this.tlsTrustedCertificates.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToTlsTrustedCertificates(int index, CertSecretSource item) {
        if (this.tlsTrustedCertificates == null) {
            this.tlsTrustedCertificates = new ArrayList();
        }
        CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
        if (index < 0 || index >= this.tlsTrustedCertificates.size()) {
            this._visitables.get((Object)"tlsTrustedCertificates").add(builder);
            this.tlsTrustedCertificates.add(builder);
        } else {
            this._visitables.get((Object)"tlsTrustedCertificates").set(index, builder);
            this.tlsTrustedCertificates.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToTlsTrustedCertificates(CertSecretSource ... items) {
        if (this.tlsTrustedCertificates == null) {
            this.tlsTrustedCertificates = new ArrayList();
        }
        for (CertSecretSource item : items) {
            CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
            this._visitables.get((Object)"tlsTrustedCertificates").add(builder);
            this.tlsTrustedCertificates.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToTlsTrustedCertificates(Collection<CertSecretSource> items) {
        if (this.tlsTrustedCertificates == null) {
            this.tlsTrustedCertificates = new ArrayList();
        }
        for (CertSecretSource item : items) {
            CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
            this._visitables.get((Object)"tlsTrustedCertificates").add(builder);
            this.tlsTrustedCertificates.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromTlsTrustedCertificates(CertSecretSource ... items) {
        if (this.tlsTrustedCertificates == null) {
            return (A)((Object)this);
        }
        for (CertSecretSource item : items) {
            CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
            this._visitables.get((Object)"tlsTrustedCertificates").remove((Object)builder);
            this.tlsTrustedCertificates.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTlsTrustedCertificates(Collection<CertSecretSource> items) {
        if (this.tlsTrustedCertificates == null) {
            return (A)((Object)this);
        }
        for (CertSecretSource item : items) {
            CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
            this._visitables.get((Object)"tlsTrustedCertificates").remove((Object)builder);
            this.tlsTrustedCertificates.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromTlsTrustedCertificates(Predicate<CertSecretSourceBuilder> predicate) {
        if (this.tlsTrustedCertificates == null) {
            return (A)((Object)this);
        }
        Iterator<CertSecretSourceBuilder> each = this.tlsTrustedCertificates.iterator();
        List visitables = this._visitables.get((Object)"tlsTrustedCertificates");
        while (each.hasNext()) {
            CertSecretSourceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<CertSecretSource> buildTlsTrustedCertificates() {
        return this.tlsTrustedCertificates != null ? KafkaClientAuthenticationOAuthFluent.build(this.tlsTrustedCertificates) : null;
    }

    public CertSecretSource buildTlsTrustedCertificate(int index) {
        return this.tlsTrustedCertificates.get(index).build();
    }

    public CertSecretSource buildFirstTlsTrustedCertificate() {
        return this.tlsTrustedCertificates.get(0).build();
    }

    public CertSecretSource buildLastTlsTrustedCertificate() {
        return this.tlsTrustedCertificates.get(this.tlsTrustedCertificates.size() - 1).build();
    }

    public CertSecretSource buildMatchingTlsTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
        for (CertSecretSourceBuilder item : this.tlsTrustedCertificates) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingTlsTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
        for (CertSecretSourceBuilder item : this.tlsTrustedCertificates) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTlsTrustedCertificates(List<CertSecretSource> tlsTrustedCertificates) {
        if (this.tlsTrustedCertificates != null) {
            this._visitables.get((Object)"tlsTrustedCertificates").clear();
        }
        if (tlsTrustedCertificates != null) {
            this.tlsTrustedCertificates = new ArrayList();
            for (CertSecretSource item : tlsTrustedCertificates) {
                this.addToTlsTrustedCertificates(item);
            }
        } else {
            this.tlsTrustedCertificates = null;
        }
        return (A)((Object)this);
    }

    public A withTlsTrustedCertificates(CertSecretSource ... tlsTrustedCertificates) {
        if (this.tlsTrustedCertificates != null) {
            this.tlsTrustedCertificates.clear();
            this._visitables.remove((Object)"tlsTrustedCertificates");
        }
        if (tlsTrustedCertificates != null) {
            for (CertSecretSource item : tlsTrustedCertificates) {
                this.addToTlsTrustedCertificates(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTlsTrustedCertificates() {
        return this.tlsTrustedCertificates != null && !this.tlsTrustedCertificates.isEmpty();
    }

    public TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificate() {
        return new TlsTrustedCertificatesNested(-1, null);
    }

    public TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificateLike(CertSecretSource item) {
        return new TlsTrustedCertificatesNested(-1, item);
    }

    public TlsTrustedCertificatesNested<A> setNewTlsTrustedCertificateLike(int index, CertSecretSource item) {
        return new TlsTrustedCertificatesNested(index, item);
    }

    public TlsTrustedCertificatesNested<A> editTlsTrustedCertificate(int index) {
        if (this.tlsTrustedCertificates.size() <= index) {
            throw new RuntimeException("Can't edit tlsTrustedCertificates. Index exceeds size.");
        }
        return this.setNewTlsTrustedCertificateLike(index, this.buildTlsTrustedCertificate(index));
    }

    public TlsTrustedCertificatesNested<A> editFirstTlsTrustedCertificate() {
        if (this.tlsTrustedCertificates.size() == 0) {
            throw new RuntimeException("Can't edit first tlsTrustedCertificates. The list is empty.");
        }
        return this.setNewTlsTrustedCertificateLike(0, this.buildTlsTrustedCertificate(0));
    }

    public TlsTrustedCertificatesNested<A> editLastTlsTrustedCertificate() {
        int index = this.tlsTrustedCertificates.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last tlsTrustedCertificates. The list is empty.");
        }
        return this.setNewTlsTrustedCertificateLike(index, this.buildTlsTrustedCertificate(index));
    }

    public TlsTrustedCertificatesNested<A> editMatchingTlsTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tlsTrustedCertificates.size(); ++i) {
            if (!predicate.test(this.tlsTrustedCertificates.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching tlsTrustedCertificates. No match found.");
        }
        return this.setNewTlsTrustedCertificateLike(index, this.buildTlsTrustedCertificate(index));
    }

    public boolean isDisableTlsHostnameVerification() {
        return this.disableTlsHostnameVerification;
    }

    public A withDisableTlsHostnameVerification(boolean disableTlsHostnameVerification) {
        this.disableTlsHostnameVerification = disableTlsHostnameVerification;
        return (A)((Object)this);
    }

    public boolean hasDisableTlsHostnameVerification() {
        return true;
    }

    public int getMaxTokenExpirySeconds() {
        return this.maxTokenExpirySeconds;
    }

    public A withMaxTokenExpirySeconds(int maxTokenExpirySeconds) {
        this.maxTokenExpirySeconds = maxTokenExpirySeconds;
        return (A)((Object)this);
    }

    public boolean hasMaxTokenExpirySeconds() {
        return true;
    }

    public boolean isAccessTokenIsJwt() {
        return this.accessTokenIsJwt;
    }

    public A withAccessTokenIsJwt(boolean accessTokenIsJwt) {
        this.accessTokenIsJwt = accessTokenIsJwt;
        return (A)((Object)this);
    }

    public boolean hasAccessTokenIsJwt() {
        return true;
    }

    public boolean isEnableMetrics() {
        return this.enableMetrics;
    }

    public A withEnableMetrics(boolean enableMetrics) {
        this.enableMetrics = enableMetrics;
        return (A)((Object)this);
    }

    public boolean hasEnableMetrics() {
        return true;
    }

    public boolean isIncludeAcceptHeader() {
        return this.includeAcceptHeader;
    }

    public A withIncludeAcceptHeader(boolean includeAcceptHeader) {
        this.includeAcceptHeader = includeAcceptHeader;
        return (A)((Object)this);
    }

    public boolean hasIncludeAcceptHeader() {
        return true;
    }

    public GenericSecretSource buildClientAssertion() {
        return this.clientAssertion != null ? this.clientAssertion.build() : null;
    }

    public A withClientAssertion(GenericSecretSource clientAssertion) {
        this._visitables.remove((Object)"clientAssertion");
        if (clientAssertion != null) {
            this.clientAssertion = new GenericSecretSourceBuilder(clientAssertion);
            this._visitables.get((Object)"clientAssertion").add(this.clientAssertion);
        } else {
            this.clientAssertion = null;
            this._visitables.get((Object)"clientAssertion").remove((Object)this.clientAssertion);
        }
        return (A)((Object)this);
    }

    public boolean hasClientAssertion() {
        return this.clientAssertion != null;
    }

    public ClientAssertionNested<A> withNewClientAssertion() {
        return new ClientAssertionNested(null);
    }

    public ClientAssertionNested<A> withNewClientAssertionLike(GenericSecretSource item) {
        return new ClientAssertionNested(item);
    }

    public ClientAssertionNested<A> editClientAssertion() {
        return this.withNewClientAssertionLike(Optional.ofNullable(this.buildClientAssertion()).orElse(null));
    }

    public ClientAssertionNested<A> editOrNewClientAssertion() {
        return this.withNewClientAssertionLike(Optional.ofNullable(this.buildClientAssertion()).orElse(new GenericSecretSourceBuilder().build()));
    }

    public ClientAssertionNested<A> editOrNewClientAssertionLike(GenericSecretSource item) {
        return this.withNewClientAssertionLike(Optional.ofNullable(this.buildClientAssertion()).orElse(item));
    }

    public String getClientAssertionLocation() {
        return this.clientAssertionLocation;
    }

    public A withClientAssertionLocation(String clientAssertionLocation) {
        this.clientAssertionLocation = clientAssertionLocation;
        return (A)((Object)this);
    }

    public boolean hasClientAssertionLocation() {
        return this.clientAssertionLocation != null;
    }

    public String getClientAssertionType() {
        return this.clientAssertionType;
    }

    public A withClientAssertionType(String clientAssertionType) {
        this.clientAssertionType = clientAssertionType;
        return (A)((Object)this);
    }

    public boolean hasClientAssertionType() {
        return this.clientAssertionType != null;
    }

    public A addToSaslExtensions(String key, String value) {
        if (this.saslExtensions == null && key != null && value != null) {
            this.saslExtensions = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.saslExtensions.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToSaslExtensions(Map<String, String> map) {
        if (this.saslExtensions == null && map != null) {
            this.saslExtensions = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.saslExtensions.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromSaslExtensions(String key) {
        if (this.saslExtensions == null) {
            return (A)((Object)this);
        }
        if (key != null && this.saslExtensions != null) {
            this.saslExtensions.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromSaslExtensions(Map<String, String> map) {
        if (this.saslExtensions == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.saslExtensions == null) continue;
                this.saslExtensions.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getSaslExtensions() {
        return this.saslExtensions;
    }

    public <K, V> A withSaslExtensions(Map<String, String> saslExtensions) {
        this.saslExtensions = saslExtensions == null ? null : new LinkedHashMap<String, String>(saslExtensions);
        return (A)((Object)this);
    }

    public boolean hasSaslExtensions() {
        return this.saslExtensions != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaClientAuthenticationOAuthFluent that = (KafkaClientAuthenticationOAuthFluent)((Object)o);
        if (!Objects.equals(this.clientId, that.clientId)) {
            return false;
        }
        if (!Objects.equals(this.grantType, that.grantType)) {
            return false;
        }
        if (!Objects.equals(this.username, that.username)) {
            return false;
        }
        if (!Objects.equals(this.scope, that.scope)) {
            return false;
        }
        if (!Objects.equals(this.audience, that.audience)) {
            return false;
        }
        if (!Objects.equals(this.tokenEndpointUri, that.tokenEndpointUri)) {
            return false;
        }
        if (!Objects.equals(this.connectTimeoutSeconds, that.connectTimeoutSeconds)) {
            return false;
        }
        if (!Objects.equals(this.readTimeoutSeconds, that.readTimeoutSeconds)) {
            return false;
        }
        if (!Objects.equals(this.httpRetries, that.httpRetries)) {
            return false;
        }
        if (!Objects.equals(this.httpRetryPauseMs, that.httpRetryPauseMs)) {
            return false;
        }
        if (!Objects.equals((Object)this.clientSecret, (Object)that.clientSecret)) {
            return false;
        }
        if (!Objects.equals((Object)this.passwordSecret, (Object)that.passwordSecret)) {
            return false;
        }
        if (!Objects.equals((Object)this.accessToken, (Object)that.accessToken)) {
            return false;
        }
        if (!Objects.equals(this.accessTokenLocation, that.accessTokenLocation)) {
            return false;
        }
        if (!Objects.equals((Object)this.refreshToken, (Object)that.refreshToken)) {
            return false;
        }
        if (!Objects.equals(this.tlsTrustedCertificates, that.tlsTrustedCertificates)) {
            return false;
        }
        if (this.disableTlsHostnameVerification != that.disableTlsHostnameVerification) {
            return false;
        }
        if (this.maxTokenExpirySeconds != that.maxTokenExpirySeconds) {
            return false;
        }
        if (this.accessTokenIsJwt != that.accessTokenIsJwt) {
            return false;
        }
        if (this.enableMetrics != that.enableMetrics) {
            return false;
        }
        if (this.includeAcceptHeader != that.includeAcceptHeader) {
            return false;
        }
        if (!Objects.equals((Object)this.clientAssertion, (Object)that.clientAssertion)) {
            return false;
        }
        if (!Objects.equals(this.clientAssertionLocation, that.clientAssertionLocation)) {
            return false;
        }
        if (!Objects.equals(this.clientAssertionType, that.clientAssertionType)) {
            return false;
        }
        return Objects.equals(this.saslExtensions, that.saslExtensions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientId, this.grantType, this.username, this.scope, this.audience, this.tokenEndpointUri, this.connectTimeoutSeconds, this.readTimeoutSeconds, this.httpRetries, this.httpRetryPauseMs, this.clientSecret, this.passwordSecret, this.accessToken, this.accessTokenLocation, this.refreshToken, this.tlsTrustedCertificates, this.disableTlsHostnameVerification, this.maxTokenExpirySeconds, this.accessTokenIsJwt, this.enableMetrics, this.includeAcceptHeader, this.clientAssertion, this.clientAssertionLocation, this.clientAssertionType, this.saslExtensions, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clientId != null) {
            sb.append("clientId:");
            sb.append(this.clientId + ",");
        }
        if (this.grantType != null) {
            sb.append("grantType:");
            sb.append(this.grantType + ",");
        }
        if (this.username != null) {
            sb.append("username:");
            sb.append(this.username + ",");
        }
        if (this.scope != null) {
            sb.append("scope:");
            sb.append(this.scope + ",");
        }
        if (this.audience != null) {
            sb.append("audience:");
            sb.append(this.audience + ",");
        }
        if (this.tokenEndpointUri != null) {
            sb.append("tokenEndpointUri:");
            sb.append(this.tokenEndpointUri + ",");
        }
        if (this.connectTimeoutSeconds != null) {
            sb.append("connectTimeoutSeconds:");
            sb.append(this.connectTimeoutSeconds + ",");
        }
        if (this.readTimeoutSeconds != null) {
            sb.append("readTimeoutSeconds:");
            sb.append(this.readTimeoutSeconds + ",");
        }
        if (this.httpRetries != null) {
            sb.append("httpRetries:");
            sb.append(this.httpRetries + ",");
        }
        if (this.httpRetryPauseMs != null) {
            sb.append("httpRetryPauseMs:");
            sb.append(this.httpRetryPauseMs + ",");
        }
        if (this.clientSecret != null) {
            sb.append("clientSecret:");
            sb.append(String.valueOf((Object)this.clientSecret) + ",");
        }
        if (this.passwordSecret != null) {
            sb.append("passwordSecret:");
            sb.append(String.valueOf((Object)this.passwordSecret) + ",");
        }
        if (this.accessToken != null) {
            sb.append("accessToken:");
            sb.append(String.valueOf((Object)this.accessToken) + ",");
        }
        if (this.accessTokenLocation != null) {
            sb.append("accessTokenLocation:");
            sb.append(this.accessTokenLocation + ",");
        }
        if (this.refreshToken != null) {
            sb.append("refreshToken:");
            sb.append(String.valueOf((Object)this.refreshToken) + ",");
        }
        if (this.tlsTrustedCertificates != null && !this.tlsTrustedCertificates.isEmpty()) {
            sb.append("tlsTrustedCertificates:");
            sb.append(String.valueOf(this.tlsTrustedCertificates) + ",");
        }
        sb.append("disableTlsHostnameVerification:");
        sb.append(this.disableTlsHostnameVerification + ",");
        sb.append("maxTokenExpirySeconds:");
        sb.append(this.maxTokenExpirySeconds + ",");
        sb.append("accessTokenIsJwt:");
        sb.append(this.accessTokenIsJwt + ",");
        sb.append("enableMetrics:");
        sb.append(this.enableMetrics + ",");
        sb.append("includeAcceptHeader:");
        sb.append(this.includeAcceptHeader + ",");
        if (this.clientAssertion != null) {
            sb.append("clientAssertion:");
            sb.append(String.valueOf((Object)this.clientAssertion) + ",");
        }
        if (this.clientAssertionLocation != null) {
            sb.append("clientAssertionLocation:");
            sb.append(this.clientAssertionLocation + ",");
        }
        if (this.clientAssertionType != null) {
            sb.append("clientAssertionType:");
            sb.append(this.clientAssertionType + ",");
        }
        if (this.saslExtensions != null && !this.saslExtensions.isEmpty()) {
            sb.append("saslExtensions:");
            sb.append(this.saslExtensions);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withDisableTlsHostnameVerification() {
        return this.withDisableTlsHostnameVerification(true);
    }

    public A withAccessTokenIsJwt() {
        return this.withAccessTokenIsJwt(true);
    }

    public A withEnableMetrics() {
        return this.withEnableMetrics(true);
    }

    public A withIncludeAcceptHeader() {
        return this.withIncludeAcceptHeader(true);
    }

    public class ClientSecretNested<N>
    extends GenericSecretSourceFluent<ClientSecretNested<N>>
    implements Nested<N> {
        GenericSecretSourceBuilder builder;

        ClientSecretNested(GenericSecretSource item) {
            this.builder = new GenericSecretSourceBuilder(this, item);
        }

        public N and() {
            return (N)KafkaClientAuthenticationOAuthFluent.this.withClientSecret(this.builder.build());
        }

        public N endClientSecret() {
            return this.and();
        }
    }

    public class PasswordSecretNested<N>
    extends PasswordSecretSourceFluent<PasswordSecretNested<N>>
    implements Nested<N> {
        PasswordSecretSourceBuilder builder;

        PasswordSecretNested(PasswordSecretSource item) {
            this.builder = new PasswordSecretSourceBuilder(this, item);
        }

        public N and() {
            return (N)KafkaClientAuthenticationOAuthFluent.this.withPasswordSecret(this.builder.build());
        }

        public N endPasswordSecret() {
            return this.and();
        }
    }

    public class AccessTokenNested<N>
    extends GenericSecretSourceFluent<AccessTokenNested<N>>
    implements Nested<N> {
        GenericSecretSourceBuilder builder;

        AccessTokenNested(GenericSecretSource item) {
            this.builder = new GenericSecretSourceBuilder(this, item);
        }

        public N and() {
            return (N)KafkaClientAuthenticationOAuthFluent.this.withAccessToken(this.builder.build());
        }

        public N endAccessToken() {
            return this.and();
        }
    }

    public class RefreshTokenNested<N>
    extends GenericSecretSourceFluent<RefreshTokenNested<N>>
    implements Nested<N> {
        GenericSecretSourceBuilder builder;

        RefreshTokenNested(GenericSecretSource item) {
            this.builder = new GenericSecretSourceBuilder(this, item);
        }

        public N and() {
            return (N)KafkaClientAuthenticationOAuthFluent.this.withRefreshToken(this.builder.build());
        }

        public N endRefreshToken() {
            return this.and();
        }
    }

    public class TlsTrustedCertificatesNested<N>
    extends CertSecretSourceFluent<TlsTrustedCertificatesNested<N>>
    implements Nested<N> {
        CertSecretSourceBuilder builder;
        int index;

        TlsTrustedCertificatesNested(int index, CertSecretSource item) {
            this.index = index;
            this.builder = new CertSecretSourceBuilder(this, item);
        }

        public N and() {
            return (N)KafkaClientAuthenticationOAuthFluent.this.setToTlsTrustedCertificates(this.index, this.builder.build());
        }

        public N endTlsTrustedCertificate() {
            return this.and();
        }
    }

    public class ClientAssertionNested<N>
    extends GenericSecretSourceFluent<ClientAssertionNested<N>>
    implements Nested<N> {
        GenericSecretSourceBuilder builder;

        ClientAssertionNested(GenericSecretSource item) {
            this.builder = new GenericSecretSourceBuilder(this, item);
        }

        public N and() {
            return (N)KafkaClientAuthenticationOAuthFluent.this.withClientAssertion(this.builder.build());
        }

        public N endClientAssertion() {
            return this.and();
        }
    }
}

