/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.common.authentication;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.annotations.DeprecatedType;
import io.strimzi.api.kafka.model.common.CertSecretSource;
import io.strimzi.api.kafka.model.common.GenericSecretSource;
import io.strimzi.api.kafka.model.common.PasswordSecretSource;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthentication;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationCustom;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.DescriptionFile;
import io.strimzi.crdgenerator.annotations.PresentInVersions;
import java.util.List;
import java.util.Map;

@DescriptionFile
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "clientId", "username", "scope", "audience", "tokenEndpointUri", "connectTimeoutSeconds", "readTimeoutSeconds", "httpRetries", "httpRetryPauseMs", "clientSecret", "passwordSecret", "accessToken", "refreshToken", "tlsTrustedCertificates", "disableTlsHostnameVerification", "maxTokenExpirySeconds", "accessTokenIsJwt", "enableMetrics", "includeAcceptHeader", "accessTokenLocation", "clientAssertion", "clientAssertionLocation", "clientAssertionType", "saslExtensions", "grantType"})
@Deprecated
@DeprecatedType(replacedWithType=KafkaClientAuthenticationCustom.class)
@PresentInVersions(value="v1beta2")
public class KafkaClientAuthenticationOAuth
extends KafkaClientAuthentication {
    public static final String TYPE_OAUTH = "oauth";
    private String clientId;
    private String grantType;
    private String username;
    private String scope;
    private String audience;
    private String tokenEndpointUri;
    private Integer connectTimeoutSeconds;
    private Integer readTimeoutSeconds;
    private Integer httpRetries;
    private Integer httpRetryPauseMs;
    private GenericSecretSource clientSecret;
    private PasswordSecretSource passwordSecret;
    private GenericSecretSource accessToken;
    private String accessTokenLocation;
    private GenericSecretSource refreshToken;
    private List<CertSecretSource> tlsTrustedCertificates;
    private boolean disableTlsHostnameVerification = false;
    private int maxTokenExpirySeconds = 0;
    private boolean accessTokenIsJwt = true;
    private boolean enableMetrics = false;
    private boolean includeAcceptHeader = true;
    private GenericSecretSource clientAssertion;
    private String clientAssertionLocation;
    private String clientAssertionType;
    private Map<String, String> saslExtensions;

    @Override
    @Description(value="Must be `oauth`")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getType() {
        return TYPE_OAUTH;
    }

    @Description(value="OAuth Client ID which the Kafka client can use to authenticate against the OAuth server and use the token endpoint URI.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Description(value="A custom OAuth grant type to use when authenticating against the authorization server with `clientId` and one of `clientSecret` or `clientAssertion`. The value defaults to `client_credentials` in these cases. This is optional configuration, only used with custom authorization server implementations.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getGrantType() {
        return this.grantType;
    }

    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    @Description(value="OAuth scope to use when authenticating against the authorization server. Some authorization servers require this to be set. The possible values depend on how authorization server is configured. By default `scope` is not specified when doing the token endpoint request.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    @Description(value="OAuth audience to use when authenticating against the authorization server. Some authorization servers require the audience to be explicitly set. The possible values depend on how the authorization server is configured. By default, `audience` is not specified when performing the token endpoint request.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public String getAudience() {
        return this.audience;
    }

    public void setAudience(String audience) {
        this.audience = audience;
    }

    @Description(value="Authorization server token endpoint URI.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getTokenEndpointUri() {
        return this.tokenEndpointUri;
    }

    public void setTokenEndpointUri(String tokenEndpointUri) {
        this.tokenEndpointUri = tokenEndpointUri;
    }

    @Description(value="The connect timeout in seconds when connecting to authorization server. If not set, the effective connect timeout is 60 seconds.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getConnectTimeoutSeconds() {
        return this.connectTimeoutSeconds;
    }

    public void setConnectTimeoutSeconds(Integer connectTimeoutSeconds) {
        this.connectTimeoutSeconds = connectTimeoutSeconds;
    }

    @Description(value="The read timeout in seconds when connecting to authorization server. If not set, the effective read timeout is 60 seconds.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getReadTimeoutSeconds() {
        return this.readTimeoutSeconds;
    }

    public void setReadTimeoutSeconds(Integer readTimeoutSeconds) {
        this.readTimeoutSeconds = readTimeoutSeconds;
    }

    @Description(value="The maximum number of retries to attempt if an initial HTTP request fails. If not set, the default is to not attempt any retries.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getHttpRetries() {
        return this.httpRetries;
    }

    public void setHttpRetries(Integer httpRetries) {
        this.httpRetries = httpRetries;
    }

    @Description(value="The pause to take before retrying a failed HTTP request. If not set, the default is to not pause at all but to immediately repeat a request.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getHttpRetryPauseMs() {
        return this.httpRetryPauseMs;
    }

    public void setHttpRetryPauseMs(Integer httpRetryPauseMs) {
        this.httpRetryPauseMs = httpRetryPauseMs;
    }

    @Description(value="Link to Kubernetes Secret containing the OAuth client secret which the Kafka client can use to authenticate against the OAuth server and use the token endpoint URI.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public GenericSecretSource getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(GenericSecretSource clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Description(value="Link to Kubernetes Secret containing the access token which was obtained from the authorization server.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public GenericSecretSource getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(GenericSecretSource accessToken) {
        this.accessToken = accessToken;
    }

    @Description(value="Path to the token file containing an access token to be used for authentication.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getAccessTokenLocation() {
        return this.accessTokenLocation;
    }

    public void setAccessTokenLocation(String path) {
        this.accessTokenLocation = path;
    }

    @Description(value="Link to Kubernetes Secret containing the refresh token which can be used to obtain access token from the authorization server.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public GenericSecretSource getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(GenericSecretSource refreshToken) {
        this.refreshToken = refreshToken;
    }

    @Description(value="Trusted certificates for TLS connection to the OAuth server.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<CertSecretSource> getTlsTrustedCertificates() {
        return this.tlsTrustedCertificates;
    }

    public void setTlsTrustedCertificates(List<CertSecretSource> tlsTrustedCertificates) {
        this.tlsTrustedCertificates = tlsTrustedCertificates;
    }

    @Description(value="Enable or disable TLS hostname verification. Default value is `false`.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isDisableTlsHostnameVerification() {
        return this.disableTlsHostnameVerification;
    }

    public void setDisableTlsHostnameVerification(boolean disableTlsHostnameVerification) {
        this.disableTlsHostnameVerification = disableTlsHostnameVerification;
    }

    @Description(value="Set or limit time-to-live of the access tokens to the specified number of seconds. This should be set if the authorization server returns opaque tokens.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public int getMaxTokenExpirySeconds() {
        return this.maxTokenExpirySeconds;
    }

    public void setMaxTokenExpirySeconds(int maxTokenExpirySeconds) {
        this.maxTokenExpirySeconds = maxTokenExpirySeconds;
    }

    @Description(value="Configure whether access token should be treated as JWT. This should be set to `false` if the authorization server returns opaque tokens. Defaults to `true`.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isAccessTokenIsJwt() {
        return this.accessTokenIsJwt;
    }

    public void setAccessTokenIsJwt(boolean accessTokenIsJwt) {
        this.accessTokenIsJwt = accessTokenIsJwt;
    }

    @Description(value="Enable or disable OAuth metrics. Default value is `false`.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isEnableMetrics() {
        return this.enableMetrics;
    }

    public void setEnableMetrics(boolean enableMetrics) {
        this.enableMetrics = enableMetrics;
    }

    @Description(value="Reference to the `Secret` which holds the password.")
    public PasswordSecretSource getPasswordSecret() {
        return this.passwordSecret;
    }

    public void setPasswordSecret(PasswordSecretSource passwordSecret) {
        this.passwordSecret = passwordSecret;
    }

    @Description(value="Username used for the authentication.")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Description(value="Whether the Accept header should be set in requests to the authorization servers. The default value is `true`.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isIncludeAcceptHeader() {
        return this.includeAcceptHeader;
    }

    public void setIncludeAcceptHeader(boolean includeAcceptHeader) {
        this.includeAcceptHeader = includeAcceptHeader;
    }

    @Description(value="Link to Kubernetes secret containing the client assertion which was manually configured for the client.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public GenericSecretSource getClientAssertion() {
        return this.clientAssertion;
    }

    public void setClientAssertion(GenericSecretSource clientAssertion) {
        this.clientAssertion = clientAssertion;
    }

    @Description(value="Path to the file containing the client assertion to be used for authentication.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getClientAssertionLocation() {
        return this.clientAssertionLocation;
    }

    public void setClientAssertionLocation(String path) {
        this.clientAssertionLocation = path;
    }

    @Description(value="The client assertion type. If not set, and either `clientAssertion` or `clientAssertionLocation` is configured, this value defaults to `urn:ietf:params:oauth:client-assertion-type:jwt-bearer`.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getClientAssertionType() {
        return this.clientAssertionType;
    }

    public void setClientAssertionType(String assertionType) {
        this.clientAssertionType = assertionType;
    }

    @Description(value="SASL extensions parameters")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Map<String, String> getSaslExtensions() {
        return this.saslExtensions;
    }

    public void setSaslExtensions(Map<String, String> saslExtensions) {
        this.saslExtensions = saslExtensions;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaClientAuthenticationOAuth)) {
            return false;
        }
        KafkaClientAuthenticationOAuth other = (KafkaClientAuthenticationOAuth)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isDisableTlsHostnameVerification() != other.isDisableTlsHostnameVerification()) {
            return false;
        }
        if (this.getMaxTokenExpirySeconds() != other.getMaxTokenExpirySeconds()) {
            return false;
        }
        if (this.isAccessTokenIsJwt() != other.isAccessTokenIsJwt()) {
            return false;
        }
        if (this.isEnableMetrics() != other.isEnableMetrics()) {
            return false;
        }
        if (this.isIncludeAcceptHeader() != other.isIncludeAcceptHeader()) {
            return false;
        }
        Integer this$connectTimeoutSeconds = this.getConnectTimeoutSeconds();
        Integer other$connectTimeoutSeconds = other.getConnectTimeoutSeconds();
        if (this$connectTimeoutSeconds == null ? other$connectTimeoutSeconds != null : !((Object)this$connectTimeoutSeconds).equals(other$connectTimeoutSeconds)) {
            return false;
        }
        Integer this$readTimeoutSeconds = this.getReadTimeoutSeconds();
        Integer other$readTimeoutSeconds = other.getReadTimeoutSeconds();
        if (this$readTimeoutSeconds == null ? other$readTimeoutSeconds != null : !((Object)this$readTimeoutSeconds).equals(other$readTimeoutSeconds)) {
            return false;
        }
        Integer this$httpRetries = this.getHttpRetries();
        Integer other$httpRetries = other.getHttpRetries();
        if (this$httpRetries == null ? other$httpRetries != null : !((Object)this$httpRetries).equals(other$httpRetries)) {
            return false;
        }
        Integer this$httpRetryPauseMs = this.getHttpRetryPauseMs();
        Integer other$httpRetryPauseMs = other.getHttpRetryPauseMs();
        if (this$httpRetryPauseMs == null ? other$httpRetryPauseMs != null : !((Object)this$httpRetryPauseMs).equals(other$httpRetryPauseMs)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$grantType = this.getGrantType();
        String other$grantType = other.getGrantType();
        if (this$grantType == null ? other$grantType != null : !this$grantType.equals(other$grantType)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$audience = this.getAudience();
        String other$audience = other.getAudience();
        if (this$audience == null ? other$audience != null : !this$audience.equals(other$audience)) {
            return false;
        }
        String this$tokenEndpointUri = this.getTokenEndpointUri();
        String other$tokenEndpointUri = other.getTokenEndpointUri();
        if (this$tokenEndpointUri == null ? other$tokenEndpointUri != null : !this$tokenEndpointUri.equals(other$tokenEndpointUri)) {
            return false;
        }
        GenericSecretSource this$clientSecret = this.getClientSecret();
        GenericSecretSource other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !((Object)this$clientSecret).equals(other$clientSecret)) {
            return false;
        }
        PasswordSecretSource this$passwordSecret = this.getPasswordSecret();
        PasswordSecretSource other$passwordSecret = other.getPasswordSecret();
        if (this$passwordSecret == null ? other$passwordSecret != null : !((Object)this$passwordSecret).equals(other$passwordSecret)) {
            return false;
        }
        GenericSecretSource this$accessToken = this.getAccessToken();
        GenericSecretSource other$accessToken = other.getAccessToken();
        if (this$accessToken == null ? other$accessToken != null : !((Object)this$accessToken).equals(other$accessToken)) {
            return false;
        }
        String this$accessTokenLocation = this.getAccessTokenLocation();
        String other$accessTokenLocation = other.getAccessTokenLocation();
        if (this$accessTokenLocation == null ? other$accessTokenLocation != null : !this$accessTokenLocation.equals(other$accessTokenLocation)) {
            return false;
        }
        GenericSecretSource this$refreshToken = this.getRefreshToken();
        GenericSecretSource other$refreshToken = other.getRefreshToken();
        if (this$refreshToken == null ? other$refreshToken != null : !((Object)this$refreshToken).equals(other$refreshToken)) {
            return false;
        }
        List<CertSecretSource> this$tlsTrustedCertificates = this.getTlsTrustedCertificates();
        List<CertSecretSource> other$tlsTrustedCertificates = other.getTlsTrustedCertificates();
        if (this$tlsTrustedCertificates == null ? other$tlsTrustedCertificates != null : !((Object)this$tlsTrustedCertificates).equals(other$tlsTrustedCertificates)) {
            return false;
        }
        GenericSecretSource this$clientAssertion = this.getClientAssertion();
        GenericSecretSource other$clientAssertion = other.getClientAssertion();
        if (this$clientAssertion == null ? other$clientAssertion != null : !((Object)this$clientAssertion).equals(other$clientAssertion)) {
            return false;
        }
        String this$clientAssertionLocation = this.getClientAssertionLocation();
        String other$clientAssertionLocation = other.getClientAssertionLocation();
        if (this$clientAssertionLocation == null ? other$clientAssertionLocation != null : !this$clientAssertionLocation.equals(other$clientAssertionLocation)) {
            return false;
        }
        String this$clientAssertionType = this.getClientAssertionType();
        String other$clientAssertionType = other.getClientAssertionType();
        if (this$clientAssertionType == null ? other$clientAssertionType != null : !this$clientAssertionType.equals(other$clientAssertionType)) {
            return false;
        }
        Map<String, String> this$saslExtensions = this.getSaslExtensions();
        Map<String, String> other$saslExtensions = other.getSaslExtensions();
        return !(this$saslExtensions == null ? other$saslExtensions != null : !((Object)this$saslExtensions).equals(other$saslExtensions));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaClientAuthenticationOAuth;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isDisableTlsHostnameVerification() ? 79 : 97);
        result = result * 59 + this.getMaxTokenExpirySeconds();
        result = result * 59 + (this.isAccessTokenIsJwt() ? 79 : 97);
        result = result * 59 + (this.isEnableMetrics() ? 79 : 97);
        result = result * 59 + (this.isIncludeAcceptHeader() ? 79 : 97);
        Integer $connectTimeoutSeconds = this.getConnectTimeoutSeconds();
        result = result * 59 + ($connectTimeoutSeconds == null ? 43 : ((Object)$connectTimeoutSeconds).hashCode());
        Integer $readTimeoutSeconds = this.getReadTimeoutSeconds();
        result = result * 59 + ($readTimeoutSeconds == null ? 43 : ((Object)$readTimeoutSeconds).hashCode());
        Integer $httpRetries = this.getHttpRetries();
        result = result * 59 + ($httpRetries == null ? 43 : ((Object)$httpRetries).hashCode());
        Integer $httpRetryPauseMs = this.getHttpRetryPauseMs();
        result = result * 59 + ($httpRetryPauseMs == null ? 43 : ((Object)$httpRetryPauseMs).hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $grantType = this.getGrantType();
        result = result * 59 + ($grantType == null ? 43 : $grantType.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $audience = this.getAudience();
        result = result * 59 + ($audience == null ? 43 : $audience.hashCode());
        String $tokenEndpointUri = this.getTokenEndpointUri();
        result = result * 59 + ($tokenEndpointUri == null ? 43 : $tokenEndpointUri.hashCode());
        GenericSecretSource $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : ((Object)$clientSecret).hashCode());
        PasswordSecretSource $passwordSecret = this.getPasswordSecret();
        result = result * 59 + ($passwordSecret == null ? 43 : ((Object)$passwordSecret).hashCode());
        GenericSecretSource $accessToken = this.getAccessToken();
        result = result * 59 + ($accessToken == null ? 43 : ((Object)$accessToken).hashCode());
        String $accessTokenLocation = this.getAccessTokenLocation();
        result = result * 59 + ($accessTokenLocation == null ? 43 : $accessTokenLocation.hashCode());
        GenericSecretSource $refreshToken = this.getRefreshToken();
        result = result * 59 + ($refreshToken == null ? 43 : ((Object)$refreshToken).hashCode());
        List<CertSecretSource> $tlsTrustedCertificates = this.getTlsTrustedCertificates();
        result = result * 59 + ($tlsTrustedCertificates == null ? 43 : ((Object)$tlsTrustedCertificates).hashCode());
        GenericSecretSource $clientAssertion = this.getClientAssertion();
        result = result * 59 + ($clientAssertion == null ? 43 : ((Object)$clientAssertion).hashCode());
        String $clientAssertionLocation = this.getClientAssertionLocation();
        result = result * 59 + ($clientAssertionLocation == null ? 43 : $clientAssertionLocation.hashCode());
        String $clientAssertionType = this.getClientAssertionType();
        result = result * 59 + ($clientAssertionType == null ? 43 : $clientAssertionType.hashCode());
        Map<String, String> $saslExtensions = this.getSaslExtensions();
        result = result * 59 + ($saslExtensions == null ? 43 : ((Object)$saslExtensions).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "KafkaClientAuthenticationOAuth(super=" + super.toString() + ", clientId=" + this.getClientId() + ", grantType=" + this.getGrantType() + ", username=" + this.getUsername() + ", scope=" + this.getScope() + ", audience=" + this.getAudience() + ", tokenEndpointUri=" + this.getTokenEndpointUri() + ", connectTimeoutSeconds=" + this.getConnectTimeoutSeconds() + ", readTimeoutSeconds=" + this.getReadTimeoutSeconds() + ", httpRetries=" + this.getHttpRetries() + ", httpRetryPauseMs=" + this.getHttpRetryPauseMs() + ", clientSecret=" + String.valueOf(this.getClientSecret()) + ", passwordSecret=" + String.valueOf(this.getPasswordSecret()) + ", accessToken=" + String.valueOf(this.getAccessToken()) + ", accessTokenLocation=" + this.getAccessTokenLocation() + ", refreshToken=" + String.valueOf(this.getRefreshToken()) + ", tlsTrustedCertificates=" + String.valueOf(this.getTlsTrustedCertificates()) + ", disableTlsHostnameVerification=" + this.isDisableTlsHostnameVerification() + ", maxTokenExpirySeconds=" + this.getMaxTokenExpirySeconds() + ", accessTokenIsJwt=" + this.isAccessTokenIsJwt() + ", enableMetrics=" + this.isEnableMetrics() + ", includeAcceptHeader=" + this.isIncludeAcceptHeader() + ", clientAssertion=" + String.valueOf(this.getClientAssertion()) + ", clientAssertionLocation=" + this.getClientAssertionLocation() + ", clientAssertionType=" + this.getClientAssertionType() + ", saslExtensions=" + String.valueOf(this.getSaslExtensions()) + ")";
    }
}

