/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.common.authentication;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthentication;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.DescriptionFile;
import java.util.Map;

@DescriptionFile
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "sasl", "config"})
public class KafkaClientAuthenticationCustom
extends KafkaClientAuthentication {
    public static final String ALLOWED_PREFIXES = "ssl.keystore., sasl.";
    public static final String TYPE_CUSTOM = "custom";
    private Map<String, Object> config;
    private boolean sasl;

    @Override
    @Description(value="Must be `custom`")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getType() {
        return TYPE_CUSTOM;
    }

    @Description(value="Enable or disable SASL on this authentication mechanism.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public boolean isSasl() {
        return this.sasl;
    }

    public void setSasl(boolean enabled) {
        this.sasl = enabled;
    }

    @Description(value="Configuration for the custom authentication mechanism. Only properties with the `sasl.` and `ssl.keystore.` prefixes are allowed. Specify other options in the regular configuration section of the custom resource.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Map<String, Object> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, Object> config) {
        this.config = config;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaClientAuthenticationCustom)) {
            return false;
        }
        KafkaClientAuthenticationCustom other = (KafkaClientAuthenticationCustom)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isSasl() != other.isSasl()) {
            return false;
        }
        Map<String, Object> this$config = this.getConfig();
        Map<String, Object> other$config = other.getConfig();
        return !(this$config == null ? other$config != null : !((Object)this$config).equals(other$config));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaClientAuthenticationCustom;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isSasl() ? 79 : 97);
        Map<String, Object> $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "KafkaClientAuthenticationCustom(super=" + super.toString() + ", config=" + String.valueOf(this.getConfig()) + ", sasl=" + this.isSasl() + ")";
    }
}

