/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.common;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.common.CertificateExpirationPolicy;
import io.strimzi.api.kafka.model.common.UnknownPropertyPreserving;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.Minimum;
import java.util.HashMap;
import java.util.Map;

@Description(value="Configuration of how TLS certificates are used within the cluster. This applies to certificates used for both internal communication within the cluster and to certificates used for client access via `Kafka.spec.kafka.listeners.tls`.")
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonPropertyOrder(value={"generateCertificateAuthority", "generateSecretOwnerReference", "validityDays", "renewalDays", "certificateExpirationPolicy"})
public class CertificateAuthority
implements UnknownPropertyPreserving {
    public static final int DEFAULT_CERTS_VALIDITY_DAYS = 365;
    public static final int DEFAULT_CERTS_RENEWAL_DAYS = 30;
    private int validityDays;
    private boolean generateCertificateAuthority = true;
    private boolean generateSecretOwnerReference = true;
    private int renewalDays;
    private CertificateExpirationPolicy certificateExpirationPolicy;
    private Map<String, Object> additionalProperties;

    @Description(value="The number of days generated certificates should be valid for. The default is 365.")
    @Minimum(value=1)
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public int getValidityDays() {
        return this.validityDays;
    }

    public void setValidityDays(int validityDays) {
        this.validityDays = validityDays;
    }

    @Description(value="If true then Certificate Authority certificates will be generated automatically. Otherwise the user will need to provide a Secret with the CA certificate. Default is true.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isGenerateCertificateAuthority() {
        return this.generateCertificateAuthority;
    }

    public void setGenerateCertificateAuthority(boolean generateCertificateAuthority) {
        this.generateCertificateAuthority = generateCertificateAuthority;
    }

    @Description(value="If `true`, the Cluster and Client CA Secrets are configured with the `ownerReference` set to the `Kafka` resource. If the `Kafka` resource is deleted when `true`, the CA Secrets are also deleted. If `false`, the `ownerReference` is disabled. If the `Kafka` resource is deleted when `false`, the CA Secrets are retained and available for reuse. Default is `true`.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isGenerateSecretOwnerReference() {
        return this.generateSecretOwnerReference;
    }

    public void setGenerateSecretOwnerReference(boolean generateSecretOwnerReference) {
        this.generateSecretOwnerReference = generateSecretOwnerReference;
    }

    @Description(value="The number of days in the certificate renewal period. This is the number of days before the a certificate expires during which renewal actions may be performed. When `generateCertificateAuthority` is true, this will cause the generation of a new certificate. When `generateCertificateAuthority` is true, this will cause extra logging at WARN level about the pending certificate expiry. Default is 30.")
    @Minimum(value=1)
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public int getRenewalDays() {
        return this.renewalDays;
    }

    public void setRenewalDays(int renewalDays) {
        this.renewalDays = renewalDays;
    }

    @Description(value="How should CA certificate expiration be handled when `generateCertificateAuthority=true`. The default is for a new CA certificate to be generated reusing the existing private key.")
    public CertificateExpirationPolicy getCertificateExpirationPolicy() {
        return this.certificateExpirationPolicy;
    }

    public void setCertificateExpirationPolicy(CertificateExpirationPolicy certificateExpirationPolicy) {
        this.certificateExpirationPolicy = certificateExpirationPolicy;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties != null ? this.additionalProperties : Map.of();
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>(2);
        }
        this.additionalProperties.put(name, value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CertificateAuthority)) {
            return false;
        }
        CertificateAuthority other = (CertificateAuthority)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getValidityDays() != other.getValidityDays()) {
            return false;
        }
        if (this.isGenerateCertificateAuthority() != other.isGenerateCertificateAuthority()) {
            return false;
        }
        if (this.isGenerateSecretOwnerReference() != other.isGenerateSecretOwnerReference()) {
            return false;
        }
        if (this.getRenewalDays() != other.getRenewalDays()) {
            return false;
        }
        CertificateExpirationPolicy this$certificateExpirationPolicy = this.getCertificateExpirationPolicy();
        CertificateExpirationPolicy other$certificateExpirationPolicy = other.getCertificateExpirationPolicy();
        if (this$certificateExpirationPolicy == null ? other$certificateExpirationPolicy != null : !((Object)((Object)this$certificateExpirationPolicy)).equals((Object)other$certificateExpirationPolicy)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CertificateAuthority;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getValidityDays();
        result = result * 59 + (this.isGenerateCertificateAuthority() ? 79 : 97);
        result = result * 59 + (this.isGenerateSecretOwnerReference() ? 79 : 97);
        result = result * 59 + this.getRenewalDays();
        CertificateExpirationPolicy $certificateExpirationPolicy = this.getCertificateExpirationPolicy();
        result = result * 59 + ($certificateExpirationPolicy == null ? 43 : ((Object)((Object)$certificateExpirationPolicy)).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }

    public String toString() {
        return "CertificateAuthority(validityDays=" + this.getValidityDays() + ", generateCertificateAuthority=" + this.isGenerateCertificateAuthority() + ", generateSecretOwnerReference=" + this.isGenerateSecretOwnerReference() + ", renewalDays=" + this.getRenewalDays() + ", certificateExpirationPolicy=" + String.valueOf((Object)this.getCertificateExpirationPolicy()) + ", additionalProperties=" + String.valueOf(this.getAdditionalProperties()) + ")";
    }
}

