/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.bridge;

import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.client.CustomResourceFluent;
import io.strimzi.api.kafka.model.bridge.KafkaBridge;
import io.strimzi.api.kafka.model.bridge.KafkaBridgeSpec;
import io.strimzi.api.kafka.model.bridge.KafkaBridgeSpecBuilder;
import io.strimzi.api.kafka.model.bridge.KafkaBridgeSpecFluent;
import io.strimzi.api.kafka.model.bridge.KafkaBridgeStatus;
import io.strimzi.api.kafka.model.bridge.KafkaBridgeStatusBuilder;
import io.strimzi.api.kafka.model.bridge.KafkaBridgeStatusFluent;
import java.util.Objects;
import java.util.Optional;

public class KafkaBridgeFluent<A extends KafkaBridgeFluent<A>>
extends CustomResourceFluent<KafkaBridgeSpec, KafkaBridgeStatus, A> {
    private String apiVersion;
    private String kind;
    private KafkaBridgeSpecBuilder spec;
    private KafkaBridgeStatusBuilder status;

    public KafkaBridgeFluent() {
    }

    public KafkaBridgeFluent(KafkaBridge instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(KafkaBridge instance) {
        KafkaBridge kafkaBridge = instance = instance != null ? instance : new KafkaBridge();
        if (instance != null) {
            this.withSpec(instance.getSpec());
            this.withStatus(instance.getStatus());
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public KafkaBridgeSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    public A withSpec(KafkaBridgeSpec spec) {
        this._visitables.remove((Object)"spec");
        if (spec != null) {
            this.spec = new KafkaBridgeSpecBuilder(spec);
            this._visitables.get((Object)"spec").add(this.spec);
        } else {
            this.spec = null;
            this._visitables.get((Object)"spec").remove((Object)this.spec);
        }
        return (A)((Object)this);
    }

    public boolean hasSpec() {
        return this.spec != null;
    }

    public SpecNested<A> withNewSpec() {
        return new SpecNested(null);
    }

    public SpecNested<A> withNewSpecLike(KafkaBridgeSpec item) {
        return new SpecNested(item);
    }

    public SpecNested<A> editSpec() {
        return this.withNewSpecLike(Optional.ofNullable(this.buildSpec()).orElse(null));
    }

    public SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(Optional.ofNullable(this.buildSpec()).orElse(new KafkaBridgeSpecBuilder().build()));
    }

    public SpecNested<A> editOrNewSpecLike(KafkaBridgeSpec item) {
        return this.withNewSpecLike(Optional.ofNullable(this.buildSpec()).orElse(item));
    }

    public KafkaBridgeStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    public A withStatus(KafkaBridgeStatus status) {
        this._visitables.remove((Object)"status");
        if (status != null) {
            this.status = new KafkaBridgeStatusBuilder(status);
            this._visitables.get((Object)"status").add(this.status);
        } else {
            this.status = null;
            this._visitables.get((Object)"status").remove((Object)this.status);
        }
        return (A)((Object)this);
    }

    public boolean hasStatus() {
        return this.status != null;
    }

    public StatusNested<A> withNewStatus() {
        return new StatusNested(null);
    }

    public StatusNested<A> withNewStatusLike(KafkaBridgeStatus item) {
        return new StatusNested(item);
    }

    public StatusNested<A> editStatus() {
        return this.withNewStatusLike(Optional.ofNullable(this.buildStatus()).orElse(null));
    }

    public StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(Optional.ofNullable(this.buildStatus()).orElse(new KafkaBridgeStatusBuilder().build()));
    }

    public StatusNested<A> editOrNewStatusLike(KafkaBridgeStatus item) {
        return this.withNewStatusLike(Optional.ofNullable(this.buildStatus()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaBridgeFluent that = (KafkaBridgeFluent)((Object)o);
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals((Object)this.spec, (Object)that.spec)) {
            return false;
        }
        return Objects.equals((Object)this.status, (Object)that.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.apiVersion, this.kind, this.spec, this.status, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.spec != null) {
            sb.append("spec:");
            sb.append(String.valueOf((Object)this.spec) + ",");
        }
        if (this.status != null) {
            sb.append("status:");
            sb.append((Object)this.status);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SpecNested<N>
    extends KafkaBridgeSpecFluent<SpecNested<N>>
    implements Nested<N> {
        KafkaBridgeSpecBuilder builder;

        SpecNested(KafkaBridgeSpec item) {
            this.builder = new KafkaBridgeSpecBuilder(this, item);
        }

        public N and() {
            return (N)KafkaBridgeFluent.this.withSpec(this.builder.build());
        }

        public N endSpec() {
            return this.and();
        }
    }

    public class StatusNested<N>
    extends KafkaBridgeStatusFluent<StatusNested<N>>
    implements Nested<N> {
        KafkaBridgeStatusBuilder builder;

        StatusNested(KafkaBridgeStatus item) {
            this.builder = new KafkaBridgeStatusBuilder(this, item);
        }

        public N and() {
            return (N)KafkaBridgeFluent.this.withStatus(this.builder.build());
        }

        public N endStatus() {
            return this.and();
        }
    }
}

