/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.kafka.entityoperator;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.strimzi.api.annotations.DeprecatedProperty;
import io.strimzi.api.kafka.model.common.HasConfigurableLogging;
import io.strimzi.api.kafka.model.common.HasLivenessProbe;
import io.strimzi.api.kafka.model.common.HasReadinessProbe;
import io.strimzi.api.kafka.model.common.HasStartupProbe;
import io.strimzi.api.kafka.model.common.JvmOptions;
import io.strimzi.api.kafka.model.common.Logging;
import io.strimzi.api.kafka.model.common.Probe;
import io.strimzi.api.kafka.model.common.UnknownPropertyPreserving;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.DescriptionFile;
import io.strimzi.crdgenerator.annotations.KubeLink;
import io.strimzi.crdgenerator.annotations.Minimum;
import io.strimzi.crdgenerator.annotations.PresentInVersions;
import java.util.HashMap;
import java.util.Map;

@DescriptionFile
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonPropertyOrder(value={"watchedNamespace", "image", "reconciliationIntervalSeconds", "reconciliationIntervalMs", "zookeeperSessionTimeoutSeconds", "startupProbe", "livenessProbe", "readinessProbe", "resources", "topicMetadataMaxAttempts", "logging", "jvmOptions"})
public class EntityTopicOperatorSpec
implements HasConfigurableLogging,
HasLivenessProbe,
HasReadinessProbe,
HasStartupProbe,
UnknownPropertyPreserving {
    public static final String DEFAULT_SECURITY_PROTOCOL = "SSL";
    protected String watchedNamespace;
    protected String image;
    private Integer reconciliationIntervalSeconds;
    private Long reconciliationIntervalMs;
    protected Integer zookeeperSessionTimeoutSeconds;
    protected Integer topicMetadataMaxAttempts;
    private Probe startupProbe;
    private Probe livenessProbe;
    private Probe readinessProbe;
    protected ResourceRequirements resources;
    protected Logging logging;
    private JvmOptions jvmOptions;
    protected Map<String, Object> additionalProperties;

    @Description(value="The namespace the Topic Operator should watch.")
    public String getWatchedNamespace() {
        return this.watchedNamespace;
    }

    public void setWatchedNamespace(String watchedNamespace) {
        this.watchedNamespace = watchedNamespace;
    }

    @Description(value="The image to use for the Topic Operator")
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    @Description(value="Interval between periodic reconciliations in seconds. Ignored if reconciliationIntervalMs is set.")
    @Minimum(value=0)
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    @DeprecatedProperty(movedToPath=".spec.entityOperator.topicOperator.reconciliationIntervalMs")
    @PresentInVersions(value="v1alpha1-v1beta2")
    @Deprecated
    public Integer getReconciliationIntervalSeconds() {
        return this.reconciliationIntervalSeconds;
    }

    public void setReconciliationIntervalSeconds(Integer reconciliationIntervalSeconds) {
        this.reconciliationIntervalSeconds = reconciliationIntervalSeconds;
    }

    @Description(value="Interval between periodic reconciliations in milliseconds.")
    @Minimum(value=0)
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public Long getReconciliationIntervalMs() {
        return this.reconciliationIntervalMs;
    }

    public void setReconciliationIntervalMs(Long reconciliationIntervalMs) {
        this.reconciliationIntervalMs = reconciliationIntervalMs;
    }

    @Description(value="Timeout for the ZooKeeper session")
    @Minimum(value=0)
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    @DeprecatedProperty(description="This property is not used anymore in Strimzi 0.41.0 and it is ignored.")
    @PresentInVersions(value="v1alpha1-v1beta2")
    @Deprecated
    public Integer getZookeeperSessionTimeoutSeconds() {
        return this.zookeeperSessionTimeoutSeconds;
    }

    public void setZookeeperSessionTimeoutSeconds(Integer zookeeperSessionTimeoutSeconds) {
        this.zookeeperSessionTimeoutSeconds = zookeeperSessionTimeoutSeconds;
    }

    @Description(value="The number of attempts at getting topic metadata")
    @Minimum(value=0)
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    @DeprecatedProperty(description="This property is not used anymore in Strimzi 0.41.0 and it is ignored.")
    @PresentInVersions(value="v1alpha1-v1beta2")
    @Deprecated
    public Integer getTopicMetadataMaxAttempts() {
        return this.topicMetadataMaxAttempts;
    }

    public void setTopicMetadataMaxAttempts(Integer topicMetadataMaxAttempts) {
        this.topicMetadataMaxAttempts = topicMetadataMaxAttempts;
    }

    @Description(value="CPU and memory resources to reserve.")
    @KubeLink(group="core", version="v1", kind="resourcerequirements")
    public ResourceRequirements getResources() {
        return this.resources;
    }

    public void setResources(ResourceRequirements resources) {
        this.resources = resources;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Description(value="Pod startup checking.")
    public Probe getStartupProbe() {
        return this.startupProbe;
    }

    @Override
    public void setStartupProbe(Probe startupProbe) {
        this.startupProbe = startupProbe;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Description(value="Pod liveness checking.")
    public Probe getLivenessProbe() {
        return this.livenessProbe;
    }

    @Override
    public void setLivenessProbe(Probe livenessProbe) {
        this.livenessProbe = livenessProbe;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Description(value="Pod readiness checking.")
    public Probe getReadinessProbe() {
        return this.readinessProbe;
    }

    @Override
    public void setReadinessProbe(Probe readinessProbe) {
        this.readinessProbe = readinessProbe;
    }

    @Override
    @Description(value="Logging configuration")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Logging getLogging() {
        return this.logging;
    }

    @Override
    public void setLogging(Logging logging) {
        this.logging = logging;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties != null ? this.additionalProperties : Map.of();
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>(2);
        }
        this.additionalProperties.put(name, value);
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Description(value="JVM Options for pods")
    public JvmOptions getJvmOptions() {
        return this.jvmOptions;
    }

    public void setJvmOptions(JvmOptions jvmOptions) {
        this.jvmOptions = jvmOptions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityTopicOperatorSpec)) {
            return false;
        }
        EntityTopicOperatorSpec other = (EntityTopicOperatorSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$reconciliationIntervalSeconds = this.getReconciliationIntervalSeconds();
        Integer other$reconciliationIntervalSeconds = other.getReconciliationIntervalSeconds();
        if (this$reconciliationIntervalSeconds == null ? other$reconciliationIntervalSeconds != null : !((Object)this$reconciliationIntervalSeconds).equals(other$reconciliationIntervalSeconds)) {
            return false;
        }
        Long this$reconciliationIntervalMs = this.getReconciliationIntervalMs();
        Long other$reconciliationIntervalMs = other.getReconciliationIntervalMs();
        if (this$reconciliationIntervalMs == null ? other$reconciliationIntervalMs != null : !((Object)this$reconciliationIntervalMs).equals(other$reconciliationIntervalMs)) {
            return false;
        }
        Integer this$zookeeperSessionTimeoutSeconds = this.getZookeeperSessionTimeoutSeconds();
        Integer other$zookeeperSessionTimeoutSeconds = other.getZookeeperSessionTimeoutSeconds();
        if (this$zookeeperSessionTimeoutSeconds == null ? other$zookeeperSessionTimeoutSeconds != null : !((Object)this$zookeeperSessionTimeoutSeconds).equals(other$zookeeperSessionTimeoutSeconds)) {
            return false;
        }
        Integer this$topicMetadataMaxAttempts = this.getTopicMetadataMaxAttempts();
        Integer other$topicMetadataMaxAttempts = other.getTopicMetadataMaxAttempts();
        if (this$topicMetadataMaxAttempts == null ? other$topicMetadataMaxAttempts != null : !((Object)this$topicMetadataMaxAttempts).equals(other$topicMetadataMaxAttempts)) {
            return false;
        }
        String this$watchedNamespace = this.getWatchedNamespace();
        String other$watchedNamespace = other.getWatchedNamespace();
        if (this$watchedNamespace == null ? other$watchedNamespace != null : !this$watchedNamespace.equals(other$watchedNamespace)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        Probe this$startupProbe = this.getStartupProbe();
        Probe other$startupProbe = other.getStartupProbe();
        if (this$startupProbe == null ? other$startupProbe != null : !((Object)this$startupProbe).equals(other$startupProbe)) {
            return false;
        }
        Probe this$livenessProbe = this.getLivenessProbe();
        Probe other$livenessProbe = other.getLivenessProbe();
        if (this$livenessProbe == null ? other$livenessProbe != null : !((Object)this$livenessProbe).equals(other$livenessProbe)) {
            return false;
        }
        Probe this$readinessProbe = this.getReadinessProbe();
        Probe other$readinessProbe = other.getReadinessProbe();
        if (this$readinessProbe == null ? other$readinessProbe != null : !((Object)this$readinessProbe).equals(other$readinessProbe)) {
            return false;
        }
        ResourceRequirements this$resources = this.getResources();
        ResourceRequirements other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !this$resources.equals(other$resources)) {
            return false;
        }
        Logging this$logging = this.getLogging();
        Logging other$logging = other.getLogging();
        if (this$logging == null ? other$logging != null : !((Object)this$logging).equals(other$logging)) {
            return false;
        }
        JvmOptions this$jvmOptions = this.getJvmOptions();
        JvmOptions other$jvmOptions = other.getJvmOptions();
        if (this$jvmOptions == null ? other$jvmOptions != null : !((Object)this$jvmOptions).equals(other$jvmOptions)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EntityTopicOperatorSpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $reconciliationIntervalSeconds = this.getReconciliationIntervalSeconds();
        result = result * 59 + ($reconciliationIntervalSeconds == null ? 43 : ((Object)$reconciliationIntervalSeconds).hashCode());
        Long $reconciliationIntervalMs = this.getReconciliationIntervalMs();
        result = result * 59 + ($reconciliationIntervalMs == null ? 43 : ((Object)$reconciliationIntervalMs).hashCode());
        Integer $zookeeperSessionTimeoutSeconds = this.getZookeeperSessionTimeoutSeconds();
        result = result * 59 + ($zookeeperSessionTimeoutSeconds == null ? 43 : ((Object)$zookeeperSessionTimeoutSeconds).hashCode());
        Integer $topicMetadataMaxAttempts = this.getTopicMetadataMaxAttempts();
        result = result * 59 + ($topicMetadataMaxAttempts == null ? 43 : ((Object)$topicMetadataMaxAttempts).hashCode());
        String $watchedNamespace = this.getWatchedNamespace();
        result = result * 59 + ($watchedNamespace == null ? 43 : $watchedNamespace.hashCode());
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        Probe $startupProbe = this.getStartupProbe();
        result = result * 59 + ($startupProbe == null ? 43 : ((Object)$startupProbe).hashCode());
        Probe $livenessProbe = this.getLivenessProbe();
        result = result * 59 + ($livenessProbe == null ? 43 : ((Object)$livenessProbe).hashCode());
        Probe $readinessProbe = this.getReadinessProbe();
        result = result * 59 + ($readinessProbe == null ? 43 : ((Object)$readinessProbe).hashCode());
        ResourceRequirements $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : $resources.hashCode());
        Logging $logging = this.getLogging();
        result = result * 59 + ($logging == null ? 43 : ((Object)$logging).hashCode());
        JvmOptions $jvmOptions = this.getJvmOptions();
        result = result * 59 + ($jvmOptions == null ? 43 : ((Object)$jvmOptions).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }

    public String toString() {
        return "EntityTopicOperatorSpec(watchedNamespace=" + this.getWatchedNamespace() + ", image=" + this.getImage() + ", reconciliationIntervalSeconds=" + this.getReconciliationIntervalSeconds() + ", reconciliationIntervalMs=" + this.getReconciliationIntervalMs() + ", zookeeperSessionTimeoutSeconds=" + this.getZookeeperSessionTimeoutSeconds() + ", topicMetadataMaxAttempts=" + this.getTopicMetadataMaxAttempts() + ", startupProbe=" + String.valueOf(this.getStartupProbe()) + ", livenessProbe=" + String.valueOf(this.getLivenessProbe()) + ", readinessProbe=" + String.valueOf(this.getReadinessProbe()) + ", resources=" + String.valueOf(this.getResources()) + ", logging=" + String.valueOf(this.getLogging()) + ", jvmOptions=" + String.valueOf(this.getJvmOptions()) + ", additionalProperties=" + String.valueOf(this.getAdditionalProperties()) + ")";
    }
}

