/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.kafka;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.kafka.KRaftMetadataStorage;
import io.strimzi.api.kafka.model.kafka.SingleVolumeStorage;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.Minimum;
import io.strimzi.crdgenerator.annotations.Pattern;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "sizeLimit", "type", "kraftMetadata"})
public class EphemeralStorage
extends SingleVolumeStorage {
    private String sizeLimit;

    @Override
    @Description(value="Must be `ephemeral`")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getType() {
        return "ephemeral";
    }

    @Override
    @Description(value="Storage identification number. It is mandatory only for storage volumes defined in a storage of type 'jbod'")
    @Minimum(value=0)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getId() {
        return super.getId();
    }

    @Override
    public void setId(Integer id) {
        super.setId(id);
    }

    @Pattern(value="^([0-9.]+)([eEinumkKMGTP]*[-+]?[0-9]*)$")
    @Description(value="When type=ephemeral, defines the total amount of local storage required for this EmptyDir volume (for example 1Gi).")
    public String getSizeLimit() {
        return this.sizeLimit;
    }

    public void setSizeLimit(String sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    @Override
    @Description(value="Specifies whether this volume should be used for storing KRaft metadata. This property is optional. When set, the only currently supported value is `shared`. At most one volume can have this property set.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public KRaftMetadataStorage getKraftMetadata() {
        return super.getKraftMetadata();
    }

    @Override
    public void setKraftMetadata(KRaftMetadataStorage kraftMetadata) {
        super.setKraftMetadata(kraftMetadata);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EphemeralStorage)) {
            return false;
        }
        EphemeralStorage other = (EphemeralStorage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$sizeLimit = this.getSizeLimit();
        String other$sizeLimit = other.getSizeLimit();
        return !(this$sizeLimit == null ? other$sizeLimit != null : !this$sizeLimit.equals(other$sizeLimit));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof EphemeralStorage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $sizeLimit = this.getSizeLimit();
        result = result * 59 + ($sizeLimit == null ? 43 : $sizeLimit.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "EphemeralStorage(super=" + super.toString() + ", sizeLimit=" + this.getSizeLimit() + ")";
    }
}

