/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.connect;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.connect.ImageArtifact;
import io.strimzi.api.kafka.model.connect.ImageArtifactBuilder;
import io.strimzi.api.kafka.model.connect.ImageArtifactFluent;
import io.strimzi.api.kafka.model.connect.MountedArtifact;
import io.strimzi.api.kafka.model.connect.MountedPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class MountedPluginFluent<A extends MountedPluginFluent<A>>
extends BaseFluent<A> {
    private String name;
    private ArrayList<VisitableBuilder<? extends MountedArtifact, ?>> artifacts;

    public MountedPluginFluent() {
    }

    public MountedPluginFluent(MountedPlugin instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(MountedPlugin instance) {
        MountedPlugin mountedPlugin = instance = instance != null ? instance : new MountedPlugin();
        if (instance != null) {
            this.withName(instance.getName());
            this.withArtifacts(instance.getArtifacts());
        }
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public A addToArtifacts(VisitableBuilder<? extends MountedArtifact, ?> builder) {
        if (this.artifacts == null) {
            this.artifacts = new ArrayList();
        }
        this._visitables.get((Object)"artifacts").add(builder);
        this.artifacts.add(builder);
        return (A)((Object)this);
    }

    public A addToArtifacts(int index, VisitableBuilder<? extends MountedArtifact, ?> builder) {
        if (this.artifacts == null) {
            this.artifacts = new ArrayList();
        }
        if (index < 0 || index >= this.artifacts.size()) {
            this._visitables.get((Object)"artifacts").add(builder);
            this.artifacts.add(builder);
        } else {
            this._visitables.get((Object)"artifacts").add(index, builder);
            this.artifacts.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToArtifacts(int index, MountedArtifact item) {
        if (this.artifacts == null) {
            this.artifacts = new ArrayList();
        }
        VisitableBuilder builder = MountedPluginFluent.builder(item);
        if (index < 0 || index >= this.artifacts.size()) {
            this._visitables.get((Object)"artifacts").add(builder);
            this.artifacts.add(builder);
        } else {
            this._visitables.get((Object)"artifacts").add(index, builder);
            this.artifacts.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToArtifacts(int index, MountedArtifact item) {
        if (this.artifacts == null) {
            this.artifacts = new ArrayList();
        }
        VisitableBuilder builder = MountedPluginFluent.builder(item);
        if (index < 0 || index >= this.artifacts.size()) {
            this._visitables.get((Object)"artifacts").add(builder);
            this.artifacts.add(builder);
        } else {
            this._visitables.get((Object)"artifacts").set(index, builder);
            this.artifacts.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToArtifacts(MountedArtifact ... items) {
        if (this.artifacts == null) {
            this.artifacts = new ArrayList();
        }
        for (MountedArtifact item : items) {
            VisitableBuilder builder = MountedPluginFluent.builder(item);
            this._visitables.get((Object)"artifacts").add(builder);
            this.artifacts.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToArtifacts(Collection<MountedArtifact> items) {
        if (this.artifacts == null) {
            this.artifacts = new ArrayList();
        }
        for (MountedArtifact item : items) {
            VisitableBuilder builder = MountedPluginFluent.builder(item);
            this._visitables.get((Object)"artifacts").add(builder);
            this.artifacts.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromArtifacts(VisitableBuilder<? extends MountedArtifact, ?> builder) {
        if (this.artifacts == null) {
            return (A)((Object)this);
        }
        this._visitables.get((Object)"artifacts").remove(builder);
        this.artifacts.remove(builder);
        return (A)((Object)this);
    }

    public A removeFromArtifacts(MountedArtifact ... items) {
        if (this.artifacts == null) {
            return (A)((Object)this);
        }
        for (MountedArtifact item : items) {
            VisitableBuilder builder = MountedPluginFluent.builder(item);
            this._visitables.get((Object)"artifacts").remove(builder);
            this.artifacts.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromArtifacts(Collection<MountedArtifact> items) {
        if (this.artifacts == null) {
            return (A)((Object)this);
        }
        for (MountedArtifact item : items) {
            VisitableBuilder builder = MountedPluginFluent.builder(item);
            this._visitables.get((Object)"artifacts").remove(builder);
            this.artifacts.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromArtifacts(Predicate<VisitableBuilder<? extends MountedArtifact, ?>> predicate) {
        if (this.artifacts == null) {
            return (A)((Object)this);
        }
        Iterator<VisitableBuilder<MountedArtifact, ?>> each = this.artifacts.iterator();
        List visitables = this._visitables.get((Object)"artifacts");
        while (each.hasNext()) {
            VisitableBuilder<? extends MountedArtifact, ?> builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<MountedArtifact> buildArtifacts() {
        return MountedPluginFluent.build(this.artifacts);
    }

    public MountedArtifact buildArtifact(int index) {
        return (MountedArtifact)this.artifacts.get(index).build();
    }

    public MountedArtifact buildFirstArtifact() {
        return (MountedArtifact)this.artifacts.get(0).build();
    }

    public MountedArtifact buildLastArtifact() {
        return (MountedArtifact)this.artifacts.get(this.artifacts.size() - 1).build();
    }

    public MountedArtifact buildMatchingArtifact(Predicate<VisitableBuilder<? extends MountedArtifact, ?>> predicate) {
        for (VisitableBuilder<? extends MountedArtifact, ?> visitableBuilder : this.artifacts) {
            if (!predicate.test(visitableBuilder)) continue;
            return (MountedArtifact)visitableBuilder.build();
        }
        return null;
    }

    public boolean hasMatchingArtifact(Predicate<VisitableBuilder<? extends MountedArtifact, ?>> predicate) {
        for (VisitableBuilder<? extends MountedArtifact, ?> visitableBuilder : this.artifacts) {
            if (!predicate.test(visitableBuilder)) continue;
            return true;
        }
        return false;
    }

    public A withArtifacts(List<MountedArtifact> artifacts) {
        if (artifacts != null) {
            this.artifacts = new ArrayList();
            for (MountedArtifact item : artifacts) {
                this.addToArtifacts(item);
            }
        } else {
            this.artifacts = null;
        }
        return (A)((Object)this);
    }

    public A withArtifacts(MountedArtifact ... artifacts) {
        if (this.artifacts != null) {
            this.artifacts.clear();
            this._visitables.remove((Object)"artifacts");
        }
        if (artifacts != null) {
            for (MountedArtifact item : artifacts) {
                this.addToArtifacts(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasArtifacts() {
        return this.artifacts != null && !this.artifacts.isEmpty();
    }

    public ImageArtifactArtifactsNested<A> addNewImageArtifactArtifact() {
        return new ImageArtifactArtifactsNested(-1, null);
    }

    public ImageArtifactArtifactsNested<A> addNewImageArtifactArtifactLike(ImageArtifact item) {
        return new ImageArtifactArtifactsNested(-1, item);
    }

    public ImageArtifactArtifactsNested<A> setNewImageArtifactArtifactLike(int index, ImageArtifact item) {
        return new ImageArtifactArtifactsNested(index, item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MountedPluginFluent that = (MountedPluginFluent)((Object)o);
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals(this.artifacts, that.artifacts);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.artifacts, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.artifacts != null && !this.artifacts.isEmpty()) {
            sb.append("artifacts:");
            sb.append(this.artifacts);
        }
        sb.append("}");
        return sb.toString();
    }

    protected static <T> VisitableBuilder<T, ?> builder(Object item) {
        switch (item.getClass().getName()) {
            case "io.strimzi.api.kafka.model.connect.ImageArtifact": {
                return new ImageArtifactBuilder((ImageArtifact)item);
            }
        }
        return MountedPluginFluent.builderOf((Object)item);
    }

    public class ImageArtifactArtifactsNested<N>
    extends ImageArtifactFluent<ImageArtifactArtifactsNested<N>>
    implements Nested<N> {
        ImageArtifactBuilder builder;
        int index;

        ImageArtifactArtifactsNested(int index, ImageArtifact item) {
            this.index = index;
            this.builder = new ImageArtifactBuilder(this, item);
        }

        public N and() {
            return (N)MountedPluginFluent.this.setToArtifacts(this.index, this.builder.build());
        }

        public N endImageArtifactArtifact() {
            return this.and();
        }
    }
}

