/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.connect;

import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.common.ClientTls;
import io.strimzi.api.kafka.model.common.ClientTlsBuilder;
import io.strimzi.api.kafka.model.common.ClientTlsFluent;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthentication;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationOAuth;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationOAuthBuilder;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationOAuthFluent;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationPlain;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationPlainBuilder;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationPlainFluent;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationScramSha256;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationScramSha256Builder;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationScramSha256Fluent;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationScramSha512;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationScramSha512Builder;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationScramSha512Fluent;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationTls;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationTlsBuilder;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationTlsFluent;
import io.strimzi.api.kafka.model.connect.AbstractKafkaConnectSpecFluent;
import io.strimzi.api.kafka.model.connect.KafkaConnectSpec;
import io.strimzi.api.kafka.model.connect.MountedPlugin;
import io.strimzi.api.kafka.model.connect.MountedPluginBuilder;
import io.strimzi.api.kafka.model.connect.MountedPluginFluent;
import io.strimzi.api.kafka.model.connect.build.Build;
import io.strimzi.api.kafka.model.connect.build.BuildBuilder;
import io.strimzi.api.kafka.model.connect.build.BuildFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class KafkaConnectSpecFluent<A extends KafkaConnectSpecFluent<A>>
extends AbstractKafkaConnectSpecFluent<A> {
    private Map<String, Object> config;
    private String bootstrapServers;
    private ClientTlsBuilder tls;
    private VisitableBuilder<? extends KafkaClientAuthentication, ?> authentication;
    private BuildBuilder build;
    private ArrayList<MountedPluginBuilder> plugins;

    public KafkaConnectSpecFluent() {
    }

    public KafkaConnectSpecFluent(KafkaConnectSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(KafkaConnectSpec instance) {
        KafkaConnectSpec kafkaConnectSpec = instance = instance != null ? instance : new KafkaConnectSpec();
        if (instance != null) {
            this.withConfig(instance.getConfig());
            this.withBootstrapServers(instance.getBootstrapServers());
            this.withTls(instance.getTls());
            this.withAuthentication(instance.getAuthentication());
            this.withBuild(instance.getBuild());
            this.withPlugins(instance.getPlugins());
            this.withLogging(instance.getLogging());
            this.withReplicas(instance.getReplicas());
            this.withVersion(instance.getVersion());
            this.withImage(instance.getImage());
            this.withResources(instance.getResources());
            this.withLivenessProbe(instance.getLivenessProbe());
            this.withReadinessProbe(instance.getReadinessProbe());
            this.withJmxOptions(instance.getJmxOptions());
            this.withJvmOptions(instance.getJvmOptions());
            this.withMetricsConfig(instance.getMetricsConfig());
            this.withTracing(instance.getTracing());
            this.withTemplate(instance.getTemplate());
            this.withExternalConfiguration(instance.getExternalConfiguration());
            this.withClientRackInitImage(instance.getClientRackInitImage());
            this.withRack(instance.getRack());
        }
    }

    public A addToConfig(String key, Object value) {
        if (this.config == null && key != null && value != null) {
            this.config = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.config.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToConfig(Map<String, Object> map) {
        if (this.config == null && map != null) {
            this.config = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.config.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromConfig(String key) {
        if (this.config == null) {
            return (A)((Object)this);
        }
        if (key != null && this.config != null) {
            this.config.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromConfig(Map<String, Object> map) {
        if (this.config == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.config == null) continue;
                this.config.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }

    public <K, V> A withConfig(Map<String, Object> config) {
        this.config = config == null ? null : new LinkedHashMap<String, Object>(config);
        return (A)((Object)this);
    }

    public boolean hasConfig() {
        return this.config != null;
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public A withBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
        return (A)((Object)this);
    }

    public boolean hasBootstrapServers() {
        return this.bootstrapServers != null;
    }

    public ClientTls buildTls() {
        return this.tls != null ? this.tls.build() : null;
    }

    public A withTls(ClientTls tls) {
        this._visitables.remove((Object)"tls");
        if (tls != null) {
            this.tls = new ClientTlsBuilder(tls);
            this._visitables.get((Object)"tls").add(this.tls);
        } else {
            this.tls = null;
            this._visitables.get((Object)"tls").remove((Object)this.tls);
        }
        return (A)((Object)this);
    }

    public boolean hasTls() {
        return this.tls != null;
    }

    public TlsNested<A> withNewTls() {
        return new TlsNested(null);
    }

    public TlsNested<A> withNewTlsLike(ClientTls item) {
        return new TlsNested(item);
    }

    public TlsNested<A> editTls() {
        return this.withNewTlsLike(Optional.ofNullable(this.buildTls()).orElse(null));
    }

    public TlsNested<A> editOrNewTls() {
        return this.withNewTlsLike(Optional.ofNullable(this.buildTls()).orElse(new ClientTlsBuilder().build()));
    }

    public TlsNested<A> editOrNewTlsLike(ClientTls item) {
        return this.withNewTlsLike(Optional.ofNullable(this.buildTls()).orElse(item));
    }

    public KafkaClientAuthentication buildAuthentication() {
        return this.authentication != null ? (KafkaClientAuthentication)this.authentication.build() : null;
    }

    public A withAuthentication(KafkaClientAuthentication authentication) {
        if (authentication == null) {
            this.authentication = null;
            this._visitables.remove((Object)"authentication");
            return (A)((Object)this);
        }
        VisitableBuilder builder = KafkaConnectSpecFluent.builder(authentication);
        this._visitables.get((Object)"authentication").clear();
        this._visitables.get((Object)"authentication").add(builder);
        this.authentication = builder;
        return (A)((Object)this);
    }

    public boolean hasAuthentication() {
        return this.authentication != null;
    }

    public KafkaClientAuthenticationScramSha512Nested<A> withNewKafkaClientAuthenticationScramSha512() {
        return new KafkaClientAuthenticationScramSha512Nested(null);
    }

    public KafkaClientAuthenticationScramSha512Nested<A> withNewKafkaClientAuthenticationScramSha512Like(KafkaClientAuthenticationScramSha512 item) {
        return new KafkaClientAuthenticationScramSha512Nested(item);
    }

    public KafkaClientAuthenticationTlsNested<A> withNewKafkaClientAuthenticationTls() {
        return new KafkaClientAuthenticationTlsNested(null);
    }

    public KafkaClientAuthenticationTlsNested<A> withNewKafkaClientAuthenticationTlsLike(KafkaClientAuthenticationTls item) {
        return new KafkaClientAuthenticationTlsNested(item);
    }

    public KafkaClientAuthenticationOAuthNested<A> withNewKafkaClientAuthenticationOAuth() {
        return new KafkaClientAuthenticationOAuthNested(null);
    }

    public KafkaClientAuthenticationOAuthNested<A> withNewKafkaClientAuthenticationOAuthLike(KafkaClientAuthenticationOAuth item) {
        return new KafkaClientAuthenticationOAuthNested(item);
    }

    public KafkaClientAuthenticationScramSha256Nested<A> withNewKafkaClientAuthenticationScramSha256() {
        return new KafkaClientAuthenticationScramSha256Nested(null);
    }

    public KafkaClientAuthenticationScramSha256Nested<A> withNewKafkaClientAuthenticationScramSha256Like(KafkaClientAuthenticationScramSha256 item) {
        return new KafkaClientAuthenticationScramSha256Nested(item);
    }

    public KafkaClientAuthenticationPlainNested<A> withNewKafkaClientAuthenticationPlain() {
        return new KafkaClientAuthenticationPlainNested(null);
    }

    public KafkaClientAuthenticationPlainNested<A> withNewKafkaClientAuthenticationPlainLike(KafkaClientAuthenticationPlain item) {
        return new KafkaClientAuthenticationPlainNested(item);
    }

    public Build buildBuild() {
        return this.build != null ? this.build.build() : null;
    }

    public A withBuild(Build build) {
        this._visitables.remove((Object)"build");
        if (build != null) {
            this.build = new BuildBuilder(build);
            this._visitables.get((Object)"build").add(this.build);
        } else {
            this.build = null;
            this._visitables.get((Object)"build").remove((Object)this.build);
        }
        return (A)((Object)this);
    }

    public boolean hasBuild() {
        return this.build != null;
    }

    public BuildNested<A> withNewBuild() {
        return new BuildNested(null);
    }

    public BuildNested<A> withNewBuildLike(Build item) {
        return new BuildNested(item);
    }

    public BuildNested<A> editBuild() {
        return this.withNewBuildLike(Optional.ofNullable(this.buildBuild()).orElse(null));
    }

    public BuildNested<A> editOrNewBuild() {
        return this.withNewBuildLike(Optional.ofNullable(this.buildBuild()).orElse(new BuildBuilder().build()));
    }

    public BuildNested<A> editOrNewBuildLike(Build item) {
        return this.withNewBuildLike(Optional.ofNullable(this.buildBuild()).orElse(item));
    }

    public A addToPlugins(int index, MountedPlugin item) {
        if (this.plugins == null) {
            this.plugins = new ArrayList();
        }
        MountedPluginBuilder builder = new MountedPluginBuilder(item);
        if (index < 0 || index >= this.plugins.size()) {
            this._visitables.get((Object)"plugins").add(builder);
            this.plugins.add(builder);
        } else {
            this._visitables.get((Object)"plugins").add(index, builder);
            this.plugins.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToPlugins(int index, MountedPlugin item) {
        if (this.plugins == null) {
            this.plugins = new ArrayList();
        }
        MountedPluginBuilder builder = new MountedPluginBuilder(item);
        if (index < 0 || index >= this.plugins.size()) {
            this._visitables.get((Object)"plugins").add(builder);
            this.plugins.add(builder);
        } else {
            this._visitables.get((Object)"plugins").set(index, builder);
            this.plugins.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToPlugins(MountedPlugin ... items) {
        if (this.plugins == null) {
            this.plugins = new ArrayList();
        }
        for (MountedPlugin item : items) {
            MountedPluginBuilder builder = new MountedPluginBuilder(item);
            this._visitables.get((Object)"plugins").add(builder);
            this.plugins.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToPlugins(Collection<MountedPlugin> items) {
        if (this.plugins == null) {
            this.plugins = new ArrayList();
        }
        for (MountedPlugin item : items) {
            MountedPluginBuilder builder = new MountedPluginBuilder(item);
            this._visitables.get((Object)"plugins").add(builder);
            this.plugins.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromPlugins(MountedPlugin ... items) {
        if (this.plugins == null) {
            return (A)((Object)this);
        }
        for (MountedPlugin item : items) {
            MountedPluginBuilder builder = new MountedPluginBuilder(item);
            this._visitables.get((Object)"plugins").remove((Object)builder);
            this.plugins.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPlugins(Collection<MountedPlugin> items) {
        if (this.plugins == null) {
            return (A)((Object)this);
        }
        for (MountedPlugin item : items) {
            MountedPluginBuilder builder = new MountedPluginBuilder(item);
            this._visitables.get((Object)"plugins").remove((Object)builder);
            this.plugins.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromPlugins(Predicate<MountedPluginBuilder> predicate) {
        if (this.plugins == null) {
            return (A)((Object)this);
        }
        Iterator<MountedPluginBuilder> each = this.plugins.iterator();
        List visitables = this._visitables.get((Object)"plugins");
        while (each.hasNext()) {
            MountedPluginBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<MountedPlugin> buildPlugins() {
        return this.plugins != null ? KafkaConnectSpecFluent.build(this.plugins) : null;
    }

    public MountedPlugin buildPlugin(int index) {
        return this.plugins.get(index).build();
    }

    public MountedPlugin buildFirstPlugin() {
        return this.plugins.get(0).build();
    }

    public MountedPlugin buildLastPlugin() {
        return this.plugins.get(this.plugins.size() - 1).build();
    }

    public MountedPlugin buildMatchingPlugin(Predicate<MountedPluginBuilder> predicate) {
        for (MountedPluginBuilder item : this.plugins) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPlugin(Predicate<MountedPluginBuilder> predicate) {
        for (MountedPluginBuilder item : this.plugins) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPlugins(List<MountedPlugin> plugins) {
        if (this.plugins != null) {
            this._visitables.get((Object)"plugins").clear();
        }
        if (plugins != null) {
            this.plugins = new ArrayList();
            for (MountedPlugin item : plugins) {
                this.addToPlugins(item);
            }
        } else {
            this.plugins = null;
        }
        return (A)((Object)this);
    }

    public A withPlugins(MountedPlugin ... plugins) {
        if (this.plugins != null) {
            this.plugins.clear();
            this._visitables.remove((Object)"plugins");
        }
        if (plugins != null) {
            for (MountedPlugin item : plugins) {
                this.addToPlugins(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPlugins() {
        return this.plugins != null && !this.plugins.isEmpty();
    }

    public PluginsNested<A> addNewPlugin() {
        return new PluginsNested(-1, null);
    }

    public PluginsNested<A> addNewPluginLike(MountedPlugin item) {
        return new PluginsNested(-1, item);
    }

    public PluginsNested<A> setNewPluginLike(int index, MountedPlugin item) {
        return new PluginsNested(index, item);
    }

    public PluginsNested<A> editPlugin(int index) {
        if (this.plugins.size() <= index) {
            throw new RuntimeException("Can't edit plugins. Index exceeds size.");
        }
        return this.setNewPluginLike(index, this.buildPlugin(index));
    }

    public PluginsNested<A> editFirstPlugin() {
        if (this.plugins.size() == 0) {
            throw new RuntimeException("Can't edit first plugins. The list is empty.");
        }
        return this.setNewPluginLike(0, this.buildPlugin(0));
    }

    public PluginsNested<A> editLastPlugin() {
        int index = this.plugins.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last plugins. The list is empty.");
        }
        return this.setNewPluginLike(index, this.buildPlugin(index));
    }

    public PluginsNested<A> editMatchingPlugin(Predicate<MountedPluginBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.plugins.size(); ++i) {
            if (!predicate.test(this.plugins.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching plugins. No match found.");
        }
        return this.setNewPluginLike(index, this.buildPlugin(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaConnectSpecFluent that = (KafkaConnectSpecFluent)((Object)o);
        if (!Objects.equals(this.config, that.config)) {
            return false;
        }
        if (!Objects.equals(this.bootstrapServers, that.bootstrapServers)) {
            return false;
        }
        if (!Objects.equals((Object)this.tls, (Object)that.tls)) {
            return false;
        }
        if (!Objects.equals(this.authentication, that.authentication)) {
            return false;
        }
        if (!Objects.equals((Object)this.build, (Object)that.build)) {
            return false;
        }
        return Objects.equals(this.plugins, that.plugins);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.config, this.bootstrapServers, this.tls, this.authentication, this.build, this.plugins, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.config != null && !this.config.isEmpty()) {
            sb.append("config:");
            sb.append(String.valueOf(this.config) + ",");
        }
        if (this.bootstrapServers != null) {
            sb.append("bootstrapServers:");
            sb.append(this.bootstrapServers + ",");
        }
        if (this.tls != null) {
            sb.append("tls:");
            sb.append(String.valueOf((Object)this.tls) + ",");
        }
        if (this.authentication != null) {
            sb.append("authentication:");
            sb.append(String.valueOf(this.authentication) + ",");
        }
        if (this.build != null) {
            sb.append("build:");
            sb.append(String.valueOf((Object)this.build) + ",");
        }
        if (this.plugins != null && !this.plugins.isEmpty()) {
            sb.append("plugins:");
            sb.append(this.plugins);
        }
        sb.append("}");
        return sb.toString();
    }

    protected static <T> VisitableBuilder<T, ?> builder(Object item) {
        switch (item.getClass().getName()) {
            case "io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationScramSha512": {
                return new KafkaClientAuthenticationScramSha512Builder((KafkaClientAuthenticationScramSha512)item);
            }
            case "io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationTls": {
                return new KafkaClientAuthenticationTlsBuilder((KafkaClientAuthenticationTls)item);
            }
            case "io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationOAuth": {
                return new KafkaClientAuthenticationOAuthBuilder((KafkaClientAuthenticationOAuth)item);
            }
            case "io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationScramSha256": {
                return new KafkaClientAuthenticationScramSha256Builder((KafkaClientAuthenticationScramSha256)item);
            }
            case "io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationPlain": {
                return new KafkaClientAuthenticationPlainBuilder((KafkaClientAuthenticationPlain)item);
            }
        }
        return KafkaConnectSpecFluent.builderOf((Object)item);
    }

    public class TlsNested<N>
    extends ClientTlsFluent<TlsNested<N>>
    implements Nested<N> {
        ClientTlsBuilder builder;

        TlsNested(ClientTls item) {
            this.builder = new ClientTlsBuilder(this, item);
        }

        public N and() {
            return (N)KafkaConnectSpecFluent.this.withTls(this.builder.build());
        }

        public N endTls() {
            return this.and();
        }
    }

    public class KafkaClientAuthenticationScramSha512Nested<N>
    extends KafkaClientAuthenticationScramSha512Fluent<KafkaClientAuthenticationScramSha512Nested<N>>
    implements Nested<N> {
        KafkaClientAuthenticationScramSha512Builder builder;

        KafkaClientAuthenticationScramSha512Nested(KafkaClientAuthenticationScramSha512 item) {
            this.builder = new KafkaClientAuthenticationScramSha512Builder(this, item);
        }

        public N and() {
            return (N)KafkaConnectSpecFluent.this.withAuthentication(this.builder.build());
        }

        public N endKafkaClientAuthenticationScramSha512() {
            return this.and();
        }
    }

    public class KafkaClientAuthenticationTlsNested<N>
    extends KafkaClientAuthenticationTlsFluent<KafkaClientAuthenticationTlsNested<N>>
    implements Nested<N> {
        KafkaClientAuthenticationTlsBuilder builder;

        KafkaClientAuthenticationTlsNested(KafkaClientAuthenticationTls item) {
            this.builder = new KafkaClientAuthenticationTlsBuilder(this, item);
        }

        public N and() {
            return (N)KafkaConnectSpecFluent.this.withAuthentication(this.builder.build());
        }

        public N endKafkaClientAuthenticationTls() {
            return this.and();
        }
    }

    public class KafkaClientAuthenticationOAuthNested<N>
    extends KafkaClientAuthenticationOAuthFluent<KafkaClientAuthenticationOAuthNested<N>>
    implements Nested<N> {
        KafkaClientAuthenticationOAuthBuilder builder;

        KafkaClientAuthenticationOAuthNested(KafkaClientAuthenticationOAuth item) {
            this.builder = new KafkaClientAuthenticationOAuthBuilder(this, item);
        }

        public N and() {
            return (N)KafkaConnectSpecFluent.this.withAuthentication(this.builder.build());
        }

        public N endKafkaClientAuthenticationOAuth() {
            return this.and();
        }
    }

    public class KafkaClientAuthenticationScramSha256Nested<N>
    extends KafkaClientAuthenticationScramSha256Fluent<KafkaClientAuthenticationScramSha256Nested<N>>
    implements Nested<N> {
        KafkaClientAuthenticationScramSha256Builder builder;

        KafkaClientAuthenticationScramSha256Nested(KafkaClientAuthenticationScramSha256 item) {
            this.builder = new KafkaClientAuthenticationScramSha256Builder(this, item);
        }

        public N and() {
            return (N)KafkaConnectSpecFluent.this.withAuthentication(this.builder.build());
        }

        public N endKafkaClientAuthenticationScramSha256() {
            return this.and();
        }
    }

    public class KafkaClientAuthenticationPlainNested<N>
    extends KafkaClientAuthenticationPlainFluent<KafkaClientAuthenticationPlainNested<N>>
    implements Nested<N> {
        KafkaClientAuthenticationPlainBuilder builder;

        KafkaClientAuthenticationPlainNested(KafkaClientAuthenticationPlain item) {
            this.builder = new KafkaClientAuthenticationPlainBuilder(this, item);
        }

        public N and() {
            return (N)KafkaConnectSpecFluent.this.withAuthentication(this.builder.build());
        }

        public N endKafkaClientAuthenticationPlain() {
            return this.and();
        }
    }

    public class BuildNested<N>
    extends BuildFluent<BuildNested<N>>
    implements Nested<N> {
        BuildBuilder builder;

        BuildNested(Build item) {
            this.builder = new BuildBuilder(this, item);
        }

        public N and() {
            return (N)KafkaConnectSpecFluent.this.withBuild(this.builder.build());
        }

        public N endBuild() {
            return this.and();
        }
    }

    public class PluginsNested<N>
    extends MountedPluginFluent<PluginsNested<N>>
    implements Nested<N> {
        MountedPluginBuilder builder;
        int index;

        PluginsNested(int index, MountedPlugin item) {
            this.index = index;
            this.builder = new MountedPluginBuilder(this, item);
        }

        public N and() {
            return (N)KafkaConnectSpecFluent.this.setToPlugins(this.index, this.builder.build());
        }

        public N endPlugin() {
            return this.and();
        }
    }
}

