/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.common.authentication;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.common.PasswordSecretSource;
import io.strimzi.api.kafka.model.common.authentication.KafkaClientAuthenticationScram;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.DescriptionFile;

@DescriptionFile
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "username", "passwordSecret"})
public class KafkaClientAuthenticationScramSha256
extends KafkaClientAuthenticationScram {
    public static final String TYPE_SCRAM_SHA_256 = "scram-sha-256";
    private String username;
    private PasswordSecretSource passwordSecret;

    @Override
    @Description(value="Must be `scram-sha-256`")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getType() {
        return TYPE_SCRAM_SHA_256;
    }

    @Override
    @Description(value="Reference to the `Secret` which holds the password.")
    public PasswordSecretSource getPasswordSecret() {
        return this.passwordSecret;
    }

    @Override
    public void setPasswordSecret(PasswordSecretSource passwordSecret) {
        this.passwordSecret = passwordSecret;
    }

    @Override
    @Description(value="Username used for the authentication.")
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaClientAuthenticationScramSha256)) {
            return false;
        }
        KafkaClientAuthenticationScramSha256 other = (KafkaClientAuthenticationScramSha256)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        PasswordSecretSource this$passwordSecret = this.getPasswordSecret();
        PasswordSecretSource other$passwordSecret = other.getPasswordSecret();
        return !(this$passwordSecret == null ? other$passwordSecret != null : !((Object)this$passwordSecret).equals(other$passwordSecret));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaClientAuthenticationScramSha256;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        PasswordSecretSource $passwordSecret = this.getPasswordSecret();
        result = result * 59 + ($passwordSecret == null ? 43 : ((Object)$passwordSecret).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "KafkaClientAuthenticationScramSha256(super=" + super.toString() + ", username=" + this.getUsername() + ", passwordSecret=" + String.valueOf(this.getPasswordSecret()) + ")";
    }
}

