/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.common;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.strimzi.api.kafka.model.common.CertificateAuthority;
import io.strimzi.api.kafka.model.common.CertificateExpirationPolicy;
import java.util.Objects;

public class CertificateAuthorityFluent<A extends CertificateAuthorityFluent<A>>
extends BaseFluent<A> {
    private int validityDays;
    private boolean generateCertificateAuthority;
    private boolean generateSecretOwnerReference;
    private int renewalDays;
    private CertificateExpirationPolicy certificateExpirationPolicy;

    public CertificateAuthorityFluent() {
    }

    public CertificateAuthorityFluent(CertificateAuthority instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(CertificateAuthority instance) {
        CertificateAuthority certificateAuthority = instance = instance != null ? instance : new CertificateAuthority();
        if (instance != null) {
            this.withValidityDays(instance.getValidityDays());
            this.withGenerateCertificateAuthority(instance.isGenerateCertificateAuthority());
            this.withGenerateSecretOwnerReference(instance.isGenerateSecretOwnerReference());
            this.withRenewalDays(instance.getRenewalDays());
            this.withCertificateExpirationPolicy(instance.getCertificateExpirationPolicy());
        }
    }

    public int getValidityDays() {
        return this.validityDays;
    }

    public A withValidityDays(int validityDays) {
        this.validityDays = validityDays;
        return (A)((Object)this);
    }

    public boolean hasValidityDays() {
        return true;
    }

    public boolean isGenerateCertificateAuthority() {
        return this.generateCertificateAuthority;
    }

    public A withGenerateCertificateAuthority(boolean generateCertificateAuthority) {
        this.generateCertificateAuthority = generateCertificateAuthority;
        return (A)((Object)this);
    }

    public boolean hasGenerateCertificateAuthority() {
        return true;
    }

    public boolean isGenerateSecretOwnerReference() {
        return this.generateSecretOwnerReference;
    }

    public A withGenerateSecretOwnerReference(boolean generateSecretOwnerReference) {
        this.generateSecretOwnerReference = generateSecretOwnerReference;
        return (A)((Object)this);
    }

    public boolean hasGenerateSecretOwnerReference() {
        return true;
    }

    public int getRenewalDays() {
        return this.renewalDays;
    }

    public A withRenewalDays(int renewalDays) {
        this.renewalDays = renewalDays;
        return (A)((Object)this);
    }

    public boolean hasRenewalDays() {
        return true;
    }

    public CertificateExpirationPolicy getCertificateExpirationPolicy() {
        return this.certificateExpirationPolicy;
    }

    public A withCertificateExpirationPolicy(CertificateExpirationPolicy certificateExpirationPolicy) {
        this.certificateExpirationPolicy = certificateExpirationPolicy;
        return (A)((Object)this);
    }

    public boolean hasCertificateExpirationPolicy() {
        return this.certificateExpirationPolicy != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CertificateAuthorityFluent that = (CertificateAuthorityFluent)((Object)o);
        if (this.validityDays != that.validityDays) {
            return false;
        }
        if (this.generateCertificateAuthority != that.generateCertificateAuthority) {
            return false;
        }
        if (this.generateSecretOwnerReference != that.generateSecretOwnerReference) {
            return false;
        }
        if (this.renewalDays != that.renewalDays) {
            return false;
        }
        return Objects.equals((Object)this.certificateExpirationPolicy, (Object)that.certificateExpirationPolicy);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.validityDays, this.generateCertificateAuthority, this.generateSecretOwnerReference, this.renewalDays, this.certificateExpirationPolicy, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("validityDays:");
        sb.append(this.validityDays + ",");
        sb.append("generateCertificateAuthority:");
        sb.append(this.generateCertificateAuthority + ",");
        sb.append("generateSecretOwnerReference:");
        sb.append(this.generateSecretOwnerReference + ",");
        sb.append("renewalDays:");
        sb.append(this.renewalDays + ",");
        if (this.certificateExpirationPolicy != null) {
            sb.append("certificateExpirationPolicy:");
            sb.append((Object)this.certificateExpirationPolicy);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withGenerateCertificateAuthority() {
        return this.withGenerateCertificateAuthority(true);
    }

    public A withGenerateSecretOwnerReference() {
        return this.withGenerateSecretOwnerReference(true);
    }
}

