/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.bridge;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.common.UnknownPropertyPreserving;
import io.strimzi.api.kafka.model.common.template.ContainerTemplate;
import io.strimzi.api.kafka.model.common.template.DeploymentTemplate;
import io.strimzi.api.kafka.model.common.template.InternalServiceTemplate;
import io.strimzi.api.kafka.model.common.template.PodDisruptionBudgetTemplate;
import io.strimzi.api.kafka.model.common.template.PodTemplate;
import io.strimzi.api.kafka.model.common.template.ResourceTemplate;
import io.strimzi.crdgenerator.annotations.Description;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"deployment", "pod", "apiService", "podDisruptionBudget", "bridgeContainer", "clusterRoleBinding", "serviceAccount", "initContainer"})
public class KafkaBridgeTemplate
implements UnknownPropertyPreserving {
    private DeploymentTemplate deployment;
    private PodTemplate pod;
    private InternalServiceTemplate apiService;
    private PodDisruptionBudgetTemplate podDisruptionBudget;
    private ContainerTemplate bridgeContainer;
    private ContainerTemplate initContainer;
    private ResourceTemplate clusterRoleBinding;
    private ResourceTemplate serviceAccount;
    private Map<String, Object> additionalProperties;

    @Description(value="Template for Kafka Bridge `Deployment`.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public DeploymentTemplate getDeployment() {
        return this.deployment;
    }

    public void setDeployment(DeploymentTemplate deployment) {
        this.deployment = deployment;
    }

    @Description(value="Template for Kafka Bridge `Pods`.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public PodTemplate getPod() {
        return this.pod;
    }

    public void setPod(PodTemplate pod) {
        this.pod = pod;
    }

    @Description(value="Template for Kafka Bridge API `Service`.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public InternalServiceTemplate getApiService() {
        return this.apiService;
    }

    public void setApiService(InternalServiceTemplate apiService) {
        this.apiService = apiService;
    }

    @Description(value="Template for Kafka Bridge `PodDisruptionBudget`.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public PodDisruptionBudgetTemplate getPodDisruptionBudget() {
        return this.podDisruptionBudget;
    }

    public void setPodDisruptionBudget(PodDisruptionBudgetTemplate podDisruptionBudget) {
        this.podDisruptionBudget = podDisruptionBudget;
    }

    @Description(value="Template for the Kafka Bridge container")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ContainerTemplate getBridgeContainer() {
        return this.bridgeContainer;
    }

    public void setBridgeContainer(ContainerTemplate bridgeContainer) {
        this.bridgeContainer = bridgeContainer;
    }

    @Description(value="Template for the Kafka Bridge init container")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ContainerTemplate getInitContainer() {
        return this.initContainer;
    }

    public void setInitContainer(ContainerTemplate initContainer) {
        this.initContainer = initContainer;
    }

    @Description(value="Template for the Kafka Bridge ClusterRoleBinding.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ResourceTemplate getClusterRoleBinding() {
        return this.clusterRoleBinding;
    }

    public void setClusterRoleBinding(ResourceTemplate clusterRoleBinding) {
        this.clusterRoleBinding = clusterRoleBinding;
    }

    @Description(value="Template for the Kafka Bridge service account.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ResourceTemplate getServiceAccount() {
        return this.serviceAccount;
    }

    public void setServiceAccount(ResourceTemplate serviceAccount) {
        this.serviceAccount = serviceAccount;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties != null ? this.additionalProperties : Map.of();
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>(2);
        }
        this.additionalProperties.put(name, value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaBridgeTemplate)) {
            return false;
        }
        KafkaBridgeTemplate other = (KafkaBridgeTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DeploymentTemplate this$deployment = this.getDeployment();
        DeploymentTemplate other$deployment = other.getDeployment();
        if (this$deployment == null ? other$deployment != null : !((Object)this$deployment).equals(other$deployment)) {
            return false;
        }
        PodTemplate this$pod = this.getPod();
        PodTemplate other$pod = other.getPod();
        if (this$pod == null ? other$pod != null : !((Object)this$pod).equals(other$pod)) {
            return false;
        }
        InternalServiceTemplate this$apiService = this.getApiService();
        InternalServiceTemplate other$apiService = other.getApiService();
        if (this$apiService == null ? other$apiService != null : !((Object)this$apiService).equals(other$apiService)) {
            return false;
        }
        PodDisruptionBudgetTemplate this$podDisruptionBudget = this.getPodDisruptionBudget();
        PodDisruptionBudgetTemplate other$podDisruptionBudget = other.getPodDisruptionBudget();
        if (this$podDisruptionBudget == null ? other$podDisruptionBudget != null : !((Object)this$podDisruptionBudget).equals(other$podDisruptionBudget)) {
            return false;
        }
        ContainerTemplate this$bridgeContainer = this.getBridgeContainer();
        ContainerTemplate other$bridgeContainer = other.getBridgeContainer();
        if (this$bridgeContainer == null ? other$bridgeContainer != null : !((Object)this$bridgeContainer).equals(other$bridgeContainer)) {
            return false;
        }
        ContainerTemplate this$initContainer = this.getInitContainer();
        ContainerTemplate other$initContainer = other.getInitContainer();
        if (this$initContainer == null ? other$initContainer != null : !((Object)this$initContainer).equals(other$initContainer)) {
            return false;
        }
        ResourceTemplate this$clusterRoleBinding = this.getClusterRoleBinding();
        ResourceTemplate other$clusterRoleBinding = other.getClusterRoleBinding();
        if (this$clusterRoleBinding == null ? other$clusterRoleBinding != null : !((Object)this$clusterRoleBinding).equals(other$clusterRoleBinding)) {
            return false;
        }
        ResourceTemplate this$serviceAccount = this.getServiceAccount();
        ResourceTemplate other$serviceAccount = other.getServiceAccount();
        if (this$serviceAccount == null ? other$serviceAccount != null : !((Object)this$serviceAccount).equals(other$serviceAccount)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaBridgeTemplate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DeploymentTemplate $deployment = this.getDeployment();
        result = result * 59 + ($deployment == null ? 43 : ((Object)$deployment).hashCode());
        PodTemplate $pod = this.getPod();
        result = result * 59 + ($pod == null ? 43 : ((Object)$pod).hashCode());
        InternalServiceTemplate $apiService = this.getApiService();
        result = result * 59 + ($apiService == null ? 43 : ((Object)$apiService).hashCode());
        PodDisruptionBudgetTemplate $podDisruptionBudget = this.getPodDisruptionBudget();
        result = result * 59 + ($podDisruptionBudget == null ? 43 : ((Object)$podDisruptionBudget).hashCode());
        ContainerTemplate $bridgeContainer = this.getBridgeContainer();
        result = result * 59 + ($bridgeContainer == null ? 43 : ((Object)$bridgeContainer).hashCode());
        ContainerTemplate $initContainer = this.getInitContainer();
        result = result * 59 + ($initContainer == null ? 43 : ((Object)$initContainer).hashCode());
        ResourceTemplate $clusterRoleBinding = this.getClusterRoleBinding();
        result = result * 59 + ($clusterRoleBinding == null ? 43 : ((Object)$clusterRoleBinding).hashCode());
        ResourceTemplate $serviceAccount = this.getServiceAccount();
        result = result * 59 + ($serviceAccount == null ? 43 : ((Object)$serviceAccount).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }

    public String toString() {
        return "KafkaBridgeTemplate(deployment=" + String.valueOf(this.getDeployment()) + ", pod=" + String.valueOf(this.getPod()) + ", apiService=" + String.valueOf(this.getApiService()) + ", podDisruptionBudget=" + String.valueOf(this.getPodDisruptionBudget()) + ", bridgeContainer=" + String.valueOf(this.getBridgeContainer()) + ", initContainer=" + String.valueOf(this.getInitContainer()) + ", clusterRoleBinding=" + String.valueOf(this.getClusterRoleBinding()) + ", serviceAccount=" + String.valueOf(this.getServiceAccount()) + ", additionalProperties=" + String.valueOf(this.getAdditionalProperties()) + ")";
    }
}

