/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.topic;

import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.kafka.StatusFluent;
import io.strimzi.api.kafka.model.topic.KafkaTopicStatus;
import io.strimzi.api.kafka.model.topic.ReplicasChangeStatus;
import io.strimzi.api.kafka.model.topic.ReplicasChangeStatusBuilder;
import io.strimzi.api.kafka.model.topic.ReplicasChangeStatusFluent;
import java.util.Objects;
import java.util.Optional;

public class KafkaTopicStatusFluent<A extends KafkaTopicStatusFluent<A>>
extends StatusFluent<A> {
    private String topicName;
    private String topicId;
    private ReplicasChangeStatusBuilder replicasChange;

    public KafkaTopicStatusFluent() {
    }

    public KafkaTopicStatusFluent(KafkaTopicStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(KafkaTopicStatus instance) {
        KafkaTopicStatus kafkaTopicStatus = instance = instance != null ? instance : new KafkaTopicStatus();
        if (instance != null) {
            this.withTopicName(instance.getTopicName());
            this.withTopicId(instance.getTopicId());
            this.withReplicasChange(instance.getReplicasChange());
            this.withConditions(instance.getConditions());
            this.withObservedGeneration(instance.getObservedGeneration());
        }
    }

    public String getTopicName() {
        return this.topicName;
    }

    public A withTopicName(String topicName) {
        this.topicName = topicName;
        return (A)((Object)this);
    }

    public boolean hasTopicName() {
        return this.topicName != null;
    }

    public String getTopicId() {
        return this.topicId;
    }

    public A withTopicId(String topicId) {
        this.topicId = topicId;
        return (A)((Object)this);
    }

    public boolean hasTopicId() {
        return this.topicId != null;
    }

    public ReplicasChangeStatus buildReplicasChange() {
        return this.replicasChange != null ? this.replicasChange.build() : null;
    }

    public A withReplicasChange(ReplicasChangeStatus replicasChange) {
        this._visitables.remove((Object)"replicasChange");
        if (replicasChange != null) {
            this.replicasChange = new ReplicasChangeStatusBuilder(replicasChange);
            this._visitables.get((Object)"replicasChange").add(this.replicasChange);
        } else {
            this.replicasChange = null;
            this._visitables.get((Object)"replicasChange").remove((Object)this.replicasChange);
        }
        return (A)((Object)this);
    }

    public boolean hasReplicasChange() {
        return this.replicasChange != null;
    }

    public ReplicasChangeNested<A> withNewReplicasChange() {
        return new ReplicasChangeNested(null);
    }

    public ReplicasChangeNested<A> withNewReplicasChangeLike(ReplicasChangeStatus item) {
        return new ReplicasChangeNested(item);
    }

    public ReplicasChangeNested<A> editReplicasChange() {
        return this.withNewReplicasChangeLike(Optional.ofNullable(this.buildReplicasChange()).orElse(null));
    }

    public ReplicasChangeNested<A> editOrNewReplicasChange() {
        return this.withNewReplicasChangeLike(Optional.ofNullable(this.buildReplicasChange()).orElse(new ReplicasChangeStatusBuilder().build()));
    }

    public ReplicasChangeNested<A> editOrNewReplicasChangeLike(ReplicasChangeStatus item) {
        return this.withNewReplicasChangeLike(Optional.ofNullable(this.buildReplicasChange()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaTopicStatusFluent that = (KafkaTopicStatusFluent)((Object)o);
        if (!Objects.equals(this.topicName, that.topicName)) {
            return false;
        }
        if (!Objects.equals(this.topicId, that.topicId)) {
            return false;
        }
        return Objects.equals((Object)this.replicasChange, (Object)that.replicasChange);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.topicName, this.topicId, this.replicasChange, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.topicName != null) {
            sb.append("topicName:");
            sb.append(this.topicName + ",");
        }
        if (this.topicId != null) {
            sb.append("topicId:");
            sb.append(this.topicId + ",");
        }
        if (this.replicasChange != null) {
            sb.append("replicasChange:");
            sb.append((Object)this.replicasChange);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ReplicasChangeNested<N>
    extends ReplicasChangeStatusFluent<ReplicasChangeNested<N>>
    implements Nested<N> {
        ReplicasChangeStatusBuilder builder;

        ReplicasChangeNested(ReplicasChangeStatus item) {
            this.builder = new ReplicasChangeStatusBuilder(this, item);
        }

        public N and() {
            return (N)KafkaTopicStatusFluent.this.withReplicasChange(this.builder.build());
        }

        public N endReplicasChange() {
            return this.and();
        }
    }
}

