/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.mirrormaker;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.common.template.ContainerTemplate;
import io.strimzi.api.kafka.model.common.template.ContainerTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.ContainerTemplateFluent;
import io.strimzi.api.kafka.model.common.template.DeploymentTemplate;
import io.strimzi.api.kafka.model.common.template.DeploymentTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.DeploymentTemplateFluent;
import io.strimzi.api.kafka.model.common.template.PodDisruptionBudgetTemplate;
import io.strimzi.api.kafka.model.common.template.PodDisruptionBudgetTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.PodDisruptionBudgetTemplateFluent;
import io.strimzi.api.kafka.model.common.template.PodTemplate;
import io.strimzi.api.kafka.model.common.template.PodTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.PodTemplateFluent;
import io.strimzi.api.kafka.model.common.template.ResourceTemplate;
import io.strimzi.api.kafka.model.common.template.ResourceTemplateBuilder;
import io.strimzi.api.kafka.model.common.template.ResourceTemplateFluent;
import io.strimzi.api.kafka.model.mirrormaker.KafkaMirrorMakerTemplate;
import java.util.Objects;
import java.util.Optional;

public class KafkaMirrorMakerTemplateFluent<A extends KafkaMirrorMakerTemplateFluent<A>>
extends BaseFluent<A> {
    private DeploymentTemplateBuilder deployment;
    private PodTemplateBuilder pod;
    private PodDisruptionBudgetTemplateBuilder podDisruptionBudget;
    private ContainerTemplateBuilder mirrorMakerContainer;
    private ResourceTemplateBuilder serviceAccount;

    public KafkaMirrorMakerTemplateFluent() {
    }

    public KafkaMirrorMakerTemplateFluent(KafkaMirrorMakerTemplate instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(KafkaMirrorMakerTemplate instance) {
        KafkaMirrorMakerTemplate kafkaMirrorMakerTemplate = instance = instance != null ? instance : new KafkaMirrorMakerTemplate();
        if (instance != null) {
            this.withDeployment(instance.getDeployment());
            this.withPod(instance.getPod());
            this.withPodDisruptionBudget(instance.getPodDisruptionBudget());
            this.withMirrorMakerContainer(instance.getMirrorMakerContainer());
            this.withServiceAccount(instance.getServiceAccount());
        }
    }

    public DeploymentTemplate buildDeployment() {
        return this.deployment != null ? this.deployment.build() : null;
    }

    public A withDeployment(DeploymentTemplate deployment) {
        this._visitables.remove((Object)"deployment");
        if (deployment != null) {
            this.deployment = new DeploymentTemplateBuilder(deployment);
            this._visitables.get((Object)"deployment").add(this.deployment);
        } else {
            this.deployment = null;
            this._visitables.get((Object)"deployment").remove((Object)this.deployment);
        }
        return (A)((Object)this);
    }

    public boolean hasDeployment() {
        return this.deployment != null;
    }

    public DeploymentNested<A> withNewDeployment() {
        return new DeploymentNested(null);
    }

    public DeploymentNested<A> withNewDeploymentLike(DeploymentTemplate item) {
        return new DeploymentNested(item);
    }

    public DeploymentNested<A> editDeployment() {
        return this.withNewDeploymentLike(Optional.ofNullable(this.buildDeployment()).orElse(null));
    }

    public DeploymentNested<A> editOrNewDeployment() {
        return this.withNewDeploymentLike(Optional.ofNullable(this.buildDeployment()).orElse(new DeploymentTemplateBuilder().build()));
    }

    public DeploymentNested<A> editOrNewDeploymentLike(DeploymentTemplate item) {
        return this.withNewDeploymentLike(Optional.ofNullable(this.buildDeployment()).orElse(item));
    }

    public PodTemplate buildPod() {
        return this.pod != null ? this.pod.build() : null;
    }

    public A withPod(PodTemplate pod) {
        this._visitables.remove((Object)"pod");
        if (pod != null) {
            this.pod = new PodTemplateBuilder(pod);
            this._visitables.get((Object)"pod").add(this.pod);
        } else {
            this.pod = null;
            this._visitables.get((Object)"pod").remove((Object)this.pod);
        }
        return (A)((Object)this);
    }

    public boolean hasPod() {
        return this.pod != null;
    }

    public PodNested<A> withNewPod() {
        return new PodNested(null);
    }

    public PodNested<A> withNewPodLike(PodTemplate item) {
        return new PodNested(item);
    }

    public PodNested<A> editPod() {
        return this.withNewPodLike(Optional.ofNullable(this.buildPod()).orElse(null));
    }

    public PodNested<A> editOrNewPod() {
        return this.withNewPodLike(Optional.ofNullable(this.buildPod()).orElse(new PodTemplateBuilder().build()));
    }

    public PodNested<A> editOrNewPodLike(PodTemplate item) {
        return this.withNewPodLike(Optional.ofNullable(this.buildPod()).orElse(item));
    }

    public PodDisruptionBudgetTemplate buildPodDisruptionBudget() {
        return this.podDisruptionBudget != null ? this.podDisruptionBudget.build() : null;
    }

    public A withPodDisruptionBudget(PodDisruptionBudgetTemplate podDisruptionBudget) {
        this._visitables.remove((Object)"podDisruptionBudget");
        if (podDisruptionBudget != null) {
            this.podDisruptionBudget = new PodDisruptionBudgetTemplateBuilder(podDisruptionBudget);
            this._visitables.get((Object)"podDisruptionBudget").add(this.podDisruptionBudget);
        } else {
            this.podDisruptionBudget = null;
            this._visitables.get((Object)"podDisruptionBudget").remove((Object)this.podDisruptionBudget);
        }
        return (A)((Object)this);
    }

    public boolean hasPodDisruptionBudget() {
        return this.podDisruptionBudget != null;
    }

    public PodDisruptionBudgetNested<A> withNewPodDisruptionBudget() {
        return new PodDisruptionBudgetNested(null);
    }

    public PodDisruptionBudgetNested<A> withNewPodDisruptionBudgetLike(PodDisruptionBudgetTemplate item) {
        return new PodDisruptionBudgetNested(item);
    }

    public PodDisruptionBudgetNested<A> editPodDisruptionBudget() {
        return this.withNewPodDisruptionBudgetLike(Optional.ofNullable(this.buildPodDisruptionBudget()).orElse(null));
    }

    public PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudget() {
        return this.withNewPodDisruptionBudgetLike(Optional.ofNullable(this.buildPodDisruptionBudget()).orElse(new PodDisruptionBudgetTemplateBuilder().build()));
    }

    public PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudgetLike(PodDisruptionBudgetTemplate item) {
        return this.withNewPodDisruptionBudgetLike(Optional.ofNullable(this.buildPodDisruptionBudget()).orElse(item));
    }

    public ContainerTemplate buildMirrorMakerContainer() {
        return this.mirrorMakerContainer != null ? this.mirrorMakerContainer.build() : null;
    }

    public A withMirrorMakerContainer(ContainerTemplate mirrorMakerContainer) {
        this._visitables.remove((Object)"mirrorMakerContainer");
        if (mirrorMakerContainer != null) {
            this.mirrorMakerContainer = new ContainerTemplateBuilder(mirrorMakerContainer);
            this._visitables.get((Object)"mirrorMakerContainer").add(this.mirrorMakerContainer);
        } else {
            this.mirrorMakerContainer = null;
            this._visitables.get((Object)"mirrorMakerContainer").remove((Object)this.mirrorMakerContainer);
        }
        return (A)((Object)this);
    }

    public boolean hasMirrorMakerContainer() {
        return this.mirrorMakerContainer != null;
    }

    public MirrorMakerContainerNested<A> withNewMirrorMakerContainer() {
        return new MirrorMakerContainerNested(null);
    }

    public MirrorMakerContainerNested<A> withNewMirrorMakerContainerLike(ContainerTemplate item) {
        return new MirrorMakerContainerNested(item);
    }

    public MirrorMakerContainerNested<A> editMirrorMakerContainer() {
        return this.withNewMirrorMakerContainerLike(Optional.ofNullable(this.buildMirrorMakerContainer()).orElse(null));
    }

    public MirrorMakerContainerNested<A> editOrNewMirrorMakerContainer() {
        return this.withNewMirrorMakerContainerLike(Optional.ofNullable(this.buildMirrorMakerContainer()).orElse(new ContainerTemplateBuilder().build()));
    }

    public MirrorMakerContainerNested<A> editOrNewMirrorMakerContainerLike(ContainerTemplate item) {
        return this.withNewMirrorMakerContainerLike(Optional.ofNullable(this.buildMirrorMakerContainer()).orElse(item));
    }

    public ResourceTemplate buildServiceAccount() {
        return this.serviceAccount != null ? this.serviceAccount.build() : null;
    }

    public A withServiceAccount(ResourceTemplate serviceAccount) {
        this._visitables.remove((Object)"serviceAccount");
        if (serviceAccount != null) {
            this.serviceAccount = new ResourceTemplateBuilder(serviceAccount);
            this._visitables.get((Object)"serviceAccount").add(this.serviceAccount);
        } else {
            this.serviceAccount = null;
            this._visitables.get((Object)"serviceAccount").remove((Object)this.serviceAccount);
        }
        return (A)((Object)this);
    }

    public boolean hasServiceAccount() {
        return this.serviceAccount != null;
    }

    public ServiceAccountNested<A> withNewServiceAccount() {
        return new ServiceAccountNested(null);
    }

    public ServiceAccountNested<A> withNewServiceAccountLike(ResourceTemplate item) {
        return new ServiceAccountNested(item);
    }

    public ServiceAccountNested<A> editServiceAccount() {
        return this.withNewServiceAccountLike(Optional.ofNullable(this.buildServiceAccount()).orElse(null));
    }

    public ServiceAccountNested<A> editOrNewServiceAccount() {
        return this.withNewServiceAccountLike(Optional.ofNullable(this.buildServiceAccount()).orElse(new ResourceTemplateBuilder().build()));
    }

    public ServiceAccountNested<A> editOrNewServiceAccountLike(ResourceTemplate item) {
        return this.withNewServiceAccountLike(Optional.ofNullable(this.buildServiceAccount()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaMirrorMakerTemplateFluent that = (KafkaMirrorMakerTemplateFluent)((Object)o);
        if (!Objects.equals((Object)this.deployment, (Object)that.deployment)) {
            return false;
        }
        if (!Objects.equals((Object)this.pod, (Object)that.pod)) {
            return false;
        }
        if (!Objects.equals((Object)this.podDisruptionBudget, (Object)that.podDisruptionBudget)) {
            return false;
        }
        if (!Objects.equals((Object)this.mirrorMakerContainer, (Object)that.mirrorMakerContainer)) {
            return false;
        }
        return Objects.equals((Object)this.serviceAccount, (Object)that.serviceAccount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.deployment, this.pod, this.podDisruptionBudget, this.mirrorMakerContainer, this.serviceAccount, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.deployment != null) {
            sb.append("deployment:");
            sb.append(String.valueOf((Object)this.deployment) + ",");
        }
        if (this.pod != null) {
            sb.append("pod:");
            sb.append(String.valueOf((Object)this.pod) + ",");
        }
        if (this.podDisruptionBudget != null) {
            sb.append("podDisruptionBudget:");
            sb.append(String.valueOf((Object)this.podDisruptionBudget) + ",");
        }
        if (this.mirrorMakerContainer != null) {
            sb.append("mirrorMakerContainer:");
            sb.append(String.valueOf((Object)this.mirrorMakerContainer) + ",");
        }
        if (this.serviceAccount != null) {
            sb.append("serviceAccount:");
            sb.append((Object)this.serviceAccount);
        }
        sb.append("}");
        return sb.toString();
    }

    public class DeploymentNested<N>
    extends DeploymentTemplateFluent<DeploymentNested<N>>
    implements Nested<N> {
        DeploymentTemplateBuilder builder;

        DeploymentNested(DeploymentTemplate item) {
            this.builder = new DeploymentTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaMirrorMakerTemplateFluent.this.withDeployment(this.builder.build());
        }

        public N endDeployment() {
            return this.and();
        }
    }

    public class PodNested<N>
    extends PodTemplateFluent<PodNested<N>>
    implements Nested<N> {
        PodTemplateBuilder builder;

        PodNested(PodTemplate item) {
            this.builder = new PodTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaMirrorMakerTemplateFluent.this.withPod(this.builder.build());
        }

        public N endPod() {
            return this.and();
        }
    }

    public class PodDisruptionBudgetNested<N>
    extends PodDisruptionBudgetTemplateFluent<PodDisruptionBudgetNested<N>>
    implements Nested<N> {
        PodDisruptionBudgetTemplateBuilder builder;

        PodDisruptionBudgetNested(PodDisruptionBudgetTemplate item) {
            this.builder = new PodDisruptionBudgetTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaMirrorMakerTemplateFluent.this.withPodDisruptionBudget(this.builder.build());
        }

        public N endPodDisruptionBudget() {
            return this.and();
        }
    }

    public class MirrorMakerContainerNested<N>
    extends ContainerTemplateFluent<MirrorMakerContainerNested<N>>
    implements Nested<N> {
        ContainerTemplateBuilder builder;

        MirrorMakerContainerNested(ContainerTemplate item) {
            this.builder = new ContainerTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaMirrorMakerTemplateFluent.this.withMirrorMakerContainer(this.builder.build());
        }

        public N endMirrorMakerContainer() {
            return this.and();
        }
    }

    public class ServiceAccountNested<N>
    extends ResourceTemplateFluent<ServiceAccountNested<N>>
    implements Nested<N> {
        ResourceTemplateBuilder builder;

        ServiceAccountNested(ResourceTemplate item) {
            this.builder = new ResourceTemplateBuilder(this, item);
        }

        public N and() {
            return (N)KafkaMirrorMakerTemplateFluent.this.withServiceAccount(this.builder.build());
        }

        public N endServiceAccount() {
            return this.and();
        }
    }
}

