/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.kafka.quotas;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.kafka.quotas.QuotasPlugin;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.Maximum;
import io.strimzi.crdgenerator.annotations.Minimum;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "producerByteRate", "consumerByteRate", "minAvailableBytesPerVolume", "minAvailableRatioPerVolume", "excludedPrincipals"})
public class QuotasPluginStrimzi
extends QuotasPlugin {
    private static final long serialVersionUID = 1L;
    public static final String TYPE_STRIMZI = "strimzi";
    private Long producerByteRate;
    private Long consumerByteRate;
    private Long minAvailableBytesPerVolume;
    private Double minAvailableRatioPerVolume;
    private List<String> excludedPrincipals;

    @Override
    @Description(value="Must be `strimzi`")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getType() {
        return TYPE_STRIMZI;
    }

    @Description(value="A per-broker byte-rate quota for clients producing to a broker, independent of their number. If clients produce at maximum speed, the quota is shared equally between all non-excluded producers. Otherwise, the quota is divided based on each client's production rate.")
    @Minimum(value=0)
    public Long getProducerByteRate() {
        return this.producerByteRate;
    }

    public void setProducerByteRate(Long producerByteRate) {
        this.producerByteRate = producerByteRate;
    }

    @Description(value="A per-broker byte-rate quota for clients consuming from a broker, independent of their number. If clients consume at maximum speed, the quota is shared equally between all non-excluded consumers. Otherwise, the quota is divided based on each client's consumption rate.")
    @Minimum(value=0)
    public Long getConsumerByteRate() {
        return this.consumerByteRate;
    }

    public void setConsumerByteRate(Long consumerByteRate) {
        this.consumerByteRate = consumerByteRate;
    }

    @Description(value="Stop message production if the available size (in bytes) of the storage is lower than or equal to this specified value. This condition is mutually exclusive with `minAvailableRatioPerVolume`.")
    @Minimum(value=0)
    public Long getMinAvailableBytesPerVolume() {
        return this.minAvailableBytesPerVolume;
    }

    public void setMinAvailableBytesPerVolume(Long minAvailableBytesPerVolume) {
        this.minAvailableBytesPerVolume = minAvailableBytesPerVolume;
    }

    @Description(value="Stop message production if the percentage of available storage space falls below or equals the specified ratio (set as a decimal representing a percentage). This condition is mutually exclusive with `minAvailableBytesPerVolume`.")
    @Minimum(value=0)
    @Maximum(value=1)
    public Double getMinAvailableRatioPerVolume() {
        return this.minAvailableRatioPerVolume;
    }

    public void setMinAvailableRatioPerVolume(Double minAvailableRatioPerVolume) {
        this.minAvailableRatioPerVolume = minAvailableRatioPerVolume;
    }

    @Description(value="List of principals that are excluded from the quota. The principals have to be prefixed with `User:`, for example `User:my-user;User:CN=my-other-user`.")
    public List<String> getExcludedPrincipals() {
        return this.excludedPrincipals;
    }

    public void setExcludedPrincipals(List<String> excludedPrincipals) {
        this.excludedPrincipals = excludedPrincipals;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QuotasPluginStrimzi)) {
            return false;
        }
        QuotasPluginStrimzi other = (QuotasPluginStrimzi)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$producerByteRate = this.getProducerByteRate();
        Long other$producerByteRate = other.getProducerByteRate();
        if (this$producerByteRate == null ? other$producerByteRate != null : !((Object)this$producerByteRate).equals(other$producerByteRate)) {
            return false;
        }
        Long this$consumerByteRate = this.getConsumerByteRate();
        Long other$consumerByteRate = other.getConsumerByteRate();
        if (this$consumerByteRate == null ? other$consumerByteRate != null : !((Object)this$consumerByteRate).equals(other$consumerByteRate)) {
            return false;
        }
        Long this$minAvailableBytesPerVolume = this.getMinAvailableBytesPerVolume();
        Long other$minAvailableBytesPerVolume = other.getMinAvailableBytesPerVolume();
        if (this$minAvailableBytesPerVolume == null ? other$minAvailableBytesPerVolume != null : !((Object)this$minAvailableBytesPerVolume).equals(other$minAvailableBytesPerVolume)) {
            return false;
        }
        Double this$minAvailableRatioPerVolume = this.getMinAvailableRatioPerVolume();
        Double other$minAvailableRatioPerVolume = other.getMinAvailableRatioPerVolume();
        if (this$minAvailableRatioPerVolume == null ? other$minAvailableRatioPerVolume != null : !((Object)this$minAvailableRatioPerVolume).equals(other$minAvailableRatioPerVolume)) {
            return false;
        }
        List<String> this$excludedPrincipals = this.getExcludedPrincipals();
        List<String> other$excludedPrincipals = other.getExcludedPrincipals();
        return !(this$excludedPrincipals == null ? other$excludedPrincipals != null : !((Object)this$excludedPrincipals).equals(other$excludedPrincipals));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof QuotasPluginStrimzi;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $producerByteRate = this.getProducerByteRate();
        result = result * 59 + ($producerByteRate == null ? 43 : ((Object)$producerByteRate).hashCode());
        Long $consumerByteRate = this.getConsumerByteRate();
        result = result * 59 + ($consumerByteRate == null ? 43 : ((Object)$consumerByteRate).hashCode());
        Long $minAvailableBytesPerVolume = this.getMinAvailableBytesPerVolume();
        result = result * 59 + ($minAvailableBytesPerVolume == null ? 43 : ((Object)$minAvailableBytesPerVolume).hashCode());
        Double $minAvailableRatioPerVolume = this.getMinAvailableRatioPerVolume();
        result = result * 59 + ($minAvailableRatioPerVolume == null ? 43 : ((Object)$minAvailableRatioPerVolume).hashCode());
        List<String> $excludedPrincipals = this.getExcludedPrincipals();
        result = result * 59 + ($excludedPrincipals == null ? 43 : ((Object)$excludedPrincipals).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "QuotasPluginStrimzi(super=" + super.toString() + ", producerByteRate=" + this.getProducerByteRate() + ", consumerByteRate=" + this.getConsumerByteRate() + ", minAvailableBytesPerVolume=" + this.getMinAvailableBytesPerVolume() + ", minAvailableRatioPerVolume=" + this.getMinAvailableRatioPerVolume() + ", excludedPrincipals=" + String.valueOf(this.getExcludedPrincipals()) + ")";
    }
}

