/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.kafka.quotas;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.kafka.quotas.QuotasPlugin;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.Minimum;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonPropertyOrder(value={"type", "producerByteRate", "consumerByteRate", "requestPercentage", "controllerMutationRate"})
public class QuotasPluginKafka
extends QuotasPlugin {
    private static final long serialVersionUID = 1L;
    public static final String TYPE_KAFKA = "kafka";
    private Long producerByteRate;
    private Long consumerByteRate;
    private Integer requestPercentage;
    private Double controllerMutationRate;

    @Override
    @Description(value="Must be `kafka`")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getType() {
        return TYPE_KAFKA;
    }

    @Description(value="The default client quota on the maximum bytes per-second that each client can publish to each broker before it is throttled. Applied on a per-broker basis.")
    @Minimum(value=0)
    public Long getProducerByteRate() {
        return this.producerByteRate;
    }

    public void setProducerByteRate(Long producerByteRate) {
        this.producerByteRate = producerByteRate;
    }

    @Description(value="The default client quota on the maximum bytes per-second that each client can fetch from each broker before it is throttled. Applied on a per-broker basis.")
    @Minimum(value=0)
    public Long getConsumerByteRate() {
        return this.consumerByteRate;
    }

    public void setConsumerByteRate(Long consumerByteRate) {
        this.consumerByteRate = consumerByteRate;
    }

    @Description(value="The default client quota limits the maximum CPU utilization of each client as a percentage of the network and I/O threads of each broker. Applied on a per-broker basis.")
    @Minimum(value=0)
    public Integer getRequestPercentage() {
        return this.requestPercentage;
    }

    public void setRequestPercentage(Integer requestPercentage) {
        this.requestPercentage = requestPercentage;
    }

    @Description(value="The default client quota on the rate at which mutations are accepted per second for create topic requests, create partition requests, and delete topic requests, defined for each broker. The mutations rate is measured by the number of partitions created or deleted. Applied on a per-broker basis.")
    @Minimum(value=0)
    public Double getControllerMutationRate() {
        return this.controllerMutationRate;
    }

    public void setControllerMutationRate(Double controllerMutationRate) {
        this.controllerMutationRate = controllerMutationRate;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QuotasPluginKafka)) {
            return false;
        }
        QuotasPluginKafka other = (QuotasPluginKafka)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$producerByteRate = this.getProducerByteRate();
        Long other$producerByteRate = other.getProducerByteRate();
        if (this$producerByteRate == null ? other$producerByteRate != null : !((Object)this$producerByteRate).equals(other$producerByteRate)) {
            return false;
        }
        Long this$consumerByteRate = this.getConsumerByteRate();
        Long other$consumerByteRate = other.getConsumerByteRate();
        if (this$consumerByteRate == null ? other$consumerByteRate != null : !((Object)this$consumerByteRate).equals(other$consumerByteRate)) {
            return false;
        }
        Integer this$requestPercentage = this.getRequestPercentage();
        Integer other$requestPercentage = other.getRequestPercentage();
        if (this$requestPercentage == null ? other$requestPercentage != null : !((Object)this$requestPercentage).equals(other$requestPercentage)) {
            return false;
        }
        Double this$controllerMutationRate = this.getControllerMutationRate();
        Double other$controllerMutationRate = other.getControllerMutationRate();
        return !(this$controllerMutationRate == null ? other$controllerMutationRate != null : !((Object)this$controllerMutationRate).equals(other$controllerMutationRate));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof QuotasPluginKafka;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $producerByteRate = this.getProducerByteRate();
        result = result * 59 + ($producerByteRate == null ? 43 : ((Object)$producerByteRate).hashCode());
        Long $consumerByteRate = this.getConsumerByteRate();
        result = result * 59 + ($consumerByteRate == null ? 43 : ((Object)$consumerByteRate).hashCode());
        Integer $requestPercentage = this.getRequestPercentage();
        result = result * 59 + ($requestPercentage == null ? 43 : ((Object)$requestPercentage).hashCode());
        Double $controllerMutationRate = this.getControllerMutationRate();
        result = result * 59 + ($controllerMutationRate == null ? 43 : ((Object)$controllerMutationRate).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "QuotasPluginKafka(super=" + super.toString() + ", producerByteRate=" + this.getProducerByteRate() + ", consumerByteRate=" + this.getConsumerByteRate() + ", requestPercentage=" + this.getRequestPercentage() + ", controllerMutationRate=" + this.getControllerMutationRate() + ")";
    }
}

