/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.kafka.listener;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.annotations.DeprecatedProperty;
import io.strimzi.api.kafka.model.common.UnknownPropertyPreserving;
import io.strimzi.api.kafka.model.kafka.listener.ListenerAddress;
import io.strimzi.crdgenerator.annotations.Description;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "name", "addresses", "bootstrapServers", "certificates"})
public class ListenerStatus
implements UnknownPropertyPreserving {
    private String type;
    private String name;
    private List<ListenerAddress> addresses;
    private String bootstrapServers;
    private List<String> certificates;
    private Map<String, Object> additionalProperties;

    @Deprecated
    @DeprecatedProperty(description="The `type` property is not used anymore. Use the `name` property with the same value.")
    @Description(value="The name of the listener.")
    public String getType() {
        return this.type;
    }

    @Deprecated
    public void setType(String type) {
        this.type = type;
    }

    @Description(value="The name of the listener.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Description(value="A list of the addresses for this listener.")
    public List<ListenerAddress> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<ListenerAddress> addresses) {
        this.addresses = addresses;
        this.bootstrapServers = addresses == null || addresses.isEmpty() ? null : addresses.stream().map(a -> a.getHost() + ":" + a.getPort()).distinct().sorted().collect(Collectors.joining(","));
    }

    @Description(value="A comma-separated list of `host:port` pairs for connecting to the Kafka cluster using this listener.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    @Description(value="A list of TLS certificates which can be used to verify the identity of the server when connecting to the given listener. Set only for `tls` and `external` listeners.")
    public List<String> getCertificates() {
        return this.certificates;
    }

    public void setCertificates(List<String> certificates) {
        this.certificates = certificates;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties != null ? this.additionalProperties : Map.of();
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>(2);
        }
        this.additionalProperties.put(name, value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListenerStatus)) {
            return false;
        }
        ListenerStatus other = (ListenerStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<ListenerAddress> this$addresses = this.getAddresses();
        List<ListenerAddress> other$addresses = other.getAddresses();
        if (this$addresses == null ? other$addresses != null : !((Object)this$addresses).equals(other$addresses)) {
            return false;
        }
        String this$bootstrapServers = this.getBootstrapServers();
        String other$bootstrapServers = other.getBootstrapServers();
        if (this$bootstrapServers == null ? other$bootstrapServers != null : !this$bootstrapServers.equals(other$bootstrapServers)) {
            return false;
        }
        List<String> this$certificates = this.getCertificates();
        List<String> other$certificates = other.getCertificates();
        if (this$certificates == null ? other$certificates != null : !((Object)this$certificates).equals(other$certificates)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListenerStatus;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<ListenerAddress> $addresses = this.getAddresses();
        result = result * 59 + ($addresses == null ? 43 : ((Object)$addresses).hashCode());
        String $bootstrapServers = this.getBootstrapServers();
        result = result * 59 + ($bootstrapServers == null ? 43 : $bootstrapServers.hashCode());
        List<String> $certificates = this.getCertificates();
        result = result * 59 + ($certificates == null ? 43 : ((Object)$certificates).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }

    public String toString() {
        return "ListenerStatus(type=" + this.getType() + ", name=" + this.getName() + ", addresses=" + String.valueOf(this.getAddresses()) + ", bootstrapServers=" + this.getBootstrapServers() + ", certificates=" + String.valueOf(this.getCertificates()) + ", additionalProperties=" + String.valueOf(this.getAdditionalProperties()) + ")";
    }
}

