/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.kafka.listener;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.common.CertAndKeySecretSource;
import io.strimzi.api.kafka.model.common.CertAndKeySecretSourceBuilder;
import io.strimzi.api.kafka.model.common.CertAndKeySecretSourceFluent;
import io.strimzi.api.kafka.model.common.template.ExternalTrafficPolicy;
import io.strimzi.api.kafka.model.common.template.IpFamily;
import io.strimzi.api.kafka.model.common.template.IpFamilyPolicy;
import io.strimzi.api.kafka.model.kafka.listener.GenericKafkaListenerConfiguration;
import io.strimzi.api.kafka.model.kafka.listener.GenericKafkaListenerConfigurationBootstrap;
import io.strimzi.api.kafka.model.kafka.listener.GenericKafkaListenerConfigurationBootstrapBuilder;
import io.strimzi.api.kafka.model.kafka.listener.GenericKafkaListenerConfigurationBootstrapFluent;
import io.strimzi.api.kafka.model.kafka.listener.GenericKafkaListenerConfigurationBroker;
import io.strimzi.api.kafka.model.kafka.listener.GenericKafkaListenerConfigurationBrokerBuilder;
import io.strimzi.api.kafka.model.kafka.listener.GenericKafkaListenerConfigurationBrokerFluent;
import io.strimzi.api.kafka.model.kafka.listener.NodeAddressType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class GenericKafkaListenerConfigurationFluent<A extends GenericKafkaListenerConfigurationFluent<A>>
extends BaseFluent<A> {
    private CertAndKeySecretSourceBuilder brokerCertChainAndKey;
    private String controllerClass;
    private NodeAddressType preferredNodePortAddressType;
    private ExternalTrafficPolicy externalTrafficPolicy;
    private List<String> loadBalancerSourceRanges;
    private List<String> finalizers;
    private Boolean useServiceDnsDomain;
    private GenericKafkaListenerConfigurationBootstrapBuilder bootstrap;
    private ArrayList<GenericKafkaListenerConfigurationBrokerBuilder> brokers;
    private Integer maxConnections;
    private Integer maxConnectionCreationRate;
    private IpFamilyPolicy ipFamilyPolicy;
    private List<IpFamily> ipFamilies;
    private Boolean createBootstrapService;
    private Boolean publishNotReadyAddresses;
    private String hostTemplate;
    private String advertisedHostTemplate;
    private Boolean allocateLoadBalancerNodePorts;

    public GenericKafkaListenerConfigurationFluent() {
    }

    public GenericKafkaListenerConfigurationFluent(GenericKafkaListenerConfiguration instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(GenericKafkaListenerConfiguration instance) {
        GenericKafkaListenerConfiguration genericKafkaListenerConfiguration = instance = instance != null ? instance : new GenericKafkaListenerConfiguration();
        if (instance != null) {
            this.withBrokerCertChainAndKey(instance.getBrokerCertChainAndKey());
            this.withControllerClass(instance.getControllerClass());
            this.withPreferredNodePortAddressType(instance.getPreferredNodePortAddressType());
            this.withExternalTrafficPolicy(instance.getExternalTrafficPolicy());
            this.withLoadBalancerSourceRanges(instance.getLoadBalancerSourceRanges());
            this.withFinalizers(instance.getFinalizers());
            this.withUseServiceDnsDomain(instance.getUseServiceDnsDomain());
            this.withBootstrap(instance.getBootstrap());
            this.withBrokers(instance.getBrokers());
            this.withMaxConnections(instance.getMaxConnections());
            this.withMaxConnectionCreationRate(instance.getMaxConnectionCreationRate());
            this.withIpFamilyPolicy(instance.getIpFamilyPolicy());
            this.withIpFamilies(instance.getIpFamilies());
            this.withCreateBootstrapService(instance.getCreateBootstrapService());
            this.withPublishNotReadyAddresses(instance.getPublishNotReadyAddresses());
            this.withHostTemplate(instance.getHostTemplate());
            this.withAdvertisedHostTemplate(instance.getAdvertisedHostTemplate());
            this.withAllocateLoadBalancerNodePorts(instance.getAllocateLoadBalancerNodePorts());
        }
    }

    public CertAndKeySecretSource buildBrokerCertChainAndKey() {
        return this.brokerCertChainAndKey != null ? this.brokerCertChainAndKey.build() : null;
    }

    public A withBrokerCertChainAndKey(CertAndKeySecretSource brokerCertChainAndKey) {
        this._visitables.remove((Object)"brokerCertChainAndKey");
        if (brokerCertChainAndKey != null) {
            this.brokerCertChainAndKey = new CertAndKeySecretSourceBuilder(brokerCertChainAndKey);
            this._visitables.get((Object)"brokerCertChainAndKey").add(this.brokerCertChainAndKey);
        } else {
            this.brokerCertChainAndKey = null;
            this._visitables.get((Object)"brokerCertChainAndKey").remove((Object)this.brokerCertChainAndKey);
        }
        return (A)((Object)this);
    }

    public boolean hasBrokerCertChainAndKey() {
        return this.brokerCertChainAndKey != null;
    }

    public BrokerCertChainAndKeyNested<A> withNewBrokerCertChainAndKey() {
        return new BrokerCertChainAndKeyNested(null);
    }

    public BrokerCertChainAndKeyNested<A> withNewBrokerCertChainAndKeyLike(CertAndKeySecretSource item) {
        return new BrokerCertChainAndKeyNested(item);
    }

    public BrokerCertChainAndKeyNested<A> editBrokerCertChainAndKey() {
        return this.withNewBrokerCertChainAndKeyLike(Optional.ofNullable(this.buildBrokerCertChainAndKey()).orElse(null));
    }

    public BrokerCertChainAndKeyNested<A> editOrNewBrokerCertChainAndKey() {
        return this.withNewBrokerCertChainAndKeyLike(Optional.ofNullable(this.buildBrokerCertChainAndKey()).orElse(new CertAndKeySecretSourceBuilder().build()));
    }

    public BrokerCertChainAndKeyNested<A> editOrNewBrokerCertChainAndKeyLike(CertAndKeySecretSource item) {
        return this.withNewBrokerCertChainAndKeyLike(Optional.ofNullable(this.buildBrokerCertChainAndKey()).orElse(item));
    }

    public String getControllerClass() {
        return this.controllerClass;
    }

    public A withControllerClass(String controllerClass) {
        this.controllerClass = controllerClass;
        return (A)((Object)this);
    }

    public boolean hasControllerClass() {
        return this.controllerClass != null;
    }

    public NodeAddressType getPreferredNodePortAddressType() {
        return this.preferredNodePortAddressType;
    }

    public A withPreferredNodePortAddressType(NodeAddressType preferredNodePortAddressType) {
        this.preferredNodePortAddressType = preferredNodePortAddressType;
        return (A)((Object)this);
    }

    public boolean hasPreferredNodePortAddressType() {
        return this.preferredNodePortAddressType != null;
    }

    public ExternalTrafficPolicy getExternalTrafficPolicy() {
        return this.externalTrafficPolicy;
    }

    public A withExternalTrafficPolicy(ExternalTrafficPolicy externalTrafficPolicy) {
        this.externalTrafficPolicy = externalTrafficPolicy;
        return (A)((Object)this);
    }

    public boolean hasExternalTrafficPolicy() {
        return this.externalTrafficPolicy != null;
    }

    public A addToLoadBalancerSourceRanges(int index, String item) {
        if (this.loadBalancerSourceRanges == null) {
            this.loadBalancerSourceRanges = new ArrayList<String>();
        }
        this.loadBalancerSourceRanges.add(index, item);
        return (A)((Object)this);
    }

    public A setToLoadBalancerSourceRanges(int index, String item) {
        if (this.loadBalancerSourceRanges == null) {
            this.loadBalancerSourceRanges = new ArrayList<String>();
        }
        this.loadBalancerSourceRanges.set(index, item);
        return (A)((Object)this);
    }

    public A addToLoadBalancerSourceRanges(String ... items) {
        if (this.loadBalancerSourceRanges == null) {
            this.loadBalancerSourceRanges = new ArrayList<String>();
        }
        for (String item : items) {
            this.loadBalancerSourceRanges.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToLoadBalancerSourceRanges(Collection<String> items) {
        if (this.loadBalancerSourceRanges == null) {
            this.loadBalancerSourceRanges = new ArrayList<String>();
        }
        for (String item : items) {
            this.loadBalancerSourceRanges.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromLoadBalancerSourceRanges(String ... items) {
        if (this.loadBalancerSourceRanges == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.loadBalancerSourceRanges.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromLoadBalancerSourceRanges(Collection<String> items) {
        if (this.loadBalancerSourceRanges == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.loadBalancerSourceRanges.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getLoadBalancerSourceRanges() {
        return this.loadBalancerSourceRanges;
    }

    public String getLoadBalancerSourceRange(int index) {
        return this.loadBalancerSourceRanges.get(index);
    }

    public String getFirstLoadBalancerSourceRange() {
        return this.loadBalancerSourceRanges.get(0);
    }

    public String getLastLoadBalancerSourceRange() {
        return this.loadBalancerSourceRanges.get(this.loadBalancerSourceRanges.size() - 1);
    }

    public String getMatchingLoadBalancerSourceRange(Predicate<String> predicate) {
        for (String item : this.loadBalancerSourceRanges) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingLoadBalancerSourceRange(Predicate<String> predicate) {
        for (String item : this.loadBalancerSourceRanges) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withLoadBalancerSourceRanges(List<String> loadBalancerSourceRanges) {
        if (loadBalancerSourceRanges != null) {
            this.loadBalancerSourceRanges = new ArrayList<String>();
            for (String item : loadBalancerSourceRanges) {
                this.addToLoadBalancerSourceRanges(item);
            }
        } else {
            this.loadBalancerSourceRanges = null;
        }
        return (A)((Object)this);
    }

    public A withLoadBalancerSourceRanges(String ... loadBalancerSourceRanges) {
        if (this.loadBalancerSourceRanges != null) {
            this.loadBalancerSourceRanges.clear();
            this._visitables.remove((Object)"loadBalancerSourceRanges");
        }
        if (loadBalancerSourceRanges != null) {
            for (String item : loadBalancerSourceRanges) {
                this.addToLoadBalancerSourceRanges(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasLoadBalancerSourceRanges() {
        return this.loadBalancerSourceRanges != null && !this.loadBalancerSourceRanges.isEmpty();
    }

    public A addToFinalizers(int index, String item) {
        if (this.finalizers == null) {
            this.finalizers = new ArrayList<String>();
        }
        this.finalizers.add(index, item);
        return (A)((Object)this);
    }

    public A setToFinalizers(int index, String item) {
        if (this.finalizers == null) {
            this.finalizers = new ArrayList<String>();
        }
        this.finalizers.set(index, item);
        return (A)((Object)this);
    }

    public A addToFinalizers(String ... items) {
        if (this.finalizers == null) {
            this.finalizers = new ArrayList<String>();
        }
        for (String item : items) {
            this.finalizers.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToFinalizers(Collection<String> items) {
        if (this.finalizers == null) {
            this.finalizers = new ArrayList<String>();
        }
        for (String item : items) {
            this.finalizers.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromFinalizers(String ... items) {
        if (this.finalizers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.finalizers.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromFinalizers(Collection<String> items) {
        if (this.finalizers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.finalizers.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getFinalizers() {
        return this.finalizers;
    }

    public String getFinalizer(int index) {
        return this.finalizers.get(index);
    }

    public String getFirstFinalizer() {
        return this.finalizers.get(0);
    }

    public String getLastFinalizer() {
        return this.finalizers.get(this.finalizers.size() - 1);
    }

    public String getMatchingFinalizer(Predicate<String> predicate) {
        for (String item : this.finalizers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingFinalizer(Predicate<String> predicate) {
        for (String item : this.finalizers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withFinalizers(List<String> finalizers) {
        if (finalizers != null) {
            this.finalizers = new ArrayList<String>();
            for (String item : finalizers) {
                this.addToFinalizers(item);
            }
        } else {
            this.finalizers = null;
        }
        return (A)((Object)this);
    }

    public A withFinalizers(String ... finalizers) {
        if (this.finalizers != null) {
            this.finalizers.clear();
            this._visitables.remove((Object)"finalizers");
        }
        if (finalizers != null) {
            for (String item : finalizers) {
                this.addToFinalizers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasFinalizers() {
        return this.finalizers != null && !this.finalizers.isEmpty();
    }

    public Boolean getUseServiceDnsDomain() {
        return this.useServiceDnsDomain;
    }

    public A withUseServiceDnsDomain(Boolean useServiceDnsDomain) {
        this.useServiceDnsDomain = useServiceDnsDomain;
        return (A)((Object)this);
    }

    public boolean hasUseServiceDnsDomain() {
        return this.useServiceDnsDomain != null;
    }

    public GenericKafkaListenerConfigurationBootstrap buildBootstrap() {
        return this.bootstrap != null ? this.bootstrap.build() : null;
    }

    public A withBootstrap(GenericKafkaListenerConfigurationBootstrap bootstrap) {
        this._visitables.remove((Object)"bootstrap");
        if (bootstrap != null) {
            this.bootstrap = new GenericKafkaListenerConfigurationBootstrapBuilder(bootstrap);
            this._visitables.get((Object)"bootstrap").add(this.bootstrap);
        } else {
            this.bootstrap = null;
            this._visitables.get((Object)"bootstrap").remove((Object)this.bootstrap);
        }
        return (A)((Object)this);
    }

    public boolean hasBootstrap() {
        return this.bootstrap != null;
    }

    public BootstrapNested<A> withNewBootstrap() {
        return new BootstrapNested(null);
    }

    public BootstrapNested<A> withNewBootstrapLike(GenericKafkaListenerConfigurationBootstrap item) {
        return new BootstrapNested(item);
    }

    public BootstrapNested<A> editBootstrap() {
        return this.withNewBootstrapLike(Optional.ofNullable(this.buildBootstrap()).orElse(null));
    }

    public BootstrapNested<A> editOrNewBootstrap() {
        return this.withNewBootstrapLike(Optional.ofNullable(this.buildBootstrap()).orElse(new GenericKafkaListenerConfigurationBootstrapBuilder().build()));
    }

    public BootstrapNested<A> editOrNewBootstrapLike(GenericKafkaListenerConfigurationBootstrap item) {
        return this.withNewBootstrapLike(Optional.ofNullable(this.buildBootstrap()).orElse(item));
    }

    public A addToBrokers(int index, GenericKafkaListenerConfigurationBroker item) {
        if (this.brokers == null) {
            this.brokers = new ArrayList();
        }
        GenericKafkaListenerConfigurationBrokerBuilder builder = new GenericKafkaListenerConfigurationBrokerBuilder(item);
        if (index < 0 || index >= this.brokers.size()) {
            this._visitables.get((Object)"brokers").add(builder);
            this.brokers.add(builder);
        } else {
            this._visitables.get((Object)"brokers").add(index, builder);
            this.brokers.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToBrokers(int index, GenericKafkaListenerConfigurationBroker item) {
        if (this.brokers == null) {
            this.brokers = new ArrayList();
        }
        GenericKafkaListenerConfigurationBrokerBuilder builder = new GenericKafkaListenerConfigurationBrokerBuilder(item);
        if (index < 0 || index >= this.brokers.size()) {
            this._visitables.get((Object)"brokers").add(builder);
            this.brokers.add(builder);
        } else {
            this._visitables.get((Object)"brokers").set(index, builder);
            this.brokers.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToBrokers(GenericKafkaListenerConfigurationBroker ... items) {
        if (this.brokers == null) {
            this.brokers = new ArrayList();
        }
        for (GenericKafkaListenerConfigurationBroker item : items) {
            GenericKafkaListenerConfigurationBrokerBuilder builder = new GenericKafkaListenerConfigurationBrokerBuilder(item);
            this._visitables.get((Object)"brokers").add(builder);
            this.brokers.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToBrokers(Collection<GenericKafkaListenerConfigurationBroker> items) {
        if (this.brokers == null) {
            this.brokers = new ArrayList();
        }
        for (GenericKafkaListenerConfigurationBroker item : items) {
            GenericKafkaListenerConfigurationBrokerBuilder builder = new GenericKafkaListenerConfigurationBrokerBuilder(item);
            this._visitables.get((Object)"brokers").add(builder);
            this.brokers.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromBrokers(GenericKafkaListenerConfigurationBroker ... items) {
        if (this.brokers == null) {
            return (A)((Object)this);
        }
        for (GenericKafkaListenerConfigurationBroker item : items) {
            GenericKafkaListenerConfigurationBrokerBuilder builder = new GenericKafkaListenerConfigurationBrokerBuilder(item);
            this._visitables.get((Object)"brokers").remove((Object)builder);
            this.brokers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromBrokers(Collection<GenericKafkaListenerConfigurationBroker> items) {
        if (this.brokers == null) {
            return (A)((Object)this);
        }
        for (GenericKafkaListenerConfigurationBroker item : items) {
            GenericKafkaListenerConfigurationBrokerBuilder builder = new GenericKafkaListenerConfigurationBrokerBuilder(item);
            this._visitables.get((Object)"brokers").remove((Object)builder);
            this.brokers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromBrokers(Predicate<GenericKafkaListenerConfigurationBrokerBuilder> predicate) {
        if (this.brokers == null) {
            return (A)((Object)this);
        }
        Iterator<GenericKafkaListenerConfigurationBrokerBuilder> each = this.brokers.iterator();
        List visitables = this._visitables.get((Object)"brokers");
        while (each.hasNext()) {
            GenericKafkaListenerConfigurationBrokerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<GenericKafkaListenerConfigurationBroker> buildBrokers() {
        return this.brokers != null ? GenericKafkaListenerConfigurationFluent.build(this.brokers) : null;
    }

    public GenericKafkaListenerConfigurationBroker buildBroker(int index) {
        return this.brokers.get(index).build();
    }

    public GenericKafkaListenerConfigurationBroker buildFirstBroker() {
        return this.brokers.get(0).build();
    }

    public GenericKafkaListenerConfigurationBroker buildLastBroker() {
        return this.brokers.get(this.brokers.size() - 1).build();
    }

    public GenericKafkaListenerConfigurationBroker buildMatchingBroker(Predicate<GenericKafkaListenerConfigurationBrokerBuilder> predicate) {
        for (GenericKafkaListenerConfigurationBrokerBuilder item : this.brokers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingBroker(Predicate<GenericKafkaListenerConfigurationBrokerBuilder> predicate) {
        for (GenericKafkaListenerConfigurationBrokerBuilder item : this.brokers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withBrokers(List<GenericKafkaListenerConfigurationBroker> brokers) {
        if (this.brokers != null) {
            this._visitables.get((Object)"brokers").clear();
        }
        if (brokers != null) {
            this.brokers = new ArrayList();
            for (GenericKafkaListenerConfigurationBroker item : brokers) {
                this.addToBrokers(item);
            }
        } else {
            this.brokers = null;
        }
        return (A)((Object)this);
    }

    public A withBrokers(GenericKafkaListenerConfigurationBroker ... brokers) {
        if (this.brokers != null) {
            this.brokers.clear();
            this._visitables.remove((Object)"brokers");
        }
        if (brokers != null) {
            for (GenericKafkaListenerConfigurationBroker item : brokers) {
                this.addToBrokers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasBrokers() {
        return this.brokers != null && !this.brokers.isEmpty();
    }

    public BrokersNested<A> addNewBroker() {
        return new BrokersNested(-1, null);
    }

    public BrokersNested<A> addNewBrokerLike(GenericKafkaListenerConfigurationBroker item) {
        return new BrokersNested(-1, item);
    }

    public BrokersNested<A> setNewBrokerLike(int index, GenericKafkaListenerConfigurationBroker item) {
        return new BrokersNested(index, item);
    }

    public BrokersNested<A> editBroker(int index) {
        if (this.brokers.size() <= index) {
            throw new RuntimeException("Can't edit brokers. Index exceeds size.");
        }
        return this.setNewBrokerLike(index, this.buildBroker(index));
    }

    public BrokersNested<A> editFirstBroker() {
        if (this.brokers.size() == 0) {
            throw new RuntimeException("Can't edit first brokers. The list is empty.");
        }
        return this.setNewBrokerLike(0, this.buildBroker(0));
    }

    public BrokersNested<A> editLastBroker() {
        int index = this.brokers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last brokers. The list is empty.");
        }
        return this.setNewBrokerLike(index, this.buildBroker(index));
    }

    public BrokersNested<A> editMatchingBroker(Predicate<GenericKafkaListenerConfigurationBrokerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.brokers.size(); ++i) {
            if (!predicate.test(this.brokers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching brokers. No match found.");
        }
        return this.setNewBrokerLike(index, this.buildBroker(index));
    }

    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    public A withMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
        return (A)((Object)this);
    }

    public boolean hasMaxConnections() {
        return this.maxConnections != null;
    }

    public Integer getMaxConnectionCreationRate() {
        return this.maxConnectionCreationRate;
    }

    public A withMaxConnectionCreationRate(Integer maxConnectionCreationRate) {
        this.maxConnectionCreationRate = maxConnectionCreationRate;
        return (A)((Object)this);
    }

    public boolean hasMaxConnectionCreationRate() {
        return this.maxConnectionCreationRate != null;
    }

    public IpFamilyPolicy getIpFamilyPolicy() {
        return this.ipFamilyPolicy;
    }

    public A withIpFamilyPolicy(IpFamilyPolicy ipFamilyPolicy) {
        this.ipFamilyPolicy = ipFamilyPolicy;
        return (A)((Object)this);
    }

    public boolean hasIpFamilyPolicy() {
        return this.ipFamilyPolicy != null;
    }

    public A addToIpFamilies(int index, IpFamily item) {
        if (this.ipFamilies == null) {
            this.ipFamilies = new ArrayList<IpFamily>();
        }
        this.ipFamilies.add(index, item);
        return (A)((Object)this);
    }

    public A setToIpFamilies(int index, IpFamily item) {
        if (this.ipFamilies == null) {
            this.ipFamilies = new ArrayList<IpFamily>();
        }
        this.ipFamilies.set(index, item);
        return (A)((Object)this);
    }

    public A addToIpFamilies(IpFamily ... items) {
        if (this.ipFamilies == null) {
            this.ipFamilies = new ArrayList<IpFamily>();
        }
        for (IpFamily item : items) {
            this.ipFamilies.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToIpFamilies(Collection<IpFamily> items) {
        if (this.ipFamilies == null) {
            this.ipFamilies = new ArrayList<IpFamily>();
        }
        for (IpFamily item : items) {
            this.ipFamilies.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromIpFamilies(IpFamily ... items) {
        if (this.ipFamilies == null) {
            return (A)((Object)this);
        }
        for (IpFamily item : items) {
            this.ipFamilies.remove((Object)item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromIpFamilies(Collection<IpFamily> items) {
        if (this.ipFamilies == null) {
            return (A)((Object)this);
        }
        for (IpFamily item : items) {
            this.ipFamilies.remove((Object)item);
        }
        return (A)((Object)this);
    }

    public List<IpFamily> getIpFamilies() {
        return this.ipFamilies;
    }

    public IpFamily getIpFamily(int index) {
        return this.ipFamilies.get(index);
    }

    public IpFamily getFirstIpFamily() {
        return this.ipFamilies.get(0);
    }

    public IpFamily getLastIpFamily() {
        return this.ipFamilies.get(this.ipFamilies.size() - 1);
    }

    public IpFamily getMatchingIpFamily(Predicate<IpFamily> predicate) {
        for (IpFamily item : this.ipFamilies) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingIpFamily(Predicate<IpFamily> predicate) {
        for (IpFamily item : this.ipFamilies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withIpFamilies(List<IpFamily> ipFamilies) {
        if (ipFamilies != null) {
            this.ipFamilies = new ArrayList<IpFamily>();
            for (IpFamily item : ipFamilies) {
                this.addToIpFamilies(item);
            }
        } else {
            this.ipFamilies = null;
        }
        return (A)((Object)this);
    }

    public A withIpFamilies(IpFamily ... ipFamilies) {
        if (this.ipFamilies != null) {
            this.ipFamilies.clear();
            this._visitables.remove((Object)"ipFamilies");
        }
        if (ipFamilies != null) {
            for (IpFamily item : ipFamilies) {
                this.addToIpFamilies(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasIpFamilies() {
        return this.ipFamilies != null && !this.ipFamilies.isEmpty();
    }

    public Boolean getCreateBootstrapService() {
        return this.createBootstrapService;
    }

    public A withCreateBootstrapService(Boolean createBootstrapService) {
        this.createBootstrapService = createBootstrapService;
        return (A)((Object)this);
    }

    public boolean hasCreateBootstrapService() {
        return this.createBootstrapService != null;
    }

    public Boolean getPublishNotReadyAddresses() {
        return this.publishNotReadyAddresses;
    }

    public A withPublishNotReadyAddresses(Boolean publishNotReadyAddresses) {
        this.publishNotReadyAddresses = publishNotReadyAddresses;
        return (A)((Object)this);
    }

    public boolean hasPublishNotReadyAddresses() {
        return this.publishNotReadyAddresses != null;
    }

    public String getHostTemplate() {
        return this.hostTemplate;
    }

    public A withHostTemplate(String hostTemplate) {
        this.hostTemplate = hostTemplate;
        return (A)((Object)this);
    }

    public boolean hasHostTemplate() {
        return this.hostTemplate != null;
    }

    public String getAdvertisedHostTemplate() {
        return this.advertisedHostTemplate;
    }

    public A withAdvertisedHostTemplate(String advertisedHostTemplate) {
        this.advertisedHostTemplate = advertisedHostTemplate;
        return (A)((Object)this);
    }

    public boolean hasAdvertisedHostTemplate() {
        return this.advertisedHostTemplate != null;
    }

    public Boolean getAllocateLoadBalancerNodePorts() {
        return this.allocateLoadBalancerNodePorts;
    }

    public A withAllocateLoadBalancerNodePorts(Boolean allocateLoadBalancerNodePorts) {
        this.allocateLoadBalancerNodePorts = allocateLoadBalancerNodePorts;
        return (A)((Object)this);
    }

    public boolean hasAllocateLoadBalancerNodePorts() {
        return this.allocateLoadBalancerNodePorts != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GenericKafkaListenerConfigurationFluent that = (GenericKafkaListenerConfigurationFluent)((Object)o);
        if (!Objects.equals((Object)this.brokerCertChainAndKey, (Object)that.brokerCertChainAndKey)) {
            return false;
        }
        if (!Objects.equals(this.controllerClass, that.controllerClass)) {
            return false;
        }
        if (!Objects.equals((Object)this.preferredNodePortAddressType, (Object)that.preferredNodePortAddressType)) {
            return false;
        }
        if (!Objects.equals((Object)this.externalTrafficPolicy, (Object)that.externalTrafficPolicy)) {
            return false;
        }
        if (!Objects.equals(this.loadBalancerSourceRanges, that.loadBalancerSourceRanges)) {
            return false;
        }
        if (!Objects.equals(this.finalizers, that.finalizers)) {
            return false;
        }
        if (!Objects.equals(this.useServiceDnsDomain, that.useServiceDnsDomain)) {
            return false;
        }
        if (!Objects.equals((Object)this.bootstrap, (Object)that.bootstrap)) {
            return false;
        }
        if (!Objects.equals(this.brokers, that.brokers)) {
            return false;
        }
        if (!Objects.equals(this.maxConnections, that.maxConnections)) {
            return false;
        }
        if (!Objects.equals(this.maxConnectionCreationRate, that.maxConnectionCreationRate)) {
            return false;
        }
        if (!Objects.equals((Object)this.ipFamilyPolicy, (Object)that.ipFamilyPolicy)) {
            return false;
        }
        if (!Objects.equals(this.ipFamilies, that.ipFamilies)) {
            return false;
        }
        if (!Objects.equals(this.createBootstrapService, that.createBootstrapService)) {
            return false;
        }
        if (!Objects.equals(this.publishNotReadyAddresses, that.publishNotReadyAddresses)) {
            return false;
        }
        if (!Objects.equals(this.hostTemplate, that.hostTemplate)) {
            return false;
        }
        if (!Objects.equals(this.advertisedHostTemplate, that.advertisedHostTemplate)) {
            return false;
        }
        return Objects.equals(this.allocateLoadBalancerNodePorts, that.allocateLoadBalancerNodePorts);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.brokerCertChainAndKey, this.controllerClass, this.preferredNodePortAddressType, this.externalTrafficPolicy, this.loadBalancerSourceRanges, this.finalizers, this.useServiceDnsDomain, this.bootstrap, this.brokers, this.maxConnections, this.maxConnectionCreationRate, this.ipFamilyPolicy, this.ipFamilies, this.createBootstrapService, this.publishNotReadyAddresses, this.hostTemplate, this.advertisedHostTemplate, this.allocateLoadBalancerNodePorts, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.brokerCertChainAndKey != null) {
            sb.append("brokerCertChainAndKey:");
            sb.append(String.valueOf((Object)this.brokerCertChainAndKey) + ",");
        }
        if (this.controllerClass != null) {
            sb.append("controllerClass:");
            sb.append(this.controllerClass + ",");
        }
        if (this.preferredNodePortAddressType != null) {
            sb.append("preferredNodePortAddressType:");
            sb.append(String.valueOf((Object)this.preferredNodePortAddressType) + ",");
        }
        if (this.externalTrafficPolicy != null) {
            sb.append("externalTrafficPolicy:");
            sb.append(String.valueOf((Object)this.externalTrafficPolicy) + ",");
        }
        if (this.loadBalancerSourceRanges != null && !this.loadBalancerSourceRanges.isEmpty()) {
            sb.append("loadBalancerSourceRanges:");
            sb.append(String.valueOf(this.loadBalancerSourceRanges) + ",");
        }
        if (this.finalizers != null && !this.finalizers.isEmpty()) {
            sb.append("finalizers:");
            sb.append(String.valueOf(this.finalizers) + ",");
        }
        if (this.useServiceDnsDomain != null) {
            sb.append("useServiceDnsDomain:");
            sb.append(this.useServiceDnsDomain + ",");
        }
        if (this.bootstrap != null) {
            sb.append("bootstrap:");
            sb.append(String.valueOf((Object)this.bootstrap) + ",");
        }
        if (this.brokers != null && !this.brokers.isEmpty()) {
            sb.append("brokers:");
            sb.append(String.valueOf(this.brokers) + ",");
        }
        if (this.maxConnections != null) {
            sb.append("maxConnections:");
            sb.append(this.maxConnections + ",");
        }
        if (this.maxConnectionCreationRate != null) {
            sb.append("maxConnectionCreationRate:");
            sb.append(this.maxConnectionCreationRate + ",");
        }
        if (this.ipFamilyPolicy != null) {
            sb.append("ipFamilyPolicy:");
            sb.append(String.valueOf((Object)this.ipFamilyPolicy) + ",");
        }
        if (this.ipFamilies != null && !this.ipFamilies.isEmpty()) {
            sb.append("ipFamilies:");
            sb.append(String.valueOf(this.ipFamilies) + ",");
        }
        if (this.createBootstrapService != null) {
            sb.append("createBootstrapService:");
            sb.append(this.createBootstrapService + ",");
        }
        if (this.publishNotReadyAddresses != null) {
            sb.append("publishNotReadyAddresses:");
            sb.append(this.publishNotReadyAddresses + ",");
        }
        if (this.hostTemplate != null) {
            sb.append("hostTemplate:");
            sb.append(this.hostTemplate + ",");
        }
        if (this.advertisedHostTemplate != null) {
            sb.append("advertisedHostTemplate:");
            sb.append(this.advertisedHostTemplate + ",");
        }
        if (this.allocateLoadBalancerNodePorts != null) {
            sb.append("allocateLoadBalancerNodePorts:");
            sb.append(this.allocateLoadBalancerNodePorts);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withUseServiceDnsDomain() {
        return this.withUseServiceDnsDomain(true);
    }

    public A withCreateBootstrapService() {
        return this.withCreateBootstrapService(true);
    }

    public A withPublishNotReadyAddresses() {
        return this.withPublishNotReadyAddresses(true);
    }

    public A withAllocateLoadBalancerNodePorts() {
        return this.withAllocateLoadBalancerNodePorts(true);
    }

    public class BrokerCertChainAndKeyNested<N>
    extends CertAndKeySecretSourceFluent<BrokerCertChainAndKeyNested<N>>
    implements Nested<N> {
        CertAndKeySecretSourceBuilder builder;

        BrokerCertChainAndKeyNested(CertAndKeySecretSource item) {
            this.builder = new CertAndKeySecretSourceBuilder(this, item);
        }

        public N and() {
            return (N)GenericKafkaListenerConfigurationFluent.this.withBrokerCertChainAndKey(this.builder.build());
        }

        public N endBrokerCertChainAndKey() {
            return this.and();
        }
    }

    public class BootstrapNested<N>
    extends GenericKafkaListenerConfigurationBootstrapFluent<BootstrapNested<N>>
    implements Nested<N> {
        GenericKafkaListenerConfigurationBootstrapBuilder builder;

        BootstrapNested(GenericKafkaListenerConfigurationBootstrap item) {
            this.builder = new GenericKafkaListenerConfigurationBootstrapBuilder(this, item);
        }

        public N and() {
            return (N)GenericKafkaListenerConfigurationFluent.this.withBootstrap(this.builder.build());
        }

        public N endBootstrap() {
            return this.and();
        }
    }

    public class BrokersNested<N>
    extends GenericKafkaListenerConfigurationBrokerFluent<BrokersNested<N>>
    implements Nested<N> {
        GenericKafkaListenerConfigurationBrokerBuilder builder;
        int index;

        BrokersNested(int index, GenericKafkaListenerConfigurationBroker item) {
            this.index = index;
            this.builder = new GenericKafkaListenerConfigurationBrokerBuilder(this, item);
        }

        public N and() {
            return (N)GenericKafkaListenerConfigurationFluent.this.setToBrokers(this.index, this.builder.build());
        }

        public N endBroker() {
            return this.and();
        }
    }
}

