/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.kafka.cruisecontrol;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.strimzi.api.kafka.model.kafka.cruisecontrol.KafkaAutoRebalanceMode;
import io.strimzi.api.kafka.model.kafka.cruisecontrol.KafkaAutoRebalanceStatusBrokers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class KafkaAutoRebalanceStatusBrokersFluent<A extends KafkaAutoRebalanceStatusBrokersFluent<A>>
extends BaseFluent<A> {
    private KafkaAutoRebalanceMode mode;
    private List<Integer> brokers;

    public KafkaAutoRebalanceStatusBrokersFluent() {
    }

    public KafkaAutoRebalanceStatusBrokersFluent(KafkaAutoRebalanceStatusBrokers instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(KafkaAutoRebalanceStatusBrokers instance) {
        KafkaAutoRebalanceStatusBrokers kafkaAutoRebalanceStatusBrokers = instance = instance != null ? instance : new KafkaAutoRebalanceStatusBrokers();
        if (instance != null) {
            this.withMode(instance.getMode());
            this.withBrokers(instance.getBrokers());
        }
    }

    public KafkaAutoRebalanceMode getMode() {
        return this.mode;
    }

    public A withMode(KafkaAutoRebalanceMode mode) {
        this.mode = mode;
        return (A)((Object)this);
    }

    public boolean hasMode() {
        return this.mode != null;
    }

    public A addToBrokers(int index, Integer item) {
        if (this.brokers == null) {
            this.brokers = new ArrayList<Integer>();
        }
        this.brokers.add(index, item);
        return (A)((Object)this);
    }

    public A setToBrokers(int index, Integer item) {
        if (this.brokers == null) {
            this.brokers = new ArrayList<Integer>();
        }
        this.brokers.set(index, item);
        return (A)((Object)this);
    }

    public A addToBrokers(Integer ... items) {
        if (this.brokers == null) {
            this.brokers = new ArrayList<Integer>();
        }
        for (Integer item : items) {
            this.brokers.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToBrokers(Collection<Integer> items) {
        if (this.brokers == null) {
            this.brokers = new ArrayList<Integer>();
        }
        for (Integer item : items) {
            this.brokers.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromBrokers(Integer ... items) {
        if (this.brokers == null) {
            return (A)((Object)this);
        }
        for (Integer item : items) {
            this.brokers.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromBrokers(Collection<Integer> items) {
        if (this.brokers == null) {
            return (A)((Object)this);
        }
        for (Integer item : items) {
            this.brokers.remove(item);
        }
        return (A)((Object)this);
    }

    public List<Integer> getBrokers() {
        return this.brokers;
    }

    public Integer getBroker(int index) {
        return this.brokers.get(index);
    }

    public Integer getFirstBroker() {
        return this.brokers.get(0);
    }

    public Integer getLastBroker() {
        return this.brokers.get(this.brokers.size() - 1);
    }

    public Integer getMatchingBroker(Predicate<Integer> predicate) {
        for (Integer item : this.brokers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingBroker(Predicate<Integer> predicate) {
        for (Integer item : this.brokers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withBrokers(List<Integer> brokers) {
        if (brokers != null) {
            this.brokers = new ArrayList<Integer>();
            for (Integer item : brokers) {
                this.addToBrokers(item);
            }
        } else {
            this.brokers = null;
        }
        return (A)((Object)this);
    }

    public A withBrokers(Integer ... brokers) {
        if (this.brokers != null) {
            this.brokers.clear();
            this._visitables.remove((Object)"brokers");
        }
        if (brokers != null) {
            for (Integer item : brokers) {
                this.addToBrokers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasBrokers() {
        return this.brokers != null && !this.brokers.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaAutoRebalanceStatusBrokersFluent that = (KafkaAutoRebalanceStatusBrokersFluent)((Object)o);
        if (!Objects.equals((Object)this.mode, (Object)that.mode)) {
            return false;
        }
        return Objects.equals(this.brokers, that.brokers);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mode, this.brokers, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.mode != null) {
            sb.append("mode:");
            sb.append(String.valueOf((Object)this.mode) + ",");
        }
        if (this.brokers != null && !this.brokers.isEmpty()) {
            sb.append("brokers:");
            sb.append(this.brokers);
        }
        sb.append("}");
        return sb.toString();
    }
}

