/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.kafka;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.common.CertSecretSource;
import io.strimzi.api.kafka.model.kafka.KafkaAuthorization;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.Example;
import io.strimzi.crdgenerator.annotations.Minimum;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "clientId", "tokenEndpointUri", "tlsTrustedCertificates", "disableTlsHostnameVerification", "delegateToKafkaAcls", "grantsRefreshPeriodSeconds", "grantsRefreshPoolSize", "grantsMaxIdleTimeSeconds", "grantsGcPeriodSeconds", "grantsAlwaysLatest", "superUsers", "connectTimeoutSeconds", "readTimeoutSeconds", "httpRetries", "enableMetrics", "includeAcceptHeader"})
public class KafkaAuthorizationKeycloak
extends KafkaAuthorization {
    public static final String TYPE_KEYCLOAK = "keycloak";
    public static final String AUTHORIZER_CLASS_NAME = "io.strimzi.kafka.oauth.server.authorizer.KeycloakAuthorizer";
    private String clientId;
    private String tokenEndpointUri;
    private List<CertSecretSource> tlsTrustedCertificates;
    private boolean disableTlsHostnameVerification = false;
    private boolean delegateToKafkaAcls = false;
    private Integer grantsRefreshPeriodSeconds;
    private Integer grantsRefreshPoolSize;
    private Integer grantsMaxIdleTimeSeconds;
    private Integer grantsGcPeriodSeconds;
    private boolean grantsAlwaysLatest = false;
    private Integer connectTimeoutSeconds;
    private Integer readTimeoutSeconds;
    private Integer httpRetries;
    private List<String> superUsers;
    private boolean enableMetrics = false;
    private boolean includeAcceptHeader = true;

    @Override
    @Description(value="Must be `keycloak`")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getType() {
        return TYPE_KEYCLOAK;
    }

    @Override
    public boolean supportsAdminApi() {
        return this.delegateToKafkaAcls;
    }

    @Description(value="OAuth Client ID which the Kafka client can use to authenticate against the OAuth server and use the token endpoint URI.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Description(value="Authorization server token endpoint URI.")
    public String getTokenEndpointUri() {
        return this.tokenEndpointUri;
    }

    public void setTokenEndpointUri(String tokenEndpointUri) {
        this.tokenEndpointUri = tokenEndpointUri;
    }

    @Description(value="Trusted certificates for TLS connection to the OAuth server.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<CertSecretSource> getTlsTrustedCertificates() {
        return this.tlsTrustedCertificates;
    }

    public void setTlsTrustedCertificates(List<CertSecretSource> tlsTrustedCertificates) {
        this.tlsTrustedCertificates = tlsTrustedCertificates;
    }

    @Description(value="Enable or disable TLS hostname verification. Default value is `false`.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isDisableTlsHostnameVerification() {
        return this.disableTlsHostnameVerification;
    }

    public void setDisableTlsHostnameVerification(boolean disableTlsHostnameVerification) {
        this.disableTlsHostnameVerification = disableTlsHostnameVerification;
    }

    @Description(value="Whether authorization decision should be delegated to the 'Simple' authorizer if DENIED by Keycloak Authorization Services policies. Default value is `false`.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isDelegateToKafkaAcls() {
        return this.delegateToKafkaAcls;
    }

    public void setDelegateToKafkaAcls(boolean delegateToKafkaAcls) {
        this.delegateToKafkaAcls = delegateToKafkaAcls;
    }

    @Description(value="The time between two consecutive grants refresh runs in seconds. The default value is 60.")
    @Minimum(value=0)
    @JsonProperty(defaultValue="60")
    public Integer getGrantsRefreshPeriodSeconds() {
        return this.grantsRefreshPeriodSeconds;
    }

    public void setGrantsRefreshPeriodSeconds(Integer grantsRefreshPeriodSeconds) {
        this.grantsRefreshPeriodSeconds = grantsRefreshPeriodSeconds;
    }

    @Description(value="The number of threads to use to refresh grants for active sessions. The more threads, the more parallelism, so the sooner the job completes. However, using more threads places a heavier load on the authorization server. The default value is 5.")
    @Minimum(value=1)
    @JsonProperty(defaultValue="5")
    public Integer getGrantsRefreshPoolSize() {
        return this.grantsRefreshPoolSize;
    }

    public void setGrantsRefreshPoolSize(Integer grantsRefreshPoolSize) {
        this.grantsRefreshPoolSize = grantsRefreshPoolSize;
    }

    @Description(value="The time, in seconds, after which an idle grant can be evicted from the cache. The default value is 300.")
    @Minimum(value=1)
    @JsonProperty(defaultValue="300")
    public Integer getGrantsMaxIdleTimeSeconds() {
        return this.grantsMaxIdleTimeSeconds;
    }

    public void setGrantsMaxIdleTimeSeconds(Integer grantsMaxIdleTimeSeconds) {
        this.grantsMaxIdleTimeSeconds = grantsMaxIdleTimeSeconds;
    }

    @Description(value="The time, in seconds, between consecutive runs of a job that cleans stale grants from the cache. The default value is 300.")
    @Minimum(value=1)
    @JsonProperty(defaultValue="300")
    public Integer getGrantsGcPeriodSeconds() {
        return this.grantsGcPeriodSeconds;
    }

    public void setGrantsGcPeriodSeconds(Integer grantsGcPeriodSeconds) {
        this.grantsGcPeriodSeconds = grantsGcPeriodSeconds;
    }

    @Description(value="Controls whether the latest grants are fetched for a new session. When enabled, grants are retrieved from Keycloak and cached for the user. The default value is `false`.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isGrantsAlwaysLatest() {
        return this.grantsAlwaysLatest;
    }

    public void setGrantsAlwaysLatest(boolean grantsAlwaysLatest) {
        this.grantsAlwaysLatest = grantsAlwaysLatest;
    }

    @Description(value="List of super users. Should contain list of user principals which should get unlimited access rights.")
    @Example(value="- CN=my-user\n- CN=my-other-user")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getSuperUsers() {
        return this.superUsers;
    }

    public void setSuperUsers(List<String> superUsers) {
        this.superUsers = superUsers;
    }

    @Description(value="The connect timeout in seconds when connecting to authorization server. If not set, the effective connect timeout is 60 seconds.")
    @Minimum(value=1)
    @JsonProperty(defaultValue="60")
    public Integer getConnectTimeoutSeconds() {
        return this.connectTimeoutSeconds;
    }

    public void setConnectTimeoutSeconds(Integer connectTimeoutSeconds) {
        this.connectTimeoutSeconds = connectTimeoutSeconds;
    }

    @Description(value="The read timeout in seconds when connecting to authorization server. If not set, the effective read timeout is 60 seconds.")
    @Minimum(value=1)
    @JsonProperty(defaultValue="60")
    public Integer getReadTimeoutSeconds() {
        return this.readTimeoutSeconds;
    }

    public void setReadTimeoutSeconds(Integer readTimeoutSeconds) {
        this.readTimeoutSeconds = readTimeoutSeconds;
    }

    @Description(value="The maximum number of retries to attempt if an initial HTTP request fails. If not set, the default is to not attempt any retries.")
    @Minimum(value=0)
    @JsonProperty(defaultValue="0")
    public Integer getHttpRetries() {
        return this.httpRetries;
    }

    public void setHttpRetries(Integer httpRetries) {
        this.httpRetries = httpRetries;
    }

    @Description(value="Enable or disable OAuth metrics. The default value is `false`.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isEnableMetrics() {
        return this.enableMetrics;
    }

    public void setEnableMetrics(boolean enableMetrics) {
        this.enableMetrics = enableMetrics;
    }

    @Description(value="Whether the Accept header should be set in requests to the authorization servers. The default value is `true`.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isIncludeAcceptHeader() {
        return this.includeAcceptHeader;
    }

    public void setIncludeAcceptHeader(boolean includeAcceptHeader) {
        this.includeAcceptHeader = includeAcceptHeader;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaAuthorizationKeycloak)) {
            return false;
        }
        KafkaAuthorizationKeycloak other = (KafkaAuthorizationKeycloak)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isDisableTlsHostnameVerification() != other.isDisableTlsHostnameVerification()) {
            return false;
        }
        if (this.isDelegateToKafkaAcls() != other.isDelegateToKafkaAcls()) {
            return false;
        }
        if (this.isGrantsAlwaysLatest() != other.isGrantsAlwaysLatest()) {
            return false;
        }
        if (this.isEnableMetrics() != other.isEnableMetrics()) {
            return false;
        }
        if (this.isIncludeAcceptHeader() != other.isIncludeAcceptHeader()) {
            return false;
        }
        Integer this$grantsRefreshPeriodSeconds = this.getGrantsRefreshPeriodSeconds();
        Integer other$grantsRefreshPeriodSeconds = other.getGrantsRefreshPeriodSeconds();
        if (this$grantsRefreshPeriodSeconds == null ? other$grantsRefreshPeriodSeconds != null : !((Object)this$grantsRefreshPeriodSeconds).equals(other$grantsRefreshPeriodSeconds)) {
            return false;
        }
        Integer this$grantsRefreshPoolSize = this.getGrantsRefreshPoolSize();
        Integer other$grantsRefreshPoolSize = other.getGrantsRefreshPoolSize();
        if (this$grantsRefreshPoolSize == null ? other$grantsRefreshPoolSize != null : !((Object)this$grantsRefreshPoolSize).equals(other$grantsRefreshPoolSize)) {
            return false;
        }
        Integer this$grantsMaxIdleTimeSeconds = this.getGrantsMaxIdleTimeSeconds();
        Integer other$grantsMaxIdleTimeSeconds = other.getGrantsMaxIdleTimeSeconds();
        if (this$grantsMaxIdleTimeSeconds == null ? other$grantsMaxIdleTimeSeconds != null : !((Object)this$grantsMaxIdleTimeSeconds).equals(other$grantsMaxIdleTimeSeconds)) {
            return false;
        }
        Integer this$grantsGcPeriodSeconds = this.getGrantsGcPeriodSeconds();
        Integer other$grantsGcPeriodSeconds = other.getGrantsGcPeriodSeconds();
        if (this$grantsGcPeriodSeconds == null ? other$grantsGcPeriodSeconds != null : !((Object)this$grantsGcPeriodSeconds).equals(other$grantsGcPeriodSeconds)) {
            return false;
        }
        Integer this$connectTimeoutSeconds = this.getConnectTimeoutSeconds();
        Integer other$connectTimeoutSeconds = other.getConnectTimeoutSeconds();
        if (this$connectTimeoutSeconds == null ? other$connectTimeoutSeconds != null : !((Object)this$connectTimeoutSeconds).equals(other$connectTimeoutSeconds)) {
            return false;
        }
        Integer this$readTimeoutSeconds = this.getReadTimeoutSeconds();
        Integer other$readTimeoutSeconds = other.getReadTimeoutSeconds();
        if (this$readTimeoutSeconds == null ? other$readTimeoutSeconds != null : !((Object)this$readTimeoutSeconds).equals(other$readTimeoutSeconds)) {
            return false;
        }
        Integer this$httpRetries = this.getHttpRetries();
        Integer other$httpRetries = other.getHttpRetries();
        if (this$httpRetries == null ? other$httpRetries != null : !((Object)this$httpRetries).equals(other$httpRetries)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$tokenEndpointUri = this.getTokenEndpointUri();
        String other$tokenEndpointUri = other.getTokenEndpointUri();
        if (this$tokenEndpointUri == null ? other$tokenEndpointUri != null : !this$tokenEndpointUri.equals(other$tokenEndpointUri)) {
            return false;
        }
        List<CertSecretSource> this$tlsTrustedCertificates = this.getTlsTrustedCertificates();
        List<CertSecretSource> other$tlsTrustedCertificates = other.getTlsTrustedCertificates();
        if (this$tlsTrustedCertificates == null ? other$tlsTrustedCertificates != null : !((Object)this$tlsTrustedCertificates).equals(other$tlsTrustedCertificates)) {
            return false;
        }
        List<String> this$superUsers = this.getSuperUsers();
        List<String> other$superUsers = other.getSuperUsers();
        return !(this$superUsers == null ? other$superUsers != null : !((Object)this$superUsers).equals(other$superUsers));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaAuthorizationKeycloak;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isDisableTlsHostnameVerification() ? 79 : 97);
        result = result * 59 + (this.isDelegateToKafkaAcls() ? 79 : 97);
        result = result * 59 + (this.isGrantsAlwaysLatest() ? 79 : 97);
        result = result * 59 + (this.isEnableMetrics() ? 79 : 97);
        result = result * 59 + (this.isIncludeAcceptHeader() ? 79 : 97);
        Integer $grantsRefreshPeriodSeconds = this.getGrantsRefreshPeriodSeconds();
        result = result * 59 + ($grantsRefreshPeriodSeconds == null ? 43 : ((Object)$grantsRefreshPeriodSeconds).hashCode());
        Integer $grantsRefreshPoolSize = this.getGrantsRefreshPoolSize();
        result = result * 59 + ($grantsRefreshPoolSize == null ? 43 : ((Object)$grantsRefreshPoolSize).hashCode());
        Integer $grantsMaxIdleTimeSeconds = this.getGrantsMaxIdleTimeSeconds();
        result = result * 59 + ($grantsMaxIdleTimeSeconds == null ? 43 : ((Object)$grantsMaxIdleTimeSeconds).hashCode());
        Integer $grantsGcPeriodSeconds = this.getGrantsGcPeriodSeconds();
        result = result * 59 + ($grantsGcPeriodSeconds == null ? 43 : ((Object)$grantsGcPeriodSeconds).hashCode());
        Integer $connectTimeoutSeconds = this.getConnectTimeoutSeconds();
        result = result * 59 + ($connectTimeoutSeconds == null ? 43 : ((Object)$connectTimeoutSeconds).hashCode());
        Integer $readTimeoutSeconds = this.getReadTimeoutSeconds();
        result = result * 59 + ($readTimeoutSeconds == null ? 43 : ((Object)$readTimeoutSeconds).hashCode());
        Integer $httpRetries = this.getHttpRetries();
        result = result * 59 + ($httpRetries == null ? 43 : ((Object)$httpRetries).hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $tokenEndpointUri = this.getTokenEndpointUri();
        result = result * 59 + ($tokenEndpointUri == null ? 43 : $tokenEndpointUri.hashCode());
        List<CertSecretSource> $tlsTrustedCertificates = this.getTlsTrustedCertificates();
        result = result * 59 + ($tlsTrustedCertificates == null ? 43 : ((Object)$tlsTrustedCertificates).hashCode());
        List<String> $superUsers = this.getSuperUsers();
        result = result * 59 + ($superUsers == null ? 43 : ((Object)$superUsers).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "KafkaAuthorizationKeycloak(super=" + super.toString() + ", clientId=" + this.getClientId() + ", tokenEndpointUri=" + this.getTokenEndpointUri() + ", tlsTrustedCertificates=" + String.valueOf(this.getTlsTrustedCertificates()) + ", disableTlsHostnameVerification=" + this.isDisableTlsHostnameVerification() + ", delegateToKafkaAcls=" + this.isDelegateToKafkaAcls() + ", grantsRefreshPeriodSeconds=" + this.getGrantsRefreshPeriodSeconds() + ", grantsRefreshPoolSize=" + this.getGrantsRefreshPoolSize() + ", grantsMaxIdleTimeSeconds=" + this.getGrantsMaxIdleTimeSeconds() + ", grantsGcPeriodSeconds=" + this.getGrantsGcPeriodSeconds() + ", grantsAlwaysLatest=" + this.isGrantsAlwaysLatest() + ", connectTimeoutSeconds=" + this.getConnectTimeoutSeconds() + ", readTimeoutSeconds=" + this.getReadTimeoutSeconds() + ", httpRetries=" + this.getHttpRetries() + ", superUsers=" + String.valueOf(this.getSuperUsers()) + ", enableMetrics=" + this.isEnableMetrics() + ", includeAcceptHeader=" + this.isIncludeAcceptHeader() + ")";
    }
}

