/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.bridge;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.bridge.KafkaBridgeClientSpec;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.DescriptionFile;
import java.util.Map;

@DescriptionFile
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"enabled", "timeoutSeconds", "config"})
public class KafkaBridgeConsumerSpec
extends KafkaBridgeClientSpec {
    public static final String FORBIDDEN_PREFIXES = "ssl., bootstrap.servers, group.id, sasl., security.";
    public static final String FORBIDDEN_PREFIX_EXCEPTIONS = "ssl.endpoint.identification.algorithm, ssl.cipher.suites, ssl.protocol, ssl.enabled.protocols";
    public static final long HTTP_DEFAULT_TIMEOUT = -1L;
    private boolean enabled = true;
    private long timeoutSeconds = -1L;

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Description(value="The Kafka consumer configuration used for consumer instances created by the bridge. Properties with the following prefixes cannot be set: ssl., bootstrap.servers, group.id, sasl., security. (with the exception of: ssl.endpoint.identification.algorithm, ssl.cipher.suites, ssl.protocol, ssl.enabled.protocols).")
    public Map<String, Object> getConfig() {
        return this.config;
    }

    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    @Description(value="Whether the HTTP consumer should be enabled or disabled. The default is enabled (`true`).")
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    @Description(value="The timeout in seconds for deleting inactive consumers, default is -1 (disabled).")
    public long getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public void setTimeoutSeconds(long timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaBridgeConsumerSpec)) {
            return false;
        }
        KafkaBridgeConsumerSpec other = (KafkaBridgeConsumerSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        return this.getTimeoutSeconds() == other.getTimeoutSeconds();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaBridgeConsumerSpec;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        long $timeoutSeconds = this.getTimeoutSeconds();
        result = result * 59 + (int)($timeoutSeconds >>> 32 ^ $timeoutSeconds);
        return result;
    }

    @Override
    public String toString() {
        return "KafkaBridgeConsumerSpec(super=" + super.toString() + ", enabled=" + this.isEnabled() + ", timeoutSeconds=" + this.getTimeoutSeconds() + ")";
    }
}

