/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.test;

import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.TimeZone;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;
import org.quartz.CronExpression;

public class CronTest {
    @Test
    public void testHoursRangeEveryDay() throws ParseException {
        CronExpression cronExpression = new CronExpression("* * 14-15 * * ?");
        Date d = Date.from(LocalDateTime.of(2018, 11, 26, 13, 59, 0).atZone(ZoneId.systemDefault()).toInstant());
        MatcherAssert.assertThat((Object)cronExpression.isSatisfiedBy(d), (Matcher)CoreMatchers.is((Object)false));
        d = Date.from(LocalDateTime.of(2018, 11, 26, 14, 0, 0).atZone(ZoneId.systemDefault()).toInstant());
        MatcherAssert.assertThat((Object)cronExpression.isSatisfiedBy(d), (Matcher)CoreMatchers.is((Object)true));
        d = Date.from(LocalDateTime.of(2018, 11, 26, 15, 59, 0).atZone(ZoneId.systemDefault()).toInstant());
        MatcherAssert.assertThat((Object)cronExpression.isSatisfiedBy(d), (Matcher)CoreMatchers.is((Object)true));
        d = Date.from(LocalDateTime.of(2018, 11, 26, 16, 0, 1).atZone(ZoneId.systemDefault()).toInstant());
        MatcherAssert.assertThat((Object)cronExpression.isSatisfiedBy(d), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testHoursRangeOnWeekend() throws ParseException {
        CronExpression cronExpression = new CronExpression("* * 14-15 ? * 1,7");
        Date d = Date.from(LocalDateTime.of(2018, 11, 24, 14, 0, 0).atZone(ZoneId.systemDefault()).toInstant());
        MatcherAssert.assertThat((Object)cronExpression.isSatisfiedBy(d), (Matcher)CoreMatchers.is((Object)true));
        d = Date.from(LocalDateTime.of(2018, 11, 25, 14, 0, 0).atZone(ZoneId.systemDefault()).toInstant());
        MatcherAssert.assertThat((Object)cronExpression.isSatisfiedBy(d), (Matcher)CoreMatchers.is((Object)true));
        for (int day = 26; day <= 30; ++day) {
            d = Date.from(LocalDateTime.of(2018, 11, day, 14, 0, 0).atZone(ZoneId.systemDefault()).toInstant());
            MatcherAssert.assertThat((Object)cronExpression.isSatisfiedBy(d), (Matcher)CoreMatchers.is((Object)false));
        }
    }

    @Test
    public void testUserTimeZoneVsPodTimeZone() throws ParseException {
        CronExpression cronExpression = new CronExpression("* * 14-15 * * ?");
        cronExpression.setTimeZone(TimeZone.getTimeZone(ZoneId.of("Europe/Rome")));
        Date d = Date.from(LocalDateTime.of(2018, 11, 26, 8, 0, 0).atZone(ZoneId.of("Pacific/Easter")).toInstant());
        MatcherAssert.assertThat((Object)cronExpression.isSatisfiedBy(d), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testUtcTimeZone() throws ParseException {
        CronExpression cronExpression = new CronExpression("* * 14-15 * * ?");
        cronExpression.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date d = Date.from(LocalDateTime.of(2018, 11, 26, 9, 0, 0).atZone(ZoneId.of("Pacific/Easter")).toInstant());
        MatcherAssert.assertThat((Object)cronExpression.isSatisfiedBy(d), (Matcher)CoreMatchers.is((Object)true));
    }
}

