/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.user;

import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.strimzi.api.kafka.model.AbstractCrdIT;
import io.strimzi.api.kafka.model.user.KafkaUser;
import io.strimzi.test.CrdUtils;
import io.strimzi.test.TestUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class KafkaUserCrdIT
extends AbstractCrdIT {
    public static final String NAMESPACE = "kafkausercrd-it";

    @Test
    void testKafkaUserV1alpha1() {
        this.createDeleteCustomResource("KafkaUserV1alpha1.yaml");
    }

    @Test
    void testKafkaUserIsNotScaling() {
        Assertions.assertThrows(KubernetesClientException.class, () -> this.createScaleDelete(KafkaUser.class, "KafkaUser.yaml"));
    }

    @Test
    void testKafkaUserV1beta1() {
        this.createDeleteCustomResource("KafkaUserV1beta1.yaml");
    }

    @Test
    void testKafkaUserMinimal() {
        this.createDeleteCustomResource("KafkaUser-minimal.yaml");
    }

    @BeforeAll
    void setupEnvironment() {
        this.client = new KubernetesClientBuilder().withConfig(((ConfigBuilder)new ConfigBuilder().withNamespace(NAMESPACE)).build()).build();
        CrdUtils.createCrd((KubernetesClient)this.client, (String)"kafkausers.kafka.strimzi.io", (String)CrdUtils.CRD_KAFKA_USER);
        TestUtils.createNamespace((KubernetesClient)this.client, (String)NAMESPACE);
    }

    @AfterAll
    void teardownEnvironment() {
        CrdUtils.deleteCrd((KubernetesClient)this.client, (String)"kafkausers.kafka.strimzi.io");
        TestUtils.deleteNamespace((KubernetesClient)this.client, (String)NAMESPACE);
        this.client.close();
    }
}

