/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.topic;

import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.strimzi.api.kafka.model.AbstractCrdIT;
import io.strimzi.api.kafka.model.topic.KafkaTopic;
import io.strimzi.test.CrdUtils;
import io.strimzi.test.TestUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class KafkaTopicCrdIT
extends AbstractCrdIT {
    public static final String NAMESPACE = "topiccrd-it";

    @Test
    void testKafkaTopicV1alpha1() {
        this.createDeleteCustomResource("KafkaTopicV1alpha1.yaml");
    }

    @Test
    void testKafkaTopicIsNotScaling() {
        Assertions.assertThrows(KubernetesClientException.class, () -> this.createScaleDelete(KafkaTopic.class, "KafkaTopic.yaml"));
    }

    @Test
    void testKafkaTopicV1beta1() {
        this.createDeleteCustomResource("KafkaTopicV1beta1.yaml");
    }

    @Test
    void testKafkaTopicMinimal() {
        this.createDeleteCustomResource("KafkaTopic-minimal.yaml");
    }

    @BeforeAll
    void setupEnvironment() {
        this.client = new KubernetesClientBuilder().withConfig(((ConfigBuilder)new ConfigBuilder().withNamespace(NAMESPACE)).build()).build();
        CrdUtils.createCrd((KubernetesClient)this.client, (String)"kafkatopics.kafka.strimzi.io", (String)CrdUtils.CRD_TOPIC);
        TestUtils.createNamespace((KubernetesClient)this.client, (String)NAMESPACE);
    }

    @AfterAll
    void teardownEnvironment() {
        CrdUtils.deleteCrd((KubernetesClient)this.client, (String)"kafkatopics.kafka.strimzi.io");
        TestUtils.deleteNamespace((KubernetesClient)this.client, (String)NAMESPACE);
        this.client.close();
    }
}

