/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.podset;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.CustomResourceFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.strimzi.api.kafka.Crds;
import io.strimzi.api.kafka.model.AbstractCrdIT;
import io.strimzi.api.kafka.model.podset.StrimziPodSet;
import io.strimzi.api.kafka.model.podset.StrimziPodSetBuilder;
import io.strimzi.api.kafka.model.podset.StrimziPodSetFluent;
import io.strimzi.test.CrdUtils;
import io.strimzi.test.TestUtils;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class StrimziPodSetCrdIT
extends AbstractCrdIT {
    public static final String NAMESPACE = "strimzipodset-crd-it";

    @Test
    void testStrimziPodSetMinimal() {
        this.createDeleteCustomResource("StrimziPodSet.yaml");
    }

    @Test
    void testStrimziPodSettWithMissingRequired() {
        Throwable exception = Assertions.assertThrows(KubernetesClientException.class, () -> this.createDeleteCustomResource("StrimziPodSet-with-missing-required-property.yaml"));
        this.assertMissingRequiredPropertiesMessage(exception.getMessage(), "pods", "selector");
    }

    @Test
    void testZeroReplicas() {
        StrimziPodSet podSet = ((StrimziPodSetBuilder)((StrimziPodSetFluent.SpecNested)((StrimziPodSetFluent.SpecNested)((StrimziPodSetBuilder)((CustomResourceFluent.MetadataNested)new StrimziPodSetBuilder().withNewMetadata().withName("my-pod-set")).endMetadata()).withNewSpec().withPods(List.of())).withSelector(((LabelSelectorBuilder)new LabelSelectorBuilder().withMatchLabels(Map.of("label", "value"))).build())).endSpec()).build();
        KubernetesClient client = new KubernetesClientBuilder().build();
        ((Resource)((NonNamespaceOperation)Crds.strimziPodSetOperation((KubernetesClient)client).inNamespace(NAMESPACE)).resource((Object)podSet)).create();
        StrimziPodSet createdPodSet = (StrimziPodSet)((Resource)((NonNamespaceOperation)Crds.strimziPodSetOperation((KubernetesClient)client).inNamespace(NAMESPACE)).withName("my-pod-set")).get();
        MatcherAssert.assertThat((Object)createdPodSet.getSpec().getPods(), (Matcher)CoreMatchers.is(List.of()));
        ((Resource)((NonNamespaceOperation)Crds.strimziPodSetOperation((KubernetesClient)client).inNamespace(NAMESPACE)).withName("my-pod-set")).delete();
    }

    @BeforeAll
    void setupEnvironment() {
        this.client = new KubernetesClientBuilder().withConfig(((ConfigBuilder)new ConfigBuilder().withNamespace(NAMESPACE)).build()).build();
        CrdUtils.createCrd((KubernetesClient)this.client, (String)"strimzipodsets.core.strimzi.io", (String)CrdUtils.CRD_STRIMZI_POD_SET);
        TestUtils.createNamespace((KubernetesClient)this.client, (String)NAMESPACE);
    }

    @AfterAll
    void teardownEnvironment() {
        CrdUtils.deleteCrd((KubernetesClient)this.client, (String)"strimzipodsets.core.strimzi.io");
        TestUtils.deleteNamespace((KubernetesClient)this.client, (String)NAMESPACE);
        this.client.close();
    }
}

