/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.nodepool;

import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.strimzi.api.kafka.model.AbstractCrdIT;
import io.strimzi.api.kafka.model.nodepool.KafkaNodePool;
import io.strimzi.test.CrdUtils;
import io.strimzi.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class KafkaNodePoolCrdIT
extends AbstractCrdIT {
    public static final String NAMESPACE = "kafkanodepool-crd-it";

    @Test
    void testKafkaNodePool() {
        this.createDeleteCustomResource("KafkaNodePool.yaml");
    }

    @Test
    void testKafkaNodePoolScaling() {
        this.createScaleDelete(KafkaNodePool.class, "KafkaNodePool.yaml");
    }

    @Test
    public void testKafkaWithInvalidRole() {
        Throwable exception = Assertions.assertThrows(KubernetesClientException.class, () -> this.createDeleteCustomResource("KafkaNodePool-with-invalid-role.yaml"));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{Matchers.containsStringIgnoringCase((String)"spec.roles: Unsupported value: \"helper\": supported values: \"controller\", \"broker\""), Matchers.containsStringIgnoringCase((String)"spec.roles[0]: Unsupported value: \"helper\": supported values: \"controller\", \"broker\"")}));
    }

    @BeforeAll
    void setupEnvironment() {
        this.client = new KubernetesClientBuilder().withConfig(((ConfigBuilder)new ConfigBuilder().withNamespace(NAMESPACE)).build()).build();
        CrdUtils.createCrd((KubernetesClient)this.client, (String)"kafkanodepools.kafka.strimzi.io", (String)CrdUtils.CRD_KAFKA_NODE_POOL);
        TestUtils.createNamespace((KubernetesClient)this.client, (String)NAMESPACE);
    }

    @AfterAll
    void teardownEnvironment() {
        CrdUtils.deleteCrd((KubernetesClient)this.client, (String)"kafkanodepools.kafka.strimzi.io");
        TestUtils.deleteNamespace((KubernetesClient)this.client, (String)NAMESPACE);
        this.client.close();
    }
}

