/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.mirrormaker;

import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.strimzi.api.kafka.model.AbstractCrdIT;
import io.strimzi.api.kafka.model.mirrormaker.KafkaMirrorMaker;
import io.strimzi.test.CrdUtils;
import io.strimzi.test.TestUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class KafkaMirrorMakerCrdIT
extends AbstractCrdIT {
    public static final String NAMESPACE = "kafkamirrormaker-crd-it";

    @Test
    void testKafkaMirrorMakerScaling() {
        this.createScaleDelete(KafkaMirrorMaker.class, "KafkaMirrorMaker.yaml");
    }

    @Test
    void testKafkaMirrorMakerMinimal() {
        this.createDeleteCustomResource("KafkaMirrorMaker-minimal.yaml");
    }

    @Test
    void testKafkaMirrorMakerWithMissingRequired() {
        Throwable exception = Assertions.assertThrows(KubernetesClientException.class, () -> this.createDeleteCustomResource("KafkaMirrorMaker-with-missing-required-property.yaml"));
        this.assertMissingRequiredPropertiesMessage(exception.getMessage(), "bootstrapServers", "producer");
    }

    @Test
    void testKafkaMirrorMakerWithTls() {
        this.createDeleteCustomResource("KafkaMirrorMaker-with-tls.yaml");
    }

    @Test
    void testKafkaMirrorMakerWithTlsAuth() {
        this.createDeleteCustomResource("KafkaMirrorMaker-with-tls-auth.yaml");
    }

    @Test
    void testKafkaMirrorMakerWithTlsAuthWithMissingRequired() {
        Throwable exception = Assertions.assertThrows(KubernetesClientException.class, () -> this.createDeleteCustomResource("KafkaMirrorMaker-with-tls-auth-with-missing-required.yaml"));
        this.assertMissingRequiredPropertiesMessage(exception.getMessage(), "spec.producer.authentication.certificateAndKey.certificate", "spec.producer.authentication.certificateAndKey.key");
    }

    @Test
    void testKafkaMirrorMakerWithScramSha512Auth() {
        this.createDeleteCustomResource("KafkaMirrorMaker-with-scram-sha-512-auth.yaml");
    }

    @Test
    void testKafkaMirrorMakerWithTemplate() {
        this.createDeleteCustomResource("KafkaMirrorMaker-with-template.yaml");
    }

    @Test
    void testKafkaMirrorMakerWithCommitAndAbort() {
        this.createDeleteCustomResource("KafkaMirrorMaker-with-commit-and-abort.yaml");
    }

    @BeforeAll
    void setupEnvironment() {
        this.client = new KubernetesClientBuilder().withConfig(((ConfigBuilder)new ConfigBuilder().withNamespace(NAMESPACE)).build()).build();
        CrdUtils.createCrd((KubernetesClient)this.client, (String)"kafkamirrormakers.kafka.strimzi.io", (String)CrdUtils.CRD_KAFKA_MIRROR_MAKER);
        TestUtils.createNamespace((KubernetesClient)this.client, (String)NAMESPACE);
    }

    @AfterAll
    void teardownEnvironment() {
        CrdUtils.deleteCrd((KubernetesClient)this.client, (String)"kafkamirrormakers.kafka.strimzi.io");
        TestUtils.deleteNamespace((KubernetesClient)this.client, (String)NAMESPACE);
        this.client.close();
    }
}

