/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.connector;

import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.strimzi.api.kafka.model.AbstractCrdIT;
import io.strimzi.api.kafka.model.connector.KafkaConnector;
import io.strimzi.test.CrdUtils;
import io.strimzi.test.TestUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class KafkaConnectorCrdIT
extends AbstractCrdIT {
    public static final String NAMESPACE = "kafkaconnector-crd-it";

    @Test
    void testKafkaConnector() {
        this.createDeleteCustomResource("KafkaConnector.yaml");
    }

    @Test
    void testKafkaConnectorScaling() {
        this.createScaleDelete(KafkaConnector.class, "KafkaConnector.yaml");
    }

    @BeforeAll
    void setupEnvironment() {
        this.client = new KubernetesClientBuilder().withConfig(((ConfigBuilder)new ConfigBuilder().withNamespace(NAMESPACE)).build()).build();
        CrdUtils.createCrd((KubernetesClient)this.client, (String)"kafkaconnectors.kafka.strimzi.io", (String)CrdUtils.CRD_KAFKA_CONNECTOR);
        TestUtils.createNamespace((KubernetesClient)this.client, (String)NAMESPACE);
    }

    @AfterAll
    void teardownEnvironment() {
        CrdUtils.deleteCrd((KubernetesClient)this.client, (String)"kafkaconnectors.kafka.strimzi.io");
        TestUtils.deleteNamespace((KubernetesClient)this.client, (String)NAMESPACE);
        this.client.close();
    }
}

