/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionCondition;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionVersion;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.strimzi.api.annotations.ApiVersion;
import io.strimzi.api.annotations.VersionRange;
import io.strimzi.api.kafka.model.AbstractCrdIT;
import io.strimzi.test.CrdUtils;
import io.strimzi.test.TestUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class StructuralCrdIT
extends AbstractCrdIT {
    private static final Map<String, String> CRD_FILES = Map.of("kafkas.kafka.strimzi.io", "040-Crd-kafka.yaml", "kafkaconnects.kafka.strimzi.io", "041-Crd-kafkaconnect.yaml", "kafkatopics.kafka.strimzi.io", "043-Crd-kafkatopic.yaml", "kafkausers.kafka.strimzi.io", "044-Crd-kafkauser.yaml", "kafkamirrormakers.kafka.strimzi.io", "045-Crd-kafkamirrormaker.yaml", "kafkabridges.kafka.strimzi.io", "046-Crd-kafkabridge.yaml", "kafkaconnectors.kafka.strimzi.io", "047-Crd-kafkaconnector.yaml", "kafkamirrormaker2s.kafka.strimzi.io", "048-Crd-kafkamirrormaker2.yaml", "kafkarebalances.kafka.strimzi.io", "049-Crd-kafkarebalance.yaml", "kafkanodepools.kafka.strimzi.io", "04A-Crd-kafkanodepool.yaml");

    @BeforeEach
    public void beforeEach() {
        this.client = new KubernetesClientBuilder().build();
    }

    @AfterEach
    public void afterEach() {
        this.client.close();
    }

    @Test
    public void v1Beta2IsStructuralWithCrdV1() {
        for (Map.Entry<String, String> crd : CRD_FILES.entrySet()) {
            this.assertApiVersionsAreStructural(crd.getKey(), TestUtils.USER_PATH + "/../packaging/install/cluster-operator/" + crd.getValue(), (VersionRange<ApiVersion>)ApiVersion.parseRange((String)"v1beta2+"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertApiVersionsAreStructural(String crdName, String crdPath, VersionRange<ApiVersion> shouldBeStructural) {
        try {
            CrdUtils.createCrd((KubernetesClient)this.client, (String)crdName, (String)crdPath);
            this.assertApiVersionsAreStructuralInApiextensionsV1(crdName, shouldBeStructural);
        }
        finally {
            CrdUtils.deleteCrd((KubernetesClient)this.client, (String)crdName);
        }
    }

    private void assertApiVersionsAreStructuralInApiextensionsV1(String api, VersionRange<ApiVersion> shouldBeStructural) {
        Pattern pattern = Pattern.compile("[^.]spec\\.versions\\[([0-9]+)]\\.[^,]*?");
        CustomResourceDefinition crd = (CustomResourceDefinition)((Resource)this.client.apiextensions().v1().customResourceDefinitions().withName(api)).get();
        Set presentCrdApiVersions = crd.getSpec().getVersions().stream().map(v -> ApiVersion.parse((String)v.getName())).collect(Collectors.toSet());
        Assertions.assertTrue((boolean)presentCrdApiVersions.contains(shouldBeStructural.lower()), (String)("CRD has versions " + String.valueOf(presentCrdApiVersions) + " which doesn't include " + String.valueOf(shouldBeStructural.lower()) + " which should be structural"));
        HashMap<Integer, ApiVersion> indexedVersions = new HashMap<Integer, ApiVersion>();
        int i = 0;
        for (CustomResourceDefinitionVersion version : crd.getSpec().getVersions()) {
            indexedVersions.put(i, ApiVersion.parse((String)version.getName()));
        }
        Optional<CustomResourceDefinitionCondition> first = crd.getStatus().getConditions().stream().filter(cond -> "NonStructuralSchema".equals(cond.getType()) && "True".equals(cond.getStatus())).findFirst();
        if (first.isPresent()) {
            Matcher matcher = pattern.matcher(first.get().getMessage());
            while (matcher.find()) {
                Integer index = Integer.valueOf(matcher.group(1));
                ApiVersion nonStructuralVersion = (ApiVersion)indexedVersions.get(index);
                if (!shouldBeStructural.contains((Comparable)nonStructuralVersion)) continue;
                Assertions.fail((String)(api + "/ " + String.valueOf(nonStructuralVersion) + " should be structural but there's a complaint about " + matcher.group()));
            }
        }
    }
}

