/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.common.JvmOptions;
import io.strimzi.test.ReadWriteUtils;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;

public class JvmOptionsTest {
    @Test
    public void testSetXmxXms() {
        JvmOptions opts = (JvmOptions)ReadWriteUtils.readObjectFromYamlString((String)"-Xmx: 2g\n-Xms: 1g", JvmOptions.class);
        MatcherAssert.assertThat((Object)opts.getXms(), (Matcher)CoreMatchers.is((Object)"1g"));
        MatcherAssert.assertThat((Object)opts.getXmx(), (Matcher)CoreMatchers.is((Object)"2g"));
    }

    @Test
    public void testEmptyXmxXms() {
        JvmOptions opts = (JvmOptions)ReadWriteUtils.readObjectFromYamlString((String)"{}", JvmOptions.class);
        MatcherAssert.assertThat((Object)opts.getXms(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)opts.getXmx(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testXx() {
        JvmOptions opts = (JvmOptions)ReadWriteUtils.readObjectFromYamlString((String)"-XX:\n  key1: value1\n  key2: value2\n  key3: true\n  key4: true\n  key5: 10\n", JvmOptions.class);
        MatcherAssert.assertThat((Object)opts.getXx(), (Matcher)CoreMatchers.is(Map.of("key1", "value1", "key2", "value2", "key3", "true", "key4", "true", "key5", "10")));
        opts = (JvmOptions)ReadWriteUtils.readObjectFromYamlString((String)"{}", JvmOptions.class);
        MatcherAssert.assertThat((Object)opts.getXx(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }
}

