/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionSpec;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.strimzi.test.ReadWriteUtils;
import io.strimzi.test.TestUtils;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Stack;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ExamplesTest {
    @Test
    public void examples() {
        this.validateRecursively(new File(TestUtils.USER_PATH + "/../packaging/examples"));
    }

    private void validateRecursively(File directory) {
        for (File f : directory.listFiles()) {
            if (f.isDirectory()) {
                if (f.getAbsolutePath().contains("packaging/examples/metrics/grafana") || f.getAbsolutePath().contains("packaging/examples/metrics/prometheus")) continue;
                this.validateRecursively(f);
                continue;
            }
            if (!f.isFile() || !f.getName().endsWith(".yaml") && !f.getName().endsWith(".yml")) continue;
            this.validate(f);
        }
    }

    private void validate(File f) {
        try {
            String content = ReadWriteUtils.readFile((File)f);
            this.validate(content);
        }
        catch (AssertionError | Exception e) {
            throw new AssertionError("Invalid example yaml in " + f.getPath() + ": " + ((Throwable)e).getMessage(), (Throwable)e);
        }
    }

    private void validate(String content) {
        KubernetesResource resource = (KubernetesResource)new KubernetesClientBuilder().build().getKubernetesSerialization().convertValue((Object)content, KubernetesResource.class);
        this.recurseForAdditionalProperties(new Stack<String>(), resource);
    }

    private void recurseForAdditionalProperties(Stack<String> path, Object resource) {
        try {
            Class<?> cls = resource.getClass();
            for (Method method : cls.getMethods()) {
                this.checkForJsonAnyGetter(path, resource, cls, method);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private void checkForJsonAnyGetter(Stack<String> path, Object resource, Class<?> cls, Method method) throws IllegalAccessException, InvocationTargetException {
        if (method.isAnnotationPresent(JsonAnyGetter.class)) {
            HashMap additionalProperties = (HashMap)method.invoke(resource, new Object[0]);
            if (CustomResourceDefinitionSpec.class.equals(cls)) {
                additionalProperties = new HashMap(additionalProperties);
                additionalProperties.remove("validation");
            }
            if (additionalProperties != null && !additionalProperties.isEmpty()) {
                Assertions.fail((String)("object at path " + path.stream().collect(Collectors.joining("/")) + " has additional properties " + String.valueOf(additionalProperties.keySet())));
            }
        } else if (this.isGetter(method)) {
            method.setAccessible(true);
            Object result = method.invoke(resource, new Object[0]);
            if (!(result == null || result.getClass().isPrimitive() || result.getClass().isEnum() || result.getClass().equals(Collections.emptyMap().getClass()))) {
                path.push(method.getName());
                this.recurseForAdditionalProperties(path, result);
                path.pop();
            }
        }
    }

    private boolean isGetter(Method method) {
        String name = method.getName();
        boolean hasGetterName = !name.equals("getClass") && (name.startsWith("get") && name.length() > 3 || name.startsWith("is") && name.length() > 2);
        return method.getParameterCount() == 0 && hasGetterName && !Modifier.isStatic(method.getModifiers()) && !method.getReturnType().equals(Void.TYPE);
    }
}

