/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.strimzi.test.ReadWriteUtils;
import io.strimzi.test.interfaces.TestSeparator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class AbstractCrdIT
implements TestSeparator {
    protected KubernetesClient client;

    protected <T extends CustomResource> void createDeleteCustomResource(String resourceName) {
        File resourceFile = new File(this.getClass().getResource(resourceName).getPath());
        this.createDelete(resourceFile);
    }

    private void createDelete(File resourceFile) {
        RuntimeException creationException = null;
        RuntimeException deletionException = null;
        try (FileInputStream fis = new FileInputStream(resourceFile);){
            try {
                this.client.load((InputStream)fis).create();
            }
            catch (RuntimeException t) {
                creationException = t;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load the resource", e);
        }
        finally {
            try (FileInputStream fis2 = new FileInputStream(resourceFile);){
                this.client.load((InputStream)fis2).delete();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load the resource", e);
            }
            catch (RuntimeException t) {
                deletionException = t;
            }
        }
        if (creationException != null) {
            if (deletionException != null) {
                creationException.addSuppressed(deletionException);
            }
            throw creationException;
        }
        if (deletionException != null) {
            throw deletionException;
        }
    }

    protected <T extends CustomResource> void createScaleDelete(Class<T> resourceClass, String resource) {
        CustomResource model = (CustomResource)ReadWriteUtils.readObjectFromYamlFileInResources((String)resource, resourceClass);
        String apiVersion = model.getApiVersion();
        String kind = model.getKind();
        String resourceName = model.getMetadata().getName();
        String resourceYamlAsString = ReadWriteUtils.writeObjectToYamlString((Object)model);
        this.createScaleDelete(apiVersion, kind, resourceName, resourceYamlAsString);
    }

    private void createScaleDelete(String apiVersion, String kind, String name, String resourceYamlAsString) {
        RuntimeException creationOrScaleException = null;
        RuntimeException deletionException = null;
        try (ByteArrayInputStream bais = new ByteArrayInputStream(resourceYamlAsString.getBytes(StandardCharsets.UTF_8));){
            try {
                this.client.load((InputStream)bais).create();
                ((Resource)this.client.genericKubernetesResources(apiVersion, kind).withName(name)).scale(10);
            }
            catch (RuntimeException t) {
                creationOrScaleException = t;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load the resource", e);
        }
        finally {
            try (ByteArrayInputStream bais2 = new ByteArrayInputStream(resourceYamlAsString.getBytes(StandardCharsets.UTF_8));){
                this.client.load((InputStream)bais2).delete();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load the resource", e);
            }
            catch (RuntimeException t) {
                deletionException = t;
            }
        }
        if (creationOrScaleException != null) {
            if (deletionException != null) {
                creationOrScaleException.addSuppressed(deletionException);
            }
            throw creationOrScaleException;
        }
        if (deletionException != null) {
            throw deletionException;
        }
    }

    protected void assertMissingRequiredPropertiesMessage(String message, String ... requiredProperties) {
        for (String requiredProperty : requiredProperties) {
            MatcherAssert.assertThat((String)("Could not find" + requiredProperty + " in message: " + message), (Object)message, (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.containsStringIgnoringCase((String)(requiredProperty + " in body is required")), CoreMatchers.containsStringIgnoringCase((String)(requiredProperty + ": Required value")), CoreMatchers.containsStringIgnoringCase((String)(requiredProperty.substring(requiredProperty.lastIndexOf(".") + 1) + ": Required value")), CoreMatchers.containsStringIgnoringCase((String)("missing required field \"" + requiredProperty + "\"")), CoreMatchers.containsStringIgnoringCase((String)("missing required field \"" + requiredProperty.substring(requiredProperty.lastIndexOf(".") + 1) + "\""))}));
        }
    }
}

