package io.strimzi.api.kafka.model.zookeeper;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ZookeeperClusterTemplateBuilder extends ZookeeperClusterTemplateFluent<ZookeeperClusterTemplateBuilder> implements VisitableBuilder<ZookeeperClusterTemplate,ZookeeperClusterTemplateBuilder>{
  public ZookeeperClusterTemplateBuilder() {
    this(new ZookeeperClusterTemplate());
  }
  
  public ZookeeperClusterTemplateBuilder(ZookeeperClusterTemplateFluent<?> fluent) {
    this(fluent, new ZookeeperClusterTemplate());
  }
  
  public ZookeeperClusterTemplateBuilder(ZookeeperClusterTemplateFluent<?> fluent,ZookeeperClusterTemplate instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ZookeeperClusterTemplateBuilder(ZookeeperClusterTemplate instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ZookeeperClusterTemplateFluent<?> fluent;
  
  public ZookeeperClusterTemplate build() {
    ZookeeperClusterTemplate buildable = new ZookeeperClusterTemplate();
    buildable.setStatefulset(fluent.buildStatefulset());
    buildable.setPodSet(fluent.buildPodSet());
    buildable.setPod(fluent.buildPod());
    buildable.setClientService(fluent.buildClientService());
    buildable.setNodesService(fluent.buildNodesService());
    buildable.setPersistentVolumeClaim(fluent.buildPersistentVolumeClaim());
    buildable.setPodDisruptionBudget(fluent.buildPodDisruptionBudget());
    buildable.setZookeeperContainer(fluent.buildZookeeperContainer());
    buildable.setServiceAccount(fluent.buildServiceAccount());
    buildable.setJmxSecret(fluent.buildJmxSecret());
    return buildable;
  }
  

}