package io.strimzi.api.kafka.model.zookeeper;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ZookeeperClusterSpecBuilder extends ZookeeperClusterSpecFluent<ZookeeperClusterSpecBuilder> implements VisitableBuilder<ZookeeperClusterSpec,ZookeeperClusterSpecBuilder>{
  public ZookeeperClusterSpecBuilder() {
    this(new ZookeeperClusterSpec());
  }
  
  public ZookeeperClusterSpecBuilder(ZookeeperClusterSpecFluent<?> fluent) {
    this(fluent, new ZookeeperClusterSpec());
  }
  
  public ZookeeperClusterSpecBuilder(ZookeeperClusterSpecFluent<?> fluent,ZookeeperClusterSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ZookeeperClusterSpecBuilder(ZookeeperClusterSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ZookeeperClusterSpecFluent<?> fluent;
  
  public ZookeeperClusterSpec build() {
    ZookeeperClusterSpec buildable = new ZookeeperClusterSpec();
    buildable.setStorage(fluent.buildStorage());
    buildable.setConfig(fluent.getConfig());
    buildable.setLogging(fluent.buildLogging());
    buildable.setReplicas(fluent.getReplicas());
    buildable.setImage(fluent.getImage());
    buildable.setResources(fluent.getResources());
    buildable.setLivenessProbe(fluent.buildLivenessProbe());
    buildable.setReadinessProbe(fluent.buildReadinessProbe());
    buildable.setJvmOptions(fluent.buildJvmOptions());
    buildable.setJmxOptions(fluent.buildJmxOptions());
    buildable.setMetricsConfig(fluent.buildMetricsConfig());
    buildable.setTemplate(fluent.buildTemplate());
    return buildable;
  }
  

}