package io.strimzi.api.kafka.model.user.acl;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class AclRuleTopicResourceBuilder extends AclRuleTopicResourceFluent<AclRuleTopicResourceBuilder> implements VisitableBuilder<AclRuleTopicResource,AclRuleTopicResourceBuilder>{
  public AclRuleTopicResourceBuilder() {
    this(new AclRuleTopicResource());
  }
  
  public AclRuleTopicResourceBuilder(AclRuleTopicResourceFluent<?> fluent) {
    this(fluent, new AclRuleTopicResource());
  }
  
  public AclRuleTopicResourceBuilder(AclRuleTopicResourceFluent<?> fluent,AclRuleTopicResource instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public AclRuleTopicResourceBuilder(AclRuleTopicResource instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  AclRuleTopicResourceFluent<?> fluent;
  
  public AclRuleTopicResource build() {
    AclRuleTopicResource buildable = new AclRuleTopicResource();
    buildable.setName(fluent.getName());
    buildable.setPatternType(fluent.getPatternType());
    return buildable;
  }
  

}