package io.strimzi.api.kafka.model.user.acl;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class AclRuleGroupResourceBuilder extends AclRuleGroupResourceFluent<AclRuleGroupResourceBuilder> implements VisitableBuilder<AclRuleGroupResource,AclRuleGroupResourceBuilder>{
  public AclRuleGroupResourceBuilder() {
    this(new AclRuleGroupResource());
  }
  
  public AclRuleGroupResourceBuilder(AclRuleGroupResourceFluent<?> fluent) {
    this(fluent, new AclRuleGroupResource());
  }
  
  public AclRuleGroupResourceBuilder(AclRuleGroupResourceFluent<?> fluent,AclRuleGroupResource instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public AclRuleGroupResourceBuilder(AclRuleGroupResource instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  AclRuleGroupResourceFluent<?> fluent;
  
  public AclRuleGroupResource build() {
    AclRuleGroupResource buildable = new AclRuleGroupResource();
    buildable.setName(fluent.getName());
    buildable.setPatternType(fluent.getPatternType());
    return buildable;
  }
  

}