package io.strimzi.api.kafka.model.user.acl;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class AclRuleBuilder extends AclRuleFluent<AclRuleBuilder> implements VisitableBuilder<AclRule,AclRuleBuilder>{
  public AclRuleBuilder() {
    this(new AclRule());
  }
  
  public AclRuleBuilder(AclRuleFluent<?> fluent) {
    this(fluent, new AclRule());
  }
  
  public AclRuleBuilder(AclRuleFluent<?> fluent,AclRule instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public AclRuleBuilder(AclRule instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  AclRuleFluent<?> fluent;
  
  public AclRule build() {
    AclRule buildable = new AclRule(fluent.getType(),fluent.buildResource(),fluent.getHost(),fluent.getOperations());
    buildable.setOperation(fluent.getOperation());
    return buildable;
  }
  

}