package io.strimzi.api.kafka.model.user;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KafkaUserTemplateBuilder extends KafkaUserTemplateFluent<KafkaUserTemplateBuilder> implements VisitableBuilder<KafkaUserTemplate,KafkaUserTemplateBuilder>{
  public KafkaUserTemplateBuilder() {
    this(new KafkaUserTemplate());
  }
  
  public KafkaUserTemplateBuilder(KafkaUserTemplateFluent<?> fluent) {
    this(fluent, new KafkaUserTemplate());
  }
  
  public KafkaUserTemplateBuilder(KafkaUserTemplateFluent<?> fluent,KafkaUserTemplate instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KafkaUserTemplateBuilder(KafkaUserTemplate instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KafkaUserTemplateFluent<?> fluent;
  
  public KafkaUserTemplate build() {
    KafkaUserTemplate buildable = new KafkaUserTemplate();
    buildable.setSecret(fluent.buildSecret());
    return buildable;
  }
  

}